/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Translate;

public class SetAutoPrint
extends CommandListener {
    private static final String autoprint = "setautop";

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        List<String> list;
        if (scriptRunnerContext.get_autoprint() == -6 && (list = DBUtil.getBinds(sQLCommand.getSql(), true)) != null && list.size() > 0) {
            Map map = scriptRunnerContext.getVarMap();
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (!map.containsKey(string)) continue;
                Object v = map.get(string);
                String string2 = "";
                if (v instanceof String) {
                    string2 = (String)v;
                } else if (v instanceof Bind) {
                    string2 = ((Bind)v).getValue();
                }
                this.printBindValue(scriptRunnerContext, string, string2);
            }
        }
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        ScriptParser scriptParser = new ScriptParser(sQLCommand.getSql());
        String string = scriptParser.stripLine(sQLCommand.getSql());
        if (string.startsWith(autoprint)) {
            String string2 = sQLCommand.getSql().trim().substring(sQLCommand.getSql().trim().lastIndexOf(" ")).trim();
            if (string2.equalsIgnoreCase("off")) {
                scriptRunnerContext.set_autoprint(-5);
            } else if (string2.equalsIgnoreCase("on")) {
                scriptRunnerContext.set_autoprint(-6);
            } else {
                String string3 = "autoprint must be set ON or OFF\n";
                try {
                    scriptRunnerContext.getOutputStream().write(Translate.translate(string3).getBytes());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    private void printBindValue(ScriptRunnerContext scriptRunnerContext, String string, String string2) {
        BufferedOutputStream bufferedOutputStream = scriptRunnerContext.getOutputStream();
        string = string.concat("\n");
        try {
            if (string2 == null) {
                bufferedOutputStream.write(string.getBytes());
                bufferedOutputStream.write("------\n".getBytes());
            } else {
                bufferedOutputStream.write(string.getBytes());
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length(); ++i) {
                    stringBuffer.append("-");
                }
                stringBuffer.append("\n");
                bufferedOutputStream.write(stringBuffer.toString().getBytes());
                string2 = string2.concat("\n");
                bufferedOutputStream.write(string2.getBytes());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

