/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.TreeMap;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;

public class AutoTrace
extends CommandListener {
    public static final String ctxTrace = "AUTOTRACE_STATE";
    public static final String SPACE = "                                                                                ";
    private String statSql = "select ms.Statistic# stat,ms.value,sn.name from v$mystat ms, v$statname  sn where sn.statistic# = ms.statistic# and ms.Statistic# in (7,47,50,54,134,335,336,337,341,342) order by 1";
    private ResultSet _rset = null;
    private HashMap<Integer, stat> bStats;
    private HashMap<Integer, stat> aStats;

    public static String lpad(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(SPACE.substring(0, n - string.length()));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public void write(String string, ScriptRunnerContext scriptRunnerContext) {
        BufferedOutputStream bufferedOutputStream = scriptRunnerContext.getOutputStream();
        try {
            bufferedOutputStream.write(string.getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        Boolean bl = (Boolean)scriptRunnerContext.getProperty(ctxTrace);
        if (bl == null) {
            scriptRunnerContext.putProperty(ctxTrace, false);
            bl = false;
        }
        if (bl.booleanValue() && !sQLCommand.getStmtClass().equals("4")) {
            this.bStats = new HashMap();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(this.statSql);
                this._rset = preparedStatement.executeQuery();
                while (this._rset.next()) {
                    stat stat2 = new stat(this._rset.getInt(2), this._rset.getString(3));
                    this.bStats.put(this._rset.getInt(1), stat2);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (((Boolean)scriptRunnerContext.getProperty(ctxTrace)).booleanValue() && !sQLCommand.getStmtClass().equals("4")) {
            Object object;
            this.aStats = new HashMap();
            try {
                object = connection.prepareStatement(this.statSql);
                this._rset = object.executeQuery();
                while (this._rset.next()) {
                    stat stat2 = new stat(this._rset.getInt(2) - this.bStats.get(this._rset.getInt(1)).getValue(), this._rset.getString(3));
                    this.aStats.put(this._rset.getInt(1), stat2);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            try {
                object = connection.prepareStatement("explain plan for " + sQLCommand.getSql());
                this._rset = object.executeQuery();
                object = connection.prepareStatement("SELECT * FROM table(DBMS_XPLAN.DISPLAY)");
                this._rset = object.executeQuery();
                while (this._rset.next()) {
                    this.write(this._rset.getString(1) + "\n", scriptRunnerContext);
                }
                this.write("\n", scriptRunnerContext);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            this.write("   Statistics\n", scriptRunnerContext);
            this.write("-----------------------------------------------------------\n", scriptRunnerContext);
            object = new TreeMap<Integer, stat>(this.aStats);
            for (Object k : object.keySet()) {
                this.write(AutoTrace.lpad(16, String.valueOf(this.aStats.get(k).getValue())) + "  " + this.aStats.get(k).getName() + "\n", scriptRunnerContext);
            }
        }
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        if (sQLCommand.getSql().toLowerCase().indexOf("set autotrace on") == 0) {
            scriptRunnerContext.putProperty(ctxTrace, true);
            this.write("AutoTrace Enabled\n", scriptRunnerContext);
            return true;
        }
        if (sQLCommand.getSql().toLowerCase().indexOf("set autotrace off") == 0) {
            scriptRunnerContext.putProperty(ctxTrace, false);
            this.write("AutoTrace Disabled\n", scriptRunnerContext);
            return true;
        }
        return false;
    }

    public class stat {
        int _value;
        String _name;

        public stat(int n, String string) {
            this._value = n;
            this._name = string;
        }

        public String getName() {
            return this._name;
        }

        public int getValue() {
            return this._value;
        }
    }
}

