/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.dbtools.raptor.scriptrunner.CommandRegistry;
import oracle.dbtools.raptor.scriptrunner.PLSQL;
import oracle.dbtools.raptor.scriptrunner.SQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLPLUS;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.scriptrunner.Substitution;
import oracle.ide.Ide;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleDriver;

public class ScriptRunner
extends Thread {
    private Connection conn;
    private String directory = null;
    private ScriptRunnerContext scriptRunnerContext = null;
    private boolean printComments = false;
    private BufferedOutputStream out = null;
    private final String ENCODING = "UTF-8";
    private SQL sql;
    private PLSQL plsql;
    private boolean interrupted = false;
    public boolean finished = false;
    private SQLCommand[] cmds;
    private URL _baseURL;

    public void interrupt() {
        this.interrupted = true;
        if (this.sql != null) {
            this.sql.interrupt();
        }
        super.interrupt();
    }

    private ScriptRunner() {
    }

    public ScriptRunner(Connection connection) {
        this.setConn(connection);
    }

    public ScriptRunner(String string, Connection connection) {
        this.setConn(connection);
        this.setStmt(string);
    }

    public ScriptRunner(InputStream inputStream, Connection connection) {
        this.setConn(connection);
        this.setStmt(inputStream);
    }

    public ScriptRunner(Reader reader, Connection connection) {
        this.setConn(connection);
        this.setStmt(reader);
    }

    public ScriptRunner(URL uRL, Connection connection) {
        try {
            this.setConn(connection);
            this.setStmt(uRL.openStream());
            this._baseURL = uRL;
        }
        catch (IOException iOException) {
            System.err.println("Could not process url:" + uRL.toString());
        }
    }

    public void setStmt(String string) {
        ScriptParser scriptParser = new ScriptParser(string, this.conn);
        scriptParser.parse();
        this.cmds = scriptParser.getSqlStatements();
    }

    private void setStmt(InputStream inputStream) {
        this.setStmt(new InputStreamReader(inputStream));
    }

    private void setStmt(Reader reader) {
        ScriptParser scriptParser = new ScriptParser(reader, this.conn);
        scriptParser.parse();
        this.cmds = scriptParser.getSqlStatements();
    }

    public void run(SQLCommand sQLCommand) throws IOException {
        Object object;
        this.getScriptRunnerContext().setOutputStream(this.out);
        boolean bl = this.getConn() instanceof OracleConnection;
        CommandRegistry.fireBeginListeners(this.conn, this.getScriptRunnerContext(), sQLCommand);
        Substitution substitution = new Substitution(this.getScriptRunnerContext());
        String string = substitution.replaceSubstitution(sQLCommand);
        if (string != null) {
            this.report(string);
            return;
        }
        if (this.getScriptRunnerContext().getVerify() == -4) {
            object = (sQLCommand.getSql() + "\n").getBytes("UTF-8");
            this.out.write((byte[])object);
        }
        if (!this.getScriptRunnerContext().getExited()) {
            if (sQLCommand.getStmtClass().equals("8")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("2") && (sQLCommand.getStmtId().equals("32") && bl || !sQLCommand.getStmtId().equals("32"))) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.sql = new SQL(sQLCommand, this.out);
                    this.sql.setScriptRunnerContext(this.getScriptRunnerContext());
                    this.sql.setConn(this.conn);
                    if (sQLCommand.getStmtId().equals("32")) {
                        object = (sQLCommand.getSQLOrig() + "\n").getBytes("UTF-8");
                        this.out.write((byte[])object);
                    }
                    if (this.getScriptRunnerContext().getVerify() == -4) {
                        // empty if block
                    }
                    this.sql.run();
                    this.setScriptRunnerContext(this.sql.getScriptRunnerContext());
                    this.sql = null;
                }
            } else if (sQLCommand.getStmtClass().equals("3")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    object = new PLSQL(sQLCommand, this.out);
                    object.setScriptRunnerContext(this.getScriptRunnerContext());
                    object.setConn(this.conn);
                    object.run();
                    this.setScriptRunnerContext(object.getScriptRunnerContext());
                    object = null;
                }
            } else if (sQLCommand.getStmtClass().equals("4")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    object = new SQLPLUS(sQLCommand, this.out);
                    object.setScriptRunnerContext(this.getScriptRunnerContext());
                    object.setConn(this.conn);
                    object.setDirectory(this.directory);
                    object.run();
                    this.conn = object.getConn();
                    this.setScriptRunnerContext(object.getScriptRunnerContext());
                    object = null;
                }
            } else if (sQLCommand.getStmtClass().equals("5")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("6")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("7")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.printComment(sQLCommand.getSql());
                }
            } else if (sQLCommand.getStmtClass().equals("1")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.unknown(ScriptRunnerDbArb.getString(31), sQLCommand);
                }
            } else if (sQLCommand.getStmtClass().equals("9")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.unknown("set", sQLCommand);
                }
            } else if (sQLCommand.getStmtClass().equals("10")) {
                if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                    this.unknown("create", sQLCommand);
                }
            } else if (!CommandRegistry.fireListeners(this.conn, this.getScriptRunnerContext(), sQLCommand)) {
                this.unknown("class", sQLCommand);
            }
        }
        CommandRegistry.fireEndListeners(this.conn, this.getScriptRunnerContext(), sQLCommand);
        if (this.scriptRunnerContext.getProperty("script.runner.using.systemout") == null || !((Boolean)this.scriptRunnerContext.getProperty("script.runner.using.systemout")).booleanValue()) {
            this.out.write("force_print\n".getBytes());
        }
        this.out.flush();
    }

    public void run() {
        block20: {
            if (this.scriptRunnerContext.getTopLevel()) {
                this.scriptRunnerContext.setBaseConnection(this.conn);
            }
            if (this._baseURL != null) {
                this.scriptRunnerContext.setLastUrl(this._baseURL);
            }
            this.scriptRunnerContext.putProperty("script.runner.base.url", this._baseURL);
            this.scriptRunnerContext.putProperty("total_cmd_count", this.cmds.length);
            if (this.out == null) {
                this.out = new BufferedOutputStream(System.out);
                this.scriptRunnerContext.putProperty("script.runner.using.systemout", Boolean.TRUE);
            }
            this.getScriptRunnerContext().putProperty("sqldev.error", Boolean.FALSE);
            CommandRegistry.fireBeginScriptListeners(this.conn, this.getScriptRunnerContext(), this.cmds);
            int n = this.cmds.length;
            for (int i = 0; i < n; ++i) {
                try {
                    if (this.interrupted) {
                        this.interrupted = false;
                        break;
                    }
                    this.scriptRunnerContext.putProperty("output_stream", this.out);
                    this.scriptRunnerContext.putProperty("current_cmd_count", i);
                    this.run(this.cmds[i]);
                    if (this.scriptRunnerContext.getExited()) {
                        break;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        this.out.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.finished = true;
            }
            CommandRegistry.fireEndScriptListeners(this.conn, this.getScriptRunnerContext(), this.cmds);
            if (this.scriptRunnerContext.getTopLevel() && this.scriptRunnerContext.getCloseConnection()) {
                try {
                    this.conn.commit();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (this.scriptRunnerContext.getTopLevel()) {
                if (this.scriptRunnerContext.getExited()) {
                    this.scriptRunnerContext.reInitOnExit();
                } else {
                    this.scriptRunnerContext.reInitNoExit();
                }
            }
            try {
                this.out.flush();
            }
            catch (IOException iOException) {
                if (this.interrupted) break block20;
                iOException.printStackTrace();
            }
        }
    }

    public void finished() {
    }

    private void unknown(String string, SQLCommand sQLCommand) {
        try {
            Ide.getStatusBar().setText(ScriptRunnerDbArb.getString(31));
            String string2 = ScriptRunnerDbArb.format(16, new Integer(sQLCommand.startLine + 1), sQLCommand.getSQLOrig(), ScriptRunnerDbArb.format(32, string));
            this.out.write(string2.getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void printComment(String string) throws IOException {
        if (this.printComments) {
            this.out.write(string.getBytes("UTF-8"));
        }
    }

    private boolean replaceSubstitution(SQLCommand sQLCommand) {
        return false;
    }

    public BufferedOutputStream getOut() {
        return this.out;
    }

    public void setOut(BufferedOutputStream bufferedOutputStream) {
        this.out = bufferedOutputStream;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    public boolean isPrintComments() {
        return this.printComments;
    }

    public void setPrintComments(boolean bl) {
        this.printComments = bl;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public static void usage() {
        System.out.println("Usage: java oracle.dbdeveloper.db.scripts.ScriptRunner username/password@host:port:sid @file1 @file2 @file3 ...");
        System.exit(1);
    }

    public static String[] nextToChar(String string, char c) {
        int n = string.indexOf(c);
        if (n == -1) {
            ScriptRunner.usage();
        }
        String string2 = n == string.length() - 1 ? "" : string.substring(n + 1);
        String[] stringArray = new String[]{string.substring(0, n), string2};
        return stringArray;
    }

    public static void main(String[] stringArray) throws SQLException {
        block13: {
            if (stringArray.length == 0) {
                ScriptRunner.usage();
            }
            DriverManager.registerDriver((Driver)new OracleDriver());
            String[] stringArray2 = ScriptRunner.nextToChar(stringArray[0], '/');
            String string = stringArray2[0];
            stringArray2 = ScriptRunner.nextToChar(stringArray2[1], '@');
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            if (string3.indexOf(58) == -1) {
                string3 = "127.0.0.1:1521:" + string3;
            }
            String string4 = "jdbc:oracle:thin:@" + string3;
            URL uRL = string4.getClass().getResource("/oracle/dbtools/db/foo.sql");
            System.out.println(uRL.toString());
            Connection connection = DriverManager.getConnection(string4, string, string2);
            connection.setAutoCommit(false);
            int n = 0;
            try {
                int n2 = stringArray.length;
                for (int i = 1; i < n2; ++i) {
                    ScriptRunner scriptRunner;
                    n = i;
                    long l = System.currentTimeMillis();
                    System.out.println("File:" + stringArray[i]);
                    String string5 = stringArray[i];
                    URL uRL2 = null;
                    try {
                        uRL2 = new URL(string5);
                        scriptRunner = new ScriptRunner(uRL2, connection);
                        scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                        scriptRunner.run();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL2 == null) {
                        FileInputStream fileInputStream = null;
                        if (string5.startsWith("@") && string5.length() > 1) {
                            string5 = string5.substring(1);
                        }
                        if (string5.endsWith(".sql")) {
                            fileInputStream = new FileInputStream(new File(string5));
                        } else {
                            try {
                                fileInputStream = new FileInputStream(new File(string5 + ".sql"));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileInputStream = new FileInputStream(new File(string5));
                            }
                        }
                        scriptRunner = new ScriptRunner(fileInputStream, connection);
                        scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                        scriptRunner.run();
                    }
                    System.out.println("Elapsed:" + (System.currentTimeMillis() - l));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File:" + stringArray[n] + " not found.");
                if (stringArray.length - 1 <= n) break block13;
                System.out.println("Skipping remaining files.");
            }
        }
        System.out.println("Exiting");
    }

    protected void report(String string) {
        if (this.out != null) {
            try {
                this.out.write(string.getBytes("UTF-8"));
                this.out.write(10);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getStatusLine() {
        return Ide.getStatusBar().getText();
    }

    public void setStatusLine(String string) {
        Ide.getStatusBar().setText(string);
    }

    public SQLCommand[] getCmds() {
        return this.cmds;
    }

    public void setCmds(SQLCommand[] sQLCommandArray) {
        this.cmds = sQLCommandArray;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }
}

