/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.scriptrunner.SQL;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.jdbc.OracleConnection;

public class ScriptParser {
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private static String[][] startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};
    private Connection conn;
    private SQL sql;
    private ArrayList sqlArray = new ArrayList();
    private String rawSQL;
    private BufferedReader reader = null;
    private int readerLineCnt = 0;
    private int startReaderLineCnt = 0;
    private int state = 0;
    private String quoteString = "";

    public ScriptParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public ScriptParser(Reader reader) {
        this(reader, null);
    }

    public ScriptParser(InputStream inputStream, Connection connection) {
        this(new InputStreamReader(inputStream), connection);
    }

    public ScriptParser(Reader reader, Connection connection) {
        this.scriptParserInit(reader, connection);
    }

    private void scriptParserInit(Reader reader, Connection connection) {
        this.conn = connection;
        this.reader = new BufferedReader(reader);
    }

    public ScriptParser(String string) {
        this(string, null);
    }

    public ScriptParser(String string, Connection connection) {
        this(new StringReader(string), connection);
        this.rawSQL = string;
    }

    public void setSQL(SQL sQL) {
        this.sql = sQL;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        ScriptParser scriptParser = new ScriptParser(fileInputStream);
        scriptParser.parse();
    }

    public void parse() {
        StringBuffer stringBuffer = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray = null;
        String string6 = null;
        int n = 0;
        this.readerLineCnt = 0;
        this.startReaderLineCnt = 0;
        try {
            while (true) {
                int n2;
                this.state = 0;
                int n3 = 0;
                String string7 = "";
                this.startReaderLineCnt = this.readerLineCnt;
                n = 1;
                stringBuffer = new StringBuffer();
                if (string6 != null) {
                    string3 = string6;
                    string6 = null;
                } else {
                    string3 = this.getTop();
                    if (string3 == null) break;
                }
                string = null;
                string2 = null;
                string4 = null;
                string5 = null;
                int n4 = SQLStatementTypes.stmts.length;
                for (n2 = 0; n2 < n4 && string == null; ++n2) {
                    if (string3.indexOf(SQLStatementTypes.stmts[n2][0]) != 0 && (n2 != 0 || string3 != null && !string3.equals(""))) continue;
                    string = SQLStatementTypes.stmts[n2][1];
                    string2 = SQLStatementTypes.stmts[n2][2];
                    string4 = SQLStatementTypes.stmts[n2][3];
                    if (SQLStatementTypes.stmts[n2].length < 5) continue;
                    string5 = SQLStatementTypes.stmts[n2][4];
                }
                if (string == null) {
                    stringArray = string3.trim().split("[ \n\r\t]");
                    if (stringArray[0] != null && stringArray[0].length() > 0 && stringArray[0].charAt(stringArray[0].length() - 1) == ';') {
                        stringArray[0] = stringArray[0].replaceAll(";", "");
                    }
                    n4 = SQLStatementTypes.tokenStmts.length;
                    for (n2 = 0; n2 < n4 && string == null; ++n2) {
                        if (!stringArray[0].toLowerCase().equals(SQLStatementTypes.tokenStmts[n2][0])) continue;
                        string = SQLStatementTypes.tokenStmts[n2][1];
                        string2 = SQLStatementTypes.tokenStmts[n2][2];
                        string4 = SQLStatementTypes.tokenStmts[n2][3];
                        if (SQLStatementTypes.tokenStmts[n2].length < 5) continue;
                        string5 = SQLStatementTypes.tokenStmts[n2][4];
                    }
                    if (string == null) {
                        string = "4";
                        string2 = "1";
                        string4 = "N";
                    }
                    String string8 = this.stripLine(string3);
                    if (string.equals("10")) {
                        if (this.checkCreateType(string8).equals("plsql")) {
                            string = "3";
                            string2 = "27";
                            string4 = "Y";
                        } else {
                            string = "2";
                            string2 = "26";
                            string4 = "Y";
                        }
                    } else if (string.equals("9")) {
                        if (this.checkSetType(string8).equals("sql")) {
                            string = "2";
                            string2 = "74";
                            string4 = "Y";
                        } else {
                            string = "4";
                            string2 = "73";
                            string4 = "N";
                        }
                    }
                }
                n2 = 1;
                boolean bl = false;
                if (string.equals("2")) {
                    while (n2 != 0) {
                        if (string3 == null) {
                            n4 = 0;
                        } else {
                            int[] nArray = this.numberOfQuotes(string3);
                            n4 = nArray[0];
                            n3 = nArray[1];
                        }
                        if (n4 % 2 != 0) {
                            boolean bl2 = bl = !bl;
                        }
                        if (string3 != null && !bl) {
                            if (string3.trim().endsWith(";") && n3 == 0) {
                                n2 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf(";"));
                            } else if (string3.trim().endsWith("\n/") || string3.trim().equals("/")) {
                                n2 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("/"));
                            } else if (string3.trim().equals(".")) {
                                n2 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("."));
                            }
                            stringBuffer.append(string3 + "\n");
                            if (n2 != 0) {
                                string3 = this.reader.readLine();
                                ++n;
                                ++this.readerLineCnt;
                            }
                        } else {
                            stringBuffer.append(string3 + "\n");
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                        }
                        if (string3 != null) continue;
                        n2 = 0;
                    }
                } else if (string.equals("3")) {
                    while (n2 != 0) {
                        if (string3 == null) {
                            n4 = 0;
                        } else {
                            int[] nArray = this.numberOfQuotes(string3);
                            n4 = nArray[0];
                            n3 = nArray[1];
                        }
                        if (string3 != null && (n4 == 0 || n4 % 2 == 1)) {
                            if (string3.trim().endsWith("\n/") || string3.trim().equals("/")) {
                                n2 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("/"));
                            } else if (string3.trim().equals(".")) {
                                n2 = 0;
                                string3 = string3.substring(0, string3.lastIndexOf("."));
                            }
                        }
                        stringBuffer.append(string3 + "\n");
                        if (n2 != 0) {
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                        }
                        if (string3 != null) continue;
                        n2 = 0;
                    }
                } else if (string.equals("4")) {
                    while (n2 != 0) {
                        if (string3.trim().endsWith("-")) {
                            n2 = 1;
                            stringBuffer.append(string3 + "\n");
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                            if (string3 != null) continue;
                            n2 = 0;
                            continue;
                        }
                        n2 = 0;
                        stringBuffer.append(string3 + "\n");
                    }
                } else if (string.equals("5")) {
                    stringBuffer.append(string3 + "\n");
                } else if (!string.equals("6") && !string.equals("8")) {
                    if (string.equals("1")) {
                        System.err.println(ScriptRunnerDbArb.format(33, string3));
                    } else if (string.equals("7")) {
                        while (n2 != 0) {
                            int n5 = string3.indexOf("*/");
                            if (n5 >= 0) {
                                n2 = 0;
                                if (n5 + 2 == string3.length()) {
                                    string6 = "";
                                } else {
                                    string6 = string3.substring(n5 + 2);
                                    string3 = string3.substring(0, n5 + 2);
                                }
                                stringBuffer.append(string3 + "\n");
                                continue;
                            }
                            stringBuffer.append(string3 + "\n");
                            string3 = this.reader.readLine();
                            ++n;
                            ++this.readerLineCnt;
                            if (string3 != null) continue;
                            n2 = 0;
                            stringBuffer.append("*/");
                        }
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                while (stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || stringBuffer.charAt(stringBuffer.length() - 1) == '\r') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                }
                SQLCommand sQLCommand = new SQLCommand(stringBuffer.toString());
                sQLCommand.setRunnable(string4);
                sQLCommand.setStmtClass(string);
                sQLCommand.setStmtId(string2);
                sQLCommand.setLines(n);
                sQLCommand.setResultsType(string5);
                sQLCommand.startLine = this.startReaderLineCnt;
                sQLCommand.endLine = this.readerLineCnt - 1;
                if (sQLCommand.getStmtClass().equals("4") && sQLCommand.getStmtId().equals("32") && (this.conn == null || this.conn instanceof OracleConnection)) {
                    this.parseDescribe(sQLCommand);
                }
                this.sqlArray.add(sQLCommand);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String stripLine(String string) {
        String string2 = string;
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replaceAll("\n", "");
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\t", "");
        string2 = string2.toLowerCase();
        return string2;
    }

    public String checkCreateType(String string) {
        String string2 = "sql";
        int n = SQLStatementTypes.sqlCreate.length;
        for (int i = 0; i < n; ++i) {
            if (string.indexOf(SQLStatementTypes.sqlCreate[i]) != 0) continue;
            string2 = "plsql";
        }
        return string2;
    }

    public String checkSetType(String string) {
        String string2 = "sqlplus";
        int n = SQLStatementTypes.setCmds.length;
        for (int i = 0; i < n && !string2.equals("sql"); ++i) {
            if (string.indexOf(SQLStatementTypes.setCmds[i]) != 0) continue;
            string2 = "sql";
        }
        return string2;
    }

    private String getTop() {
        String string = null;
        try {
            string = this.reader.readLine();
            ++this.readerLineCnt;
            if (string == null) {
                return null;
            }
            while (string.trim().equals("")) {
                string = this.reader.readLine();
                ++this.readerLineCnt;
                if (string != null) continue;
                return null;
            }
            this.startReaderLineCnt = this.readerLineCnt - 1;
            if (string.trim().toLowerCase().startsWith("create") || string.trim().toLowerCase().startsWith("drop") || string.trim().toLowerCase().startsWith("alter")) {
                String string2 = "";
                while (string.indexOf(";") == -1 && string.indexOf("/") == -1 && string.toLowerCase().indexOf("begin") == -1 && string2 != null) {
                    string2 = this.reader.readLine();
                    if (string2 != null) {
                        string = string + "\n" + string2;
                    }
                    ++this.readerLineCnt;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public String getRawSQL() {
        return this.rawSQL;
    }

    public void setRawSQL(String string) {
        this.rawSQL = string;
    }

    public SQLCommand[] getSqlStatements() {
        return this.sqlArray.toArray(new SQLCommand[this.sqlArray.size()]);
    }

    public void parseDescribe(SQLCommand sQLCommand) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(sQLCommand.getSql(), " .");
        String[] stringArray2 = new String[2];
        String string = stringTokenizer.nextToken();
        stringArray2[0] = sQLCommand.getSql().indexOf(".") > -1 ? stringTokenizer.nextToken().replaceAll("\"", "").toUpperCase() : "";
        try {
            stringArray2[1] = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            stringArray2[1] = "unknown_table";
        }
        stringArray2[1] = stringArray2[1].replaceAll("\n", "");
        stringArray2[1] = stringArray2[1].replaceAll("\r", "");
        stringArray2[1] = stringArray2[1].replaceAll(";", "");
        String string2 = this.getObjType(stringArray2[1], stringArray2[0]);
        if (string2.indexOf("\n") > -1) {
            string2 = string2.split("\n")[0];
        }
        if (string2.equals("SYNONYM")) {
            stringArray = this.getBaseSynonymObj(stringArray2[1], stringArray2[0]);
            string2 = stringArray[2];
            stringArray2[0] = stringArray[0];
            stringArray2[1] = stringArray[1];
        }
        stringArray = ScriptRunnerDbArb.getString(35);
        String string3 = ScriptRunnerDbArb.getString(36);
        String string4 = ScriptRunnerDbArb.getString(37);
        String string5 = ScriptRunnerDbArb.getString(38);
        String string6 = ScriptRunnerDbArb.getString(39);
        stringArray2[1] = stringArray2[1].indexOf("\"") > -1 ? stringArray2[1].replaceAll("\"", "") : stringArray2[1].replaceAll("\"", "").toUpperCase();
        if (string2.equals("TABLE") || string2.equals("VIEW") || string2.endsWith("MATERIALIZED VIEW")) {
            if (!stringArray2[0].equals("")) {
                sQLCommand.setSql("select t.column_name \"" + (String)stringArray + "\", \n" + "decode(t.nullable,'Y',null,'NOT NULL') \"" + string3 + "\", \n" + "UPPER(t.data_type)||  \n" + "case when (   t.data_type='VARCHAR' \n" + "           OR t.data_type = 'VARCHAR2' \n" + "           OR t.data_type ='RAW' \n" + "           OR t.data_type='CHAR') AND (\n" + "           t.data_length <> 0 AND \n" + "           nvl(t.data_length,-1) <> -1)   " + "     then \n" + "           case when(t.char_used ='C' and 'BYTE' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.char_length || ' CHAR)'\n" + "                when(t.char_used ='B' and 'CHAR' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.data_length || ' BYTE)'\n" + "                else '(' || t.char_length || ')' \n" + "           end    \n" + "     when (t.data_type='NVARCHAR2' OR t.data_type='NCHAR') then  \n" + "     '(' || t.data_length/2 || ')'   \n" + "     when (t.data_type like 'TIMESTAMP%' OR t.data_type like 'INTERVAL DAY%' OR t.data_type like 'INTERVAL YEAR%' OR t.data_type = 'DATE' OR(t.data_type = 'NUMBER' AND (t.data_precision = 0 OR nvl(t.data_precision,-1) = -1))) then\n" + "      '' \n" + "     when (t.data_scale  = 0 OR nvl(t.data_scale,-1) = -1) then\n" + "      '('|| t.data_precision ||')'\n" + "     else\n" + "        '('|| t.data_precision ||',' ||t.data_scale ||')'    \n" + "end \"" + string4 + "\"   \n" + "from sys.all_tab_columns t, sys.all_col_comments c where t.column_name = c.column_name and c.owner = t.owner and c.table_name = t.table_name and t.owner = :1 and t.table_name = :2 order by t.column_id\n");
                sQLCommand.addBind(stringArray2[0]);
                sQLCommand.addBind(stringArray2[1]);
            } else {
                sQLCommand.setSql("select t.column_name \"" + (String)stringArray + "\", \n" + "decode(t.nullable,'Y',null,'NOT NULL') \"" + string3 + "\", \n" + "UPPER(t.data_type)||  \n" + "case when (   t.data_type='VARCHAR' \n" + "           OR t.data_type = 'VARCHAR2' \n" + "           OR t.data_type ='RAW' \n" + "           OR t.data_type='CHAR') AND (\n" + "           t.data_length <> 0 AND \n" + "           nvl(t.data_length,-1) <> -1)  " + "     then \n" + "           case when(t.char_used ='C' and 'BYTE' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.char_length || ' CHAR)'\n" + "                when(t.char_used ='B' and 'CHAR' =(select value from nls_session_parameters where PARAMETER='NLS_LENGTH_SEMANTICS')) then '(' || t.data_length || ' BYTE)'\n" + "                else '(' || t.char_length || ')' \n" + "           end    \n" + "     when (t.data_type='NVARCHAR2' OR t.data_type='NCHAR') then  \n" + "     '(' || t.data_length/2 || ')'   \n" + "     when (t.data_type like 'TIMESTAMP%' OR t.data_type like 'INTERVAL DAY%' OR t.data_type like 'INTERVAL YEAR%' OR t.data_type = 'DATE' OR(t.data_type = 'NUMBER' AND (t.data_precision = 0 OR nvl(t.data_precision,-1) = -1))) then\n" + "      '' \n" + "     when (t.data_scale  = 0 OR nvl(t.data_scale,-1) = -1) then\n" + "      '('|| t.data_precision ||')'\n" + "     else\n" + "        '('|| t.data_precision ||',' ||t.data_scale ||')'    \n" + "end \"" + string4 + "\"   \n" + "from sys.all_tab_columns t, sys.all_col_comments c where t.column_name = c.column_name and c.owner = t.owner and c.table_name = t.table_name and  UPPER(t.owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) and t.table_name = :1 order by t.column_id\n");
                sQLCommand.addBind(stringArray2[1]);
            }
        } else if (string2.startsWith("PACKAGE")) {
            if (!stringArray2[0].equals("")) {
                if (this.isDefaultDetailsAvailable()) {
                    sQLCommand.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + " decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " decode(d.default#,1,'DEFAULT','') \"" + string6 + "\"\n" + " from all_arguments t ,sys.argument$ d\n" + " where owner= :1 \n" + " and package_name= :2 \n" + " and data_level < 1 \n" + " and d.obj#=t.object_id \n" + " and d.procedure$ = t.object_name\n" + " and d.position# || d.argument = t.position || t.argument_name\n" + " order by t.object_name,t.overload,t.position");
                } else {
                    sQLCommand.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + " decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " 'unknown' \"" + string6 + "\"\n" + " from all_arguments t" + " where owner= :1 \n" + " and package_name= :2 \n" + " and data_level < 1 \n" + " order by t.object_name,t.overload,t.position");
                }
                sQLCommand.addBind(stringArray2[0]);
                sQLCommand.addBind(stringArray2[1]);
            } else {
                if (this.isDefaultDetailsAvailable()) {
                    sQLCommand.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"Argument Name\",\n decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " decode(d.default#,1,'DEFAULT','') \"" + string6 + "\"\n" + " from all_arguments t ,sys.argument$ d\n" + " where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + " and package_name= :1 \n" + " and d.obj#=t.object_id \n" + " and d.procedure$ = t.object_name\n" + " and d.position# || d.argument = t.position || t.argument_name\n" + " and data_level < 1 \n" + " order by t.object_name,t.overload,t.position");
                } else {
                    sQLCommand.setSql("select decode(t.overload,null,t.object_name,t.object_name||' ('||to_char(t.overload)||')')||decode(t.position,0,' (FUNCTION)','') procedure,\n nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + " decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + " t.in_out \"IN/OUT\",\n" + " 'unknown' \"" + string6 + "\"\n" + " from all_arguments t " + " where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + " and package_name= :1 \n" + " and data_level < 1 \n" + " order by t.object_name,t.overload,t.position");
                }
                sQLCommand.addBind(stringArray2[1]);
            }
        } else if (string2.equals("FUNCTION") || string2.equals("PROCEDURE")) {
            if (!stringArray2[0].equals("")) {
                if (this.isDefaultDetailsAvailable()) {
                    sQLCommand.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  decode(d.default#, NULL,NULL,'DEFAULT') \"" + string6 + "\" \n" + "  from all_arguments t,\n" + "  sys.argument$ d\n" + "  where owner= :1 \n" + "  and object_name= :2 \n" + "  and t.object_id = d.obj#\n" + "  and t.POSITION = d.POSITION#\n" + "  order by object_name,overload,position");
                } else {
                    sQLCommand.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  'unknown' \"" + string6 + "\" \n" + "  from all_arguments t\n" + "  where owner= :1 \n" + "  and object_name= :2 \n" + "  order by object_name,overload,position");
                }
                sQLCommand.addBind(stringArray2[0]);
                sQLCommand.addBind(stringArray2[1]);
            } else {
                if (this.isDefaultDetailsAvailable()) {
                    sQLCommand.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  decode(d.default#, NULL,NULL,'DEFAULT') \"" + string6 + "\" \n" + "  from all_arguments t,\n" + "  sys.argument$ d\n" + "  where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + "  and object_name= :1 \n" + "  and t.object_id = d.obj#\n" + "  and t.POSITION = d.POSITION#\n" + "  order by object_name,overload,position");
                } else {
                    sQLCommand.setSql("  select \n  nvl(t.argument_name,decode(t.in_out,'OUT','<return value>','<none>')) \"" + string5 + "\",\n" + "  decode(t.type_subname,null,decode(t.data_type,'VARCHAR2',decode(t.data_length,null,t.data_type,t.data_type||' ('||t.data_length||')'),t.data_type),t.data_type||' ('||t.type_subname||')') \"" + string4 + "\" ,\n" + "  t.in_out \"In/Out\", \n" + "  'unknown' \"" + string6 + "\" \n" + "  from all_arguments t\n" + "  where UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))\n" + "  and object_name= :1 \n" + "  order by object_name,overload,position");
                }
                sQLCommand.addBind(stringArray2[1]);
            }
        } else if (string2.startsWith("TYPE")) {
            String string7 = " select  replace(text,chr(10)) \"user type definition\" from all_source ";
            if (!stringArray2[0].equals("")) {
                string7 = string7 + " where owner = :3 and name = :4 ";
                sQLCommand.setSql(string7);
                sQLCommand.addBind(stringArray2[0]);
                sQLCommand.addBind(stringArray2[1]);
            } else {
                string7 = string7 + " where name = :4 ";
                sQLCommand.setSql(string7);
                sQLCommand.addBind(stringArray2[1]);
            }
        } else {
            sQLCommand.setSql("select '" + ScriptRunnerDbArb.format(1, stringArray2[1]) + "' \"ERROR:\"  from dual");
        }
        sQLCommand.setStmtClass("2");
        sQLCommand.setResultsType("1");
    }

    private String[] getBaseSynonymObj(String string, String string2) {
        String string3 = "select table_owner ,table_name from all_synonyms where  synonym_name = '";
        String string4 = string.replaceAll("\"", "");
        string3 = string.startsWith("\"") ? string3 + string4 + "'" : string3 + string4.toUpperCase() + "'";
        string3 = !string2.trim().equals("") ? string3 + " and owner ='" + string2 + "'" : string3 + " and ( owner = 'PUBLIC'  OR UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA')) )";
        String string5 = this.executeQuery(string3);
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (string5 == null || string5.trim().equals("")) {
            string5 = "";
        } else {
            string6 = string5.substring(0, string5.indexOf(":"));
            string7 = string5.substring(string5.indexOf(":") + 1);
            string7 = string7.substring(0, string7.length() - 1);
            string8 = this.getObjType(string7, string6);
        }
        String[] stringArray = new String[]{string6, string7, string8};
        return stringArray;
    }

    private boolean isDefaultDetailsAvailable() {
        String string = "select 'available' from sys.argument$ where rownum <=1";
        String string2 = this.executeQuery(string);
        return string2.equals("available");
    }

    private boolean isSystemTable(String string) {
        String string2 = string.replaceAll("\"", "");
        String string3 = "";
        string3 = string.startsWith("\"") ? "select table_name from dictionary where table_name = '" + string2 + "'" : "select table_name from dictionary where table_name = '" + string2.toUpperCase() + "'";
        String string4 = this.executeQuery(string3);
        return string4 != null && !string4.trim().equals("");
    }

    private String getObjType(String string, String string2) {
        String string3 = " select object_type  from all_objects  where object_name ='";
        String string4 = string.replaceAll("\"", "");
        string3 = string.startsWith("\"") ? string3 + string4 + "'" : string3 + string4.toUpperCase() + "'";
        String string5 = "";
        string5 = string2.equals("") ? string3 + " and UPPER(owner)= UPPER(sys_context('USERENV', 'CURRENT_SCHEMA'))" : string3 + " and owner= '" + string2 + "'";
        String string6 = this.executeQuery(string5);
        if (string6 == null) {
            string6 = "";
        }
        if (string2.equals("") && string6.trim().equals("")) {
            string5 = string3 + "and OBJECT_TYPE ='SYNONYM'";
            string6 = this.executeQuery(string5);
            if (string6 == null) {
                string6 = "";
            } else if (!string6.trim().equals("")) {
                string6 = "SYNONYM";
            }
        }
        if (string6.indexOf("TABLE PARTITION") != -1) {
            string6 = "TABLE";
        }
        return string6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeQuery(String string) {
        String string2 = "";
        Statement statement = null;
        ResultSet resultSet = null;
        if (this.conn == null) {
            return null;
        }
        try {
            int n;
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            resultSet.next();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            if (n2 == 1) {
                string2 = string2 + resultSet.getString(1);
            } else {
                for (n = 1; n <= n2; ++n) {
                    string2 = string2 + resultSet.getString(n) + ":";
                }
            }
            while (resultSet.next()) {
                string2 = string2 + "\n";
                if (n2 == 1) {
                    string2 = string2 + resultSet.getString(1);
                    continue;
                }
                for (n = 1; n <= n2; ++n) {
                    string2 = string2 + resultSet.getString(n) + ":";
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    private int[] numberOfQuotes(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if (this.state == 0) {
                int n5;
                int n6 = 100000;
                n4 = 0;
                int n7 = 1;
                for (n7 = 1; n7 < startAndEnd.length; ++n7) {
                    n5 = string.indexOf(startAndEnd[n7][0], n2);
                    if (n5 == -1 || n5 >= n6 || n7 == 5 && n5 + 2 == string.length()) continue;
                    n6 = n5;
                    n4 = n7;
                }
                n7 = 5;
                n5 = string.indexOf("Q'", n2);
                if (n5 != -1 && n5 < n6 && (n7 != 5 || n5 + 2 != string.length())) {
                    n6 = n5;
                    n4 = n7;
                }
                if (n4 == 5) {
                    this.quoteString = string.substring(n6 + 2, n6 + 3);
                    this.quoteString = this.getEndQuoteString(this.quoteString);
                }
                if (n4 == 5) {
                    ++n;
                    this.state = 5;
                    n2 = n6 + 3;
                    continue;
                }
                if (n4 == 4) {
                    ++n;
                    this.state = 4;
                    n2 = n6 + 1;
                    continue;
                }
                if (n4 == 0) {
                    int[] nArray = new int[]{n, 0};
                    return nArray;
                }
                this.state = n4;
                n2 = n6 + startAndEnd[n4][0].length();
                continue;
            }
            String string2 = startAndEnd[this.state][1];
            if (this.state == 5) {
                string2 = this.quoteString + string2;
            }
            if ((n4 = string.indexOf(string2, n2)) == -1) {
                if (this.state == 1) {
                    this.state = 0;
                    if (string.trim().endsWith(";")) {
                        n3 = 1;
                    }
                } else if (this.state != 0 && string.trim().endsWith(";")) {
                    n3 = 1;
                }
                int[] nArray = new int[]{n, n3};
                return nArray;
            }
            n2 = n4 + string2.length();
            if (this.state == 4 || this.state == 5) {
                ++n;
                this.quoteString = "";
            }
            this.state = 0;
        }
    }

    boolean isQuoteStringValid(String string) {
        boolean bl = true;
        if (string.equals("\t") || string.equals("\r") || string.equals("\n") || string.equals(" ")) {
            bl = false;
        }
        return bl;
    }

    String getEndQuoteString(String string) {
        String string2 = string;
        if (string2.equals("[")) {
            string2 = "]";
        } else if (string2.equals("{")) {
            string2 = "}";
        } else if (string2.equals("<")) {
            string2 = ">";
        } else if (string2.equals("(")) {
            string2 = ")";
        }
        return string2;
    }
}

