/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.util.Debug;
import oracle.ide.Ide;
import oracle.jdbc.OraclePreparedStatement;

public abstract class SQLCommandRunner
extends Thread {
    public static final int EXIT = 4;
    public static final int CONTINUE = 0;
    public static final int EXITMASK = 4;
    public static final int ACTIONMASK = 3;
    public static final int ACTIONNONE = 0;
    public static final int ACTIONCOMMIT = 1;
    public static final int ACTIONROLLBACK = 2;
    private ScriptRunnerContext scriptRunnerContext = null;
    protected SQLCommand cmd;
    protected Connection conn;
    protected String connName;
    protected BufferedOutputStream out;
    protected DBUtil dbUtil;
    protected PreparedStatement stmt;
    protected CallableStatement callStmt;
    Statement st;
    Statement cstmt;
    protected Debug debug = new Debug();
    protected String statusLine = null;

    public void interrupt() {
        try {
            if (this.stmt != null) {
                this.stmt.cancel();
            }
            if (this.st != null) {
                this.st.cancel();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.interrupt();
    }

    public SQLCommandRunner(SQLCommand sQLCommand, BufferedOutputStream bufferedOutputStream) {
        this.cmd = sQLCommand;
        this.out = bufferedOutputStream;
        this.dbUtil = new DBUtil();
    }

    protected void report(String string) {
        if (this.statusLine != null) {
            Ide.getStatusBar().setText(string);
        }
        if (this.out != null) {
            try {
                this.out.write(string.getBytes("UTF-8"));
                this.out.write(10);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void doWhenever(boolean bl) {
        int n = 0;
        n = bl ? this.scriptRunnerContext.getSqlError() : this.scriptRunnerContext.getOsError();
        int n2 = n & 3;
        if (n2 == 2) {
            try {
                this.conn.rollback();
                this.report("Rollback");
            }
            catch (SQLException sQLException) {
                this.report(ScriptRunnerDbArb.format(11, "Rollback"));
            }
        } else if (n2 == 1) {
            try {
                this.conn.commit();
                this.report("Commit");
            }
            catch (SQLException sQLException) {
                this.report(ScriptRunnerDbArb.format(11, "Commit"));
            }
        }
        if ((n & 4) == 4) {
            this.scriptRunnerContext.setExited(true);
        }
    }

    public SQLCommand getCmd() {
        return this.cmd;
    }

    public void setCmd(SQLCommand sQLCommand) {
        this.cmd = sQLCommand;
    }

    public String getConnName() {
        return this.connName;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public void write(String string) throws IOException {
        this.out.write(string.getBytes());
    }

    public void setConnName(String string) {
        this.connName = string;
        try {
            Connections connections = Connections.getInstance();
            this.conn = connections.getConnection(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatusLine() {
        return Ide.getStatusBar().getText();
    }

    public void setStatusLine(String string) {
        Ide.getStatusBar().setText(string);
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.scriptRunnerContext = scriptRunnerContext;
    }

    protected boolean setBinds(PreparedStatement preparedStatement, List list) throws SQLException {
        boolean bl = true;
        boolean bl2 = false;
        int n = 1;
        Map map = this.getScriptRunnerContext().getVarMap();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (map.containsKey(string)) {
                block29: {
                    String string2 = ((Bind)map.get(string)).getType();
                    String string3 = ((Bind)map.get(string)).getValue();
                    if (string2.toUpperCase().indexOf("NCHAR") > -1 || string2.toUpperCase().indexOf("NVARCHAR") > -1 || string2.toUpperCase().indexOf("NCLOB") > -1) {
                        ((OraclePreparedStatement)preparedStatement).setFormOfUse(n, (short)2);
                    }
                    if (string2.toUpperCase().indexOf("CHAR") > -1) {
                        if (string3 != null) {
                            preparedStatement.setString(n, string3);
                        } else {
                            preparedStatement.setNull(n, 12);
                        }
                    } else if (string2.toUpperCase().equals("NUMBER")) {
                        try {
                            if (string3 != null) {
                                preparedStatement.setInt(n, Integer.parseInt(string3));
                                break block29;
                            }
                            preparedStatement.setNull(n, 4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            preparedStatement.setInt(n, 0);
                        }
                    } else if (string2.toUpperCase().indexOf("CLOB") > -1) {
                        if (string3 != null) {
                            preparedStatement.setClob(n, (Clob)DataTypesUtil.getCLOB(string3, this.conn));
                        } else {
                            preparedStatement.setNull(n, 2005);
                        }
                    } else if (!string2.toUpperCase().equals("REFCURSOR")) {
                        if (string2.toUpperCase().equals("BINARY_DOUBLE")) {
                            try {
                                if (string3 != null) {
                                    ((OraclePreparedStatement)preparedStatement).setBinaryDouble(n, Double.parseDouble(string3));
                                    break block29;
                                }
                                preparedStatement.setNull(n, 101);
                            }
                            catch (NumberFormatException numberFormatException) {
                                preparedStatement.setString(n, string3);
                            }
                        } else if (string2.toUpperCase().equals("BINARY_FLOAT")) {
                            try {
                                if (string3 != null) {
                                    ((OraclePreparedStatement)preparedStatement).setBinaryFloat(n, Float.parseFloat(string3));
                                } else {
                                    preparedStatement.setNull(n, 100);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                preparedStatement.setString(n, string3);
                            }
                        }
                    }
                }
                ++n;
                continue;
            }
            if (this.cmd.getBinds().size() > 0) {
                bl2 = true;
                continue;
            }
            this.report(ScriptRunnerDbArb.format(28, string));
            bl = false;
            break;
        }
        if (bl2) {
            DBUtil.getInstance().bind(preparedStatement, this.cmd.getBinds());
            bl = true;
        }
        return bl;
    }
}

