/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdbc.OracleConnection;

public class SQL
extends SQLCommandRunner {
    public SQL(SQLCommand sQLCommand, BufferedOutputStream bufferedOutputStream) {
        super(sQLCommand, bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!Connections.getInstance().lock(this.conn)) {
            return;
        }
        try {
            Debug.debug(this.cmd);
            if (this.cmd.getResultsType() == null) {
                this.execute(true);
            } else if (this.cmd.getResultsType().equals("2")) {
                this.reportDML(this.cmd.getStmtId(), this.processDML());
            } else if (this.cmd.getResultsType().equals("1")) {
                this.executeQuery();
            } else if (this.cmd.getStmtId().equals("21")) {
                this.conn.commit();
                if (this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report(Translate.translate("commited"));
                }
            } else if (this.cmd.getStmtId().equals("68")) {
                this.conn.rollback();
                if (this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report(Translate.translate("rolledback"));
                }
            } else if (this.cmd.getResultsType().equals("3")) {
                this.execute(false);
                this.reportThreeWord();
            } else {
                Debug.error("else in SQL was reached with " + this.cmd);
                this.execute(true);
            }
        }
        catch (SQLException sQLException) {
            Object object;
            int n;
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            if ((this.cmd.getResultsType() != null && this.cmd.getResultsType().equals("1") || this.cmd.getStmtId().equals("48") || this.cmd.getStmtId().equals("26") || this.cmd.getStmtId().equals("48") || this.cmd.getStmtId().equals("88") || this.cmd.getStmtId().equals("31") || this.cmd.getStmtId().equals("72") || this.cmd.getStmtId().equals("51") || this.cmd.getStmtId().equals("92")) && !this.cmd.getSQLOrig().toUpperCase().startsWith("DESC") && (n = DBUtil.getInstance().getErrorOffset(this.conn, this.cmd.getSql())) >= 0) {
                Object[] objectArray;
                object = this.cmd.getSql().substring(0, n).split("\n");
                int n2 = object[((String[])object).length - 1].length();
                int n3 = ((String[])object).length;
                String string = sQLException.getMessage();
                if (this.conn instanceof OracleConnection) {
                    objectArray = new Oerr();
                    try {
                        string = string + objectArray.oerr(string);
                    }
                    catch (OerrException oerrException) {
                        // empty catch block
                    }
                }
                objectArray = new Object[]{new Integer(this.cmd.startLine + 1), this.cmd.getSql(), new Integer(this.cmd.startLine + n3), new Integer(n2), ScriptRunnerDbArb.format(23, string)};
                this.report(ScriptRunnerDbArb.format(42, objectArray));
                bl = false;
            }
            if (bl) {
                Oerr oerr = new Oerr();
                object = sQLException.getMessage();
                try {
                    object = (String)object + oerr.oerr((String)object);
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(23, object)));
            }
            this.doWhenever(true);
        }
        catch (IOException iOException) {
            this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.format(15, iOException.getMessage())));
            this.doWhenever(false);
        }
        finally {
            Connections.getInstance().unlock(this.conn);
        }
    }

    public void reportDML(String string, int n) throws IOException {
        String string2 = null;
        if (this.getScriptRunnerContext().getFeedback() == -1 || this.getScriptRunnerContext().getFeedback() <= n) {
            if (string.equals("48")) {
                string2 = Translate.translate("inserted");
            } else if (string.equals("88")) {
                string2 = Translate.translate("updated");
            } else if (string.equals("31")) {
                string2 = Translate.translate("deleted");
            } else if (string.equals("51")) {
                string2 = Translate.translate("merged");
            }
            string2 = n + " " + Translate.translate("rows") + " " + string2;
            this.report(string2);
        }
    }

    public int processDML() throws SQLException {
        int n = 0;
        try {
            this.stmt = this.conn.prepareStatement(this.cmd.getSql());
            this.stmt.setEscapeProcessing(false);
            ArrayList arrayList = this.cmd.getBinds();
            if (arrayList != null && arrayList.size() > 0) {
                if (this.setBinds(this.stmt, arrayList)) {
                    n = this.stmt.executeUpdate();
                }
            } else {
                n = this.stmt.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        return n;
    }

    public void executeQuery() throws SQLException, IOException {
        ResultSet resultSet = null;
        boolean bl = true;
        try {
            this.stmt = this.conn.prepareStatement(this.cmd.getSql());
            this.stmt.setEscapeProcessing(false);
            List<String> list = DBUtil.getBinds(this.cmd.getSql(), true);
            if (list != null && list.size() > 0 && !this.setBinds(this.stmt, list)) {
                bl = false;
            }
            if (bl) {
                resultSet = this.stmt.executeQuery();
                ResultSetFormatter resultSetFormatter = new ResultSetFormatter();
                int n = 0;
                ObjectFactory objectFactory = ObjectFactory.getFactory(Connections.getInstance().getConnectioName(this.conn), this.conn);
                ConnectionTypeDetails connectionTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
                Integer n2 = connectionTypeDetails.getPreferredFetchSize();
                if (n2 != null) {
                    resultSet.setFetchSize(n2);
                }
                if (this.getScriptRunnerContext().isOutputSupressed()) {
                    while (resultSet.next()) {
                        ++n;
                    }
                } else {
                    List<String> list2 = FormatRegistry.getTypes();
                    boolean bl2 = false;
                    for (String string : list2) {
                        if (this.cmd.getSql().indexOf("/*" + string + "*/") <= 0) continue;
                        IResultFormatter iResultFormatter = FormatRegistry.getFormatter(string);
                        iResultFormatter.setResultSet(resultSet);
                        iResultFormatter.setRSHeaders(resultSet);
                        iResultFormatter.setEncode("UTF8");
                        iResultFormatter.setOutputStream(this.out);
                        iResultFormatter.print();
                        bl2 = true;
                    }
                    if (!bl2) {
                        n = this.cmd.getSql().indexOf("/*html*/") > 0 ? resultSetFormatter.rset2html(resultSet, this.out) : (this.cmd.getSql().indexOf("/*csv*/") > 0 ? resultSetFormatter.rset2csv(resultSet, this.out) : (this.cmd.getSql().indexOf("/*xml*/") > 0 ? resultSetFormatter.rset2xml(resultSet, this.out) : resultSetFormatter.rset2sqlplus(resultSet, this.conn, this.out)));
                    }
                }
                int n3 = this.getScriptRunnerContext().getFeedback();
                if (this.getScriptRunnerContext().getFeedback() == -1 || this.getScriptRunnerContext().getFeedback() <= n && this.getScriptRunnerContext().getFeedback() != -2) {
                    this.report("\n" + n + " " + Translate.translate("rows_selected") + "\n");
                }
                resultSet.close();
            }
            this.stmt.close();
        }
        catch (SQLException sQLException) {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
            throw sQLException;
        }
    }

    private String firstTwo(String string) {
        String string2 = "";
        String[] stringArray = string.trim().split("[ \t\n\r]");
        if (stringArray != null) {
            if (stringArray.length > 0) {
                string2 = stringArray[0];
            }
            if (stringArray.length > 1) {
                string2 = stringArray[1].equalsIgnoreCase("or") && stringArray[2].equalsIgnoreCase("replace") ? string2 + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3] : (stringArray.length > 2 && stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("database") && stringArray[2].equalsIgnoreCase("link") ? string2 + " " + stringArray[1] + " " + stringArray[2] : string2 + " " + stringArray[1]);
            }
        }
        return string2;
    }

    public void execute(boolean bl) throws SQLException, IOException {
        block13: {
            try {
                SQLWarning sQLWarning;
                this.st = this.conn.createStatement();
                this.st.setEscapeProcessing(false);
                boolean bl2 = this.st.execute(this.cmd.getSql().trim());
                if (this.cmd.getSql().toLowerCase().indexOf(" set nls") > 0) {
                    NLSUtils.populateNLS((OracleDatabase)Connections.getInstance().getDatabase(this.conn));
                }
                if ((sQLWarning = this.st.getWarnings()) == null && bl) {
                    if (this.getScriptRunnerContext().getFeedback() != -2) {
                        this.report(ScriptRunnerDbArb.format(24, this.firstTwo(this.cmd.getSql())));
                    }
                    break block13;
                }
                if (sQLWarning == null) break block13;
                String string = ScriptRunnerDbArb.format(22, this.firstTwo(this.cmd.getSql()));
                String string2 = sQLWarning.getMessage();
                if (this.conn instanceof OracleConnection) {
                    Oerr oerr = new Oerr();
                    try {
                        string2 = string2 + oerr.oerr(string2);
                    }
                    catch (OerrException oerrException) {
                        // empty catch block
                    }
                }
                while (sQLWarning != null) {
                    string = string + "\n" + ScriptRunnerDbArb.format(12, string2);
                    sQLWarning = sQLWarning.getNextWarning();
                }
                this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), string));
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (this.st != null) {
                    this.st.close();
                }
            }
        }
    }

    public void reportObjectAction() {
    }

    public void reportThreeWord() {
        String[] stringArray = null;
        stringArray = this.cmd.getSql().split("[ \n\r\t]");
        if (this.getScriptRunnerContext().getFeedback() != -2) {
            this.report(ScriptRunnerDbArb.format(24, stringArray[0] + " " + stringArray[1] + " " + stringArray[2]));
        }
    }
}

