/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedOutputStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.SQLCommandRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.util.Debug;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;

public class PLSQL
extends SQLCommandRunner {
    public static boolean running = false;

    public PLSQL(SQLCommand sQLCommand, BufferedOutputStream bufferedOutputStream) {
        super(sQLCommand, bufferedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!Connections.getInstance().lock(this.conn)) {
            return;
        }
        Debug.debug("PLSQL:" + this.cmd.getSql());
        Object object = "anon";
        Object object2 = null;
        try {
            Object object3;
            while (PLSQL.isRunning()) {
                System.out.println(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), ScriptRunnerDbArb.getString(34)));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            PLSQL.toggleRunning();
            if (this.cmd.getStmtId().equals("27")) {
                this.cstmt = this.conn.createStatement();
                this.cstmt.setEscapeProcessing(false);
                this.cstmt.executeUpdate(this.cmd.getSql());
            } else if (this.getScriptRunnerContext().getScanOn()) {
                this.callStmt = this.conn.prepareCall(this.dbUtil.prepareNonOracleSql(this.cmd.getSql()));
                this.callStmt.setEscapeProcessing(true);
                object3 = DBUtil.getBinds(this.cmd.getSql(), true);
                if (object3 != null && object3.size() > 0) {
                    if (this.setBinds(this.callStmt, (List)object3)) {
                        this.registerOutParameters();
                        int n = this.callStmt.getParameterMetaData().getParameterCount();
                        this.callStmt.execute();
                        this.fetchOutputParameterValues();
                    }
                } else {
                    this.callStmt.execute();
                }
            } else {
                this.callStmt = this.conn.prepareCall(this.cmd.getSql());
                this.callStmt.execute();
            }
            Debug.debug("PLSQL Complete:");
            object3 = this.cmd.getSql().split("[ \n\r]");
            if (object3[0].toLowerCase().equals("create")) {
                if (((String)object3[1]).toLowerCase().equals("or")) {
                    if (((String)object3[3]).toLowerCase().equals("package") && ((String)object3[4]).toLowerCase().equals("body")) {
                        object = (String)object3[3] + " " + (String)object3[4];
                        object2 = object3[5];
                    } else {
                        object = object3[3];
                        object2 = object3[4];
                    }
                } else if (((String)object).toLowerCase().equals("package") && ((String)object3[2]).toLowerCase().equals("body")) {
                    object = (String)object3[1] + " " + (String)object3[2];
                    object2 = object3[3];
                } else {
                    object = object3[1];
                    object2 = object3[2];
                }
            }
            SQLWarning sQLWarning = null;
            sQLWarning = this.cmd.getStmtId().equals("27") ? this.cstmt.getWarnings() : this.callStmt.getWarnings();
            if (sQLWarning != null && sQLWarning.getMessage() != null) {
                if (((String)object3[2]).toLowerCase().equals("body")) {
                    this.getScriptRunnerContext().putProperty("sqldev.last.err.type", (String)object + " BODY");
                } else {
                    this.getScriptRunnerContext().putProperty("sqldev.last.err.type", object);
                }
                this.getScriptRunnerContext().putProperty("sqldev.last.err.name", object2);
                this.report(sQLWarning.getMessage());
            }
            if (((String)object).equals("anon") && this.getScriptRunnerContext().getFeedback() != -2) {
                this.report(Translate.translate("anonymous_block_completed"));
            } else if (this.getScriptRunnerContext().getFeedback() != -2) {
                this.report((String)object + " " + (String)object2 + " Compiled.");
                this.reportErrors((String)object2);
            }
        }
        catch (SQLException sQLException) {
            this.getScriptRunnerContext().putProperty("sqldev.error", Boolean.TRUE);
            this.doWhenever(true);
            String string = sQLException.getMessage();
            if (this.conn instanceof OracleConnection) {
                Oerr oerr = new Oerr();
                try {
                    string = string + oerr.oerr(string);
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
            }
            this.report(ScriptRunnerDbArb.format(16, new Integer(this.cmd.startLine + 1), this.cmd.getSQLOrig(), string));
        }
        finally {
            if (this.cstmt != null) {
                try {
                    this.cstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.callStmt != null) {
                try {
                    this.callStmt.close();
                }
                catch (SQLException sQLException) {}
            }
            Connections.getInstance().unlock(this.conn);
            PLSQL.toggleRunning();
        }
    }

    public void reportErrors(String string) {
    }

    public static synchronized void toggleRunning() {
        running = !running;
    }

    public static boolean isRunning() {
        return running;
    }

    private void fetchOutputParameterValues() throws SQLException {
        int n = 1;
        Map map = this.getScriptRunnerContext().getVarMap();
        List<String> list = DBUtil.getBinds(this.cmd.getSql(), true);
        n = list.size();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (n <= 0) continue;
            String string = list.get(i);
            Bind bind = (Bind)map.get(string);
            String string2 = bind.getType();
            if (string2.toUpperCase().indexOf("CHAR") > -1) {
                bind.setValue(this.callStmt.getString(n));
            } else if (string2.toUpperCase().equals("NUMBER")) {
                bind.setValue(this.callStmt.getObject(n) == null ? null : this.callStmt.getObject(n).toString());
            } else if (string2.toUpperCase().indexOf("CLOB") > -1) {
                bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(n), this.conn));
            } else if (string2.toUpperCase().equals("REFCURSOR")) {
                bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(n), this.conn));
            } else if (string2.toUpperCase().indexOf("BINARY_") > -1) {
                bind.setValue(DataTypesUtil.stringValue(this.callStmt.getObject(n), this.conn));
            }
            map.put(string, bind);
            --n;
        }
    }

    private void registerOutParameters() throws SQLException {
        int n = 1;
        List<String> list = DBUtil.getBinds(this.cmd.getSql(), true);
        Map map = this.getScriptRunnerContext().getVarMap();
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            string = list.get(i);
            if (!map.containsKey(string)) continue;
            Bind bind = (Bind)map.get(string);
            String string2 = bind.getType();
            if (string2.toUpperCase().indexOf("NCHAR") > -1 || string2.toUpperCase().indexOf("NVARCHAR") > -1 || string2.toUpperCase().indexOf("NCLOB") > -1) {
                ((OracleCallableStatement)this.callStmt).setFormOfUse(n, (short)2);
            }
            if (string2.toUpperCase().indexOf("CHAR") > -1) {
                this.callStmt.registerOutParameter(n, 12);
            } else if (string2.toUpperCase().equals("NUMBER")) {
                this.callStmt.registerOutParameter(n, 4);
            } else if (string2.toUpperCase().indexOf("CLOB") > -1) {
                this.callStmt.registerOutParameter(n, 2005);
            } else if (string2.toUpperCase().equals("REFCURSOR")) {
                this.callStmt.registerOutParameter(n, -10);
            } else if (string2.toUpperCase().equals("BINARY_DOUBLE")) {
                this.callStmt.registerOutParameter(n, 101);
            } else if (string2.toUpperCase().equals("BINARY_FLOAT")) {
                this.callStmt.registerOutParameter(n, 100);
            }
            ++n;
        }
    }
}

