/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.log.MessagePage;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.editor.BasicEditorPane;

public class OutputRedirector
extends Thread {
    private Logger logger = Logger.getLogger(OutputRedirector.class.getName());
    private PipedInputStream _in;
    private Document _text;
    private String _line = "";
    private BufferedReader _reader;
    private final int DISPLAY_NUMBER_OF_LINES = 50;
    private BasicEditorPane _editor;
    private MessagePage _logPage;
    private ProgressPanel _progress;

    public OutputRedirector(PipedInputStream pipedInputStream, MessagePage messagePage) {
        this(pipedInputStream, null, null, messagePage);
    }

    public OutputRedirector(PipedInputStream pipedInputStream, Document document, BasicEditorPane basicEditorPane) {
        this(pipedInputStream, document, basicEditorPane, null);
    }

    public OutputRedirector(PipedInputStream pipedInputStream, Document document, BasicEditorPane basicEditorPane, MessagePage messagePage) {
        this._in = pipedInputStream;
        this._text = document;
        this._editor = basicEditorPane;
        this._logPage = messagePage;
        try {
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, "UTF-8"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block26: {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (this._editor != null) {
                this._editor.setEditable(true);
            }
            while (this._line != null) {
                for (int i = 0; i <= 50 && !bl; ++i) {
                    this._line = this._reader.readLine();
                    if (this._line == null) break;
                    if (this._line.equals("force_print")) {
                        this._line = "";
                        bl = true;
                    }
                    if (bl) continue;
                    stringBuffer.append(this._line + "\n");
                }
                if (this._text != null) {
                    this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                }
                if (!(this._logPage == null || bl && stringBuffer.length() <= 0)) {
                    this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                }
                if (this._progress != null) {
                    final String string = stringBuffer.toString();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (string.length() > 0 && string.length() > 40) {
                                OutputRedirector.this._progress.setMessage(string.substring(0, 40));
                            } else if (string.length() > 0) {
                                OutputRedirector.this._progress.setMessage(string);
                            }
                        }
                    });
                }
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                this.moveToLastRow();
                bl = false;
            }
            Object var5_6 = null;
            try {
                if (this._text != null) {
                    this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                }
                if (this._logPage != null) {
                    this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                }
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "run", badLocationException);
            }
            this.moveToLastRow();
            if (this._editor != null) {
                this._editor.setEditable(false);
            }
            break block26;
            {
                catch (Exception exception) {
                    this.logger.info("Output Pipe finished");
                    Object var5_7 = null;
                    try {
                        if (this._text != null) {
                            this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                        }
                        if (this._logPage != null) {
                            this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        this.logger.log(Level.SEVERE, "run", badLocationException);
                    }
                    this.moveToLastRow();
                    if (this._editor != null) {
                        this._editor.setEditable(false);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (this._text != null) {
                        this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                    }
                    if (this._logPage != null) {
                        this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.logger.log(Level.SEVERE, "run", badLocationException);
                }
                this.moveToLastRow();
                if (this._editor != null) {
                    this._editor.setEditable(false);
                }
                throw throwable;
            }
        }
    }

    public void moveToLastRow() {
        if (this._editor != null) {
            this._editor.setCaretPositionCenter(this._editor.getDocument().getLength());
        }
    }

    public void setProgressPanel(ProgressPanel progressPanel) {
        this._progress = progressPanel;
    }
}

