/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.AutoTrace;
import oracle.dbtools.raptor.scriptrunner.commands.CLIDefinePrompter;
import oracle.dbtools.raptor.scriptrunner.commands.ChangeLoggerLevel;
import oracle.dbtools.raptor.scriptrunner.commands.ClearScreen;
import oracle.dbtools.raptor.scriptrunner.commands.DebugLoadQueryFile;
import oracle.dbtools.raptor.scriptrunner.commands.Host;
import oracle.dbtools.raptor.scriptrunner.commands.Pause;
import oracle.dbtools.raptor.scriptrunner.commands.SetAutoPrint;
import oracle.dbtools.raptor.scriptrunner.commands.SetEcho;
import oracle.dbtools.raptor.scriptrunner.commands.SetEscape;
import oracle.dbtools.raptor.scriptrunner.commands.SetFeedBack;
import oracle.dbtools.raptor.scriptrunner.commands.SetGetPage;
import oracle.dbtools.raptor.scriptrunner.commands.SetOwa;
import oracle.dbtools.raptor.scriptrunner.commands.SetPause;
import oracle.dbtools.raptor.scriptrunner.commands.SetServerOutput;
import oracle.dbtools.raptor.scriptrunner.commands.SetTerm;
import oracle.dbtools.raptor.scriptrunner.commands.SetTiming;
import oracle.dbtools.raptor.scriptrunner.commands.SetVerify;
import oracle.dbtools.raptor.scriptrunner.commands.SetXQuery;
import oracle.dbtools.raptor.scriptrunner.commands.ShowErrors;
import oracle.dbtools.raptor.scriptrunner.commands.ShowUser;
import oracle.dbtools.raptor.scriptrunner.commands.UpdateEditorPane;
import oracle.dbtools.raptor.scriptrunner.commands.XQuery;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.TNSPing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRegistry {
    private static HashMap<String, ArrayList<Class<? extends CommandListener>>> _listeners = new HashMap();
    private static HashMap<Connection, HashMap<String, ArrayList<CommandListener>>> _connectionListeners = new HashMap();

    public static void addListener(Class<? extends CommandListener> clazz) {
        CommandRegistry.addListener(clazz, "0");
    }

    public static void addListener(Class<? extends CommandListener> clazz, String string) {
        if (_listeners.get(string) == null) {
            _listeners.put(string, new ArrayList());
        }
        _listeners.get(string).add(clazz);
    }

    private static synchronized HashMap<String, ArrayList<CommandListener>> getListeners(Connection connection) {
        if (_connectionListeners.get(connection) == null) {
            _connectionListeners.put(connection, new HashMap());
        }
        HashMap<String, ArrayList<CommandListener>> hashMap = _connectionListeners.get(connection);
        Iterator<String> iterator = _listeners.keySet().iterator();
        String string = null;
        boolean bl = true;
        while (iterator.hasNext()) {
            string = iterator.next();
            ArrayList<Class<? extends CommandListener>> arrayList = _listeners.get(string);
            for (Class<? extends CommandListener> clazz : arrayList) {
                if (hashMap.get(string) != null) {
                    for (CommandListener commandListener : hashMap.get(string)) {
                        if (!commandListener.getClass().equals(clazz)) continue;
                        bl = false;
                    }
                } else {
                    hashMap.put(string, new ArrayList());
                }
                if (!bl) continue;
                try {
                    CommandListener commandListener = clazz.newInstance();
                    hashMap.get(string).add(commandListener);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException(exception);
                }
            }
        }
        return hashMap;
    }

    public static boolean fireListeners(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        boolean bl = false;
        HashMap<String, ArrayList<CommandListener>> hashMap = CommandRegistry.getListeners(connection);
        if (hashMap.get("0") != null) {
            for (CommandListener commandListener : hashMap.get("0")) {
                if (bl) continue;
                bl = commandListener.handleEvent(connection, scriptRunnerContext, sQLCommand);
            }
        }
        if (hashMap.get(sQLCommand.getStmtClass()) != null) {
            for (CommandListener commandListener : hashMap.get(sQLCommand.getStmtClass())) {
                if (bl) continue;
                bl = commandListener.handleEvent(connection, scriptRunnerContext, sQLCommand);
            }
        }
        return bl;
    }

    public static void fireBeginListeners(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        HashMap<String, ArrayList<CommandListener>> hashMap = CommandRegistry.getListeners(connection);
        if (hashMap.get("0") != null) {
            for (CommandListener commandListener : hashMap.get("0")) {
                commandListener.beginEvent(connection, scriptRunnerContext, sQLCommand);
            }
        }
        if (hashMap.get(sQLCommand.getStmtClass()) != null) {
            for (CommandListener commandListener : hashMap.get(sQLCommand.getStmtClass())) {
                commandListener.beginEvent(connection, scriptRunnerContext, sQLCommand);
            }
        }
    }

    public static void fireEndListeners(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        HashMap<String, ArrayList<CommandListener>> hashMap = CommandRegistry.getListeners(connection);
        if (hashMap.get("0") != null) {
            for (CommandListener commandListener : hashMap.get("0")) {
                commandListener.endEvent(connection, scriptRunnerContext, sQLCommand);
            }
        }
        if (hashMap.get(sQLCommand.getStmtClass()) != null) {
            for (CommandListener commandListener : hashMap.get(sQLCommand.getStmtClass())) {
                commandListener.endEvent(connection, scriptRunnerContext, sQLCommand);
            }
        }
    }

    public static void fireBeginScriptListeners(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand[] sQLCommandArray) {
        HashMap<String, ArrayList<CommandListener>> hashMap = CommandRegistry.getListeners(connection);
        Iterator<Map.Entry<String, ArrayList<CommandListener>>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<CommandListener> arrayList = iterator.next().getValue();
            for (CommandListener commandListener : arrayList) {
                commandListener.beginScript(connection, scriptRunnerContext, sQLCommandArray);
            }
        }
    }

    public static void fireEndScriptListeners(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand[] sQLCommandArray) {
        HashMap<String, ArrayList<CommandListener>> hashMap = CommandRegistry.getListeners(connection);
        Iterator<Map.Entry<String, ArrayList<CommandListener>>> iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<CommandListener> arrayList = iterator.next().getValue();
            for (CommandListener commandListener : arrayList) {
                commandListener.endScript(connection, scriptRunnerContext, sQLCommandArray);
            }
        }
    }

    static {
        CommandRegistry.addListener(ClearScreen.class);
        CommandRegistry.addListener(AutoTrace.class);
        CommandRegistry.addListener(SetPause.class);
        CommandRegistry.addListener(SetTiming.class);
        CommandRegistry.addListener(Host.class);
        CommandRegistry.addListener(SetEcho.class);
        CommandRegistry.addListener(SetTerm.class);
        CommandRegistry.addListener(SetFeedBack.class);
        CommandRegistry.addListener(UpdateEditorPane.class);
        CommandRegistry.addListener(Pause.class);
        CommandRegistry.addListener(SetXQuery.class);
        CommandRegistry.addListener(XQuery.class);
        CommandRegistry.addListener(ShowErrors.class);
        CommandRegistry.addListener(ShowUser.class);
        CommandRegistry.addListener(CLIDefinePrompter.class);
        CommandRegistry.addListener(SetOwa.class);
        CommandRegistry.addListener(SetGetPage.class);
        CommandRegistry.addListener(DebugLoadQueryFile.class);
        CommandRegistry.addListener(ChangeLoggerLevel.class);
        CommandRegistry.addListener(SetVerify.class);
        CommandRegistry.addListener(SetEscape.class);
        CommandRegistry.addListener(TNSPing.class);
        CommandRegistry.addListener(SetAutoPrint.class);
        CommandRegistry.addListener(DataMover.class);
        CommandRegistry.addListener(SetServerOutput.class);
    }
}

