/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.schemacopy.CopyLoggerPage;
import oracle.dbtools.raptor.schemacopy.CopyPanel;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.log.MessagePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaCopyListener
implements ActionListener {
    Boolean _cancel = false;
    Connection _fromConn;
    Connection _toConn;
    DBObject _o;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CopyPanel copyPanel = CopyPanel.getInstance();
        this._fromConn = copyPanel.getFromConn();
        this._toConn = copyPanel.getToConn();
        if (this._fromConn == null) {
            MessageDialog.error((Component)copyPanel, (Object)"No Source Connection is selected unable to continue.", (String)"Connection Blank Error!", (String)"f1_exportConnection_html");
            return;
        }
        if (this._toConn == null) {
            MessageDialog.error((Component)copyPanel, (Object)"No Destination Connection is selected unable to continue.", (String)"Connection Blank Error!", (String)"f1_exportConnection_html");
            return;
        }
        if (actionEvent.getActionCommand().equals("apply")) {
            ExportRun exportRun = new ExportRun();
            exportRun.set_e(actionEvent);
            exportRun.setTitle(Translate.translate("Performing Export"));
            exportRun.setMessage(Translate.translate("Performing Export operations please be patient."));
            try {
                exportRun.start(true);
            }
            catch (ProgressException progressException) {
                progressException.printStackTrace();
            }
        }
    }

    public static synchronized LinkedHashMap<String, String> getOrderedTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("DATA", "Oracle#DATA");
        linkedHashMap.put("CONSTRAINT", "Oracle#CONSTRAINT");
        linkedHashMap.put("INDEX", "Oracle#INDEX");
        linkedHashMap.put("REFCONSTRAINT", "Oracle#REFCONSTRAINT");
        linkedHashMap.put("TRIGGER", "Oracle#TRIGGER");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PACKAGE BODY", "Oracle#PACKAGE_BODY");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        return linkedHashMap;
    }

    public static synchronized LinkedHashMap<String, String> getDropTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PACKAGE BODY", "Oracle#PACKAGE_BODY");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        return linkedHashMap;
    }

    public void doCopyWork() {
        ArrayList<DBObject> arrayList;
        Object object2;
        String string;
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        LinkedHashMap<String, String> linkedHashMap = SchemaCopyListener.getOrderedTypes();
        ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
        try {
            string = this._fromConn.getMetaData().getUserName();
            for (String iterator : linkedHashMap.keySet()) {
                object2 = linkedHashMap.get(iterator);
                arrayList = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, string, iterator, (String)object2);
                if (arrayList == null) continue;
                for (DBObject dBObject : arrayList) {
                    arrayList2.add(dBObject);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        string = null;
        String string2 = Connections.getInstance().getConnectioName(this._toConn);
        CopyLoggerPage.getScriptMessagePage().clearAll();
        if (CopyPanel.getInstance().getAction().equals("DROP")) {
            LinkedHashMap<String, String> linkedHashMap2 = SchemaCopyListener.getDropTypes();
            object2 = new ArrayList();
            try {
                arrayList = this._fromConn.getMetaData().getUserName();
                for (String string3 : linkedHashMap2.keySet()) {
                    String string4 = linkedHashMap2.get(string3);
                    ArrayList<DBObject> arrayList3 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, (String)((Object)arrayList), string3, string4);
                    if (arrayList3 == null) continue;
                    for (DBObject dBObject : arrayList3) {
                        ((ArrayList)object2).add(dBObject);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            arrayList = ((ArrayList)object2).iterator();
            while (arrayList.hasNext()) {
                DBObject dBObject = (DBObject)arrayList.next();
                if (this._cancel.booleanValue()) break;
                string = dBObject.getObjectType().equals("MATERIALIZED VIEW LOG") ? "  DROP " + dBObject.getObjectType() + " on \"" + dBObject.getObjectName() + "\";" : (dBObject.getObjectType().equals("TABLE") ? "  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\" cascade constraints;" : "  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\";");
                ScriptUtils.runAsScript(string, string2, (MessagePage)CopyLoggerPage.getScriptMessagePage());
            }
        }
        for (Object object2 : arrayList2) {
            if (this._cancel.booleanValue()) break;
            if (CopyPanel.getInstance().getAction().equals("TRUNC") && ((DBObject)object2).getObjectType().equals("TABLE")) {
                string = "  truncate " + ((DBObject)object2).getObjectType() + " \"" + ((DBObject)object2).getObjectName() + "\";";
                ScriptUtils.runAsScript(string, string2, (MessagePage)CopyLoggerPage.getScriptMessagePage());
            }
            if (((DBObject)object2).getObjectType().equals("DATA")) {
                arrayList = new DataMover(this._fromConn, this._toConn);
                ((DataMover)((Object)arrayList)).move((DBObject)object2, false);
                continue;
            }
            if (CopyPanel.getInstance().getAction().equals("TRUNC")) continue;
            try {
                arrayList = dDLGenerator.getCopyDDL((DBObject)object2);
                ScriptUtils.runAsScript((String)((Object)arrayList), string2, (MessagePage)CopyLoggerPage.getScriptMessagePage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ExportRun
    extends ProgressRunnable {
        private ActionEvent _e;

        ExportRun() {
        }

        public void set_e(ActionEvent actionEvent) {
            this._e = actionEvent;
        }

        protected Object doWork() throws Exception {
            SchemaCopyListener.this._cancel = false;
            SchemaCopyListener.this.doCopyWork();
            if (this._e.getSource() instanceof JEWTDialog && !SchemaCopyListener.this._cancel.booleanValue()) {
                JEWTDialog jEWTDialog = (JEWTDialog)this._e.getSource();
                jEWTDialog.closeDialog(true);
            }
            return true;
        }

        protected void doCancel() {
            super.doCancel();
            SchemaCopyListener.this._cancel = true;
        }
    }
}

