/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.schemacopy.SchemaCopyListener;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBIcons;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.db.DBException;

public class CopyPanel
extends JPanel {
    public static final String SCHEMA_COPY_NAME = "raptor.schemaCopy";
    public static final int SCHEMA_COPY_ACTION = Ide.findOrCreateCmdID((String)"raptor.schemaCopy");
    private static CopyPanel INSTANCE;
    private static final long serialVersionUID = 1L;
    private JRadioButton jBCreate = new JRadioButton();
    private JRadioButton jBTruncate = new JRadioButton();
    private JRadioButton jBDrop = new JRadioButton();
    private DBConnectionComboBox fromSelector = new DBConnectionComboBox();
    private DBConnectionComboBox toSelector = new DBConnectionComboBox();

    public CopyPanel() {
        this.initialize();
    }

    public String getAction() {
        if (this.jBTruncate.isSelected()) {
            return "TRUNC";
        }
        if (this.jBDrop.isSelected()) {
            return "DROP";
        }
        return "CREATE";
    }

    public Connection getToConn() {
        return this.toSelector.getCurrentConnection();
    }

    public Connection getFromConn() {
        return this.fromSelector.getCurrentConnection();
    }

    private void initialize() {
        this.fromSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    CopyPanel.this.fromSelector.getCurrentDatabase();
                }
                catch (DBException dBException) {
                    CopyPanel.this.fromSelector.getJComboBox().setSelectedIndex(-1);
                }
            }
        });
        this.toSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    CopyPanel.this.toSelector.getCurrentDatabase();
                }
                catch (DBException dBException) {
                    CopyPanel.this.toSelector.getJComboBox().setSelectedIndex(-1);
                }
            }
        });
        this.jBCreate.setText("Create Objects");
        this.jBCreate.setSelected(true);
        this.jBDrop.setText("Drop Object");
        this.jBTruncate.setText("Truncate Objects");
        this.setPreferredSize(new Dimension(400, 300));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jBCreate);
        buttonGroup.add(this.jBTruncate);
        buttonGroup.add(this.jBDrop);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jBCreate, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jBTruncate, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jBDrop, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Translate.translate("From Schema")), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fromSelector.getJComboBox(), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(Translate.translate("To Schema")), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.toSelector.getJComboBox(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)SCHEMA_COPY_ACTION, null, (String)Translate.translate("Copy Oracle Schema"), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(67), (ArrayResourceBundle)DBIcons.getInstance(), (int)10, null, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController(SchemaCopyController.INSTANCE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static CopyPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CopyPanel();
        }
        return INSTANCE;
    }

    public void launch() {
        this.jBCreate.setSelected(true);
        this.fromSelector.getJComboBox().setSelectedIndex(-1);
        this.toSelector.getJComboBox().setSelectedIndex(-1);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_schemacopy_html");
        UIUtils.showPanelAsDialog((JPanel)this, "Copy Schema", (ActionListener)new SchemaCopyListener(), true);
    }

    private static class SchemaCopyController
    implements Controller {
        private static Controller INSTANCE = new SchemaCopyController();

        private SchemaCopyController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == SCHEMA_COPY_ACTION) {
                CopyPanel.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == SCHEMA_COPY_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

