/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.runner.Mode;
import oracle.dbtools.raptor.runner.ParamImpl;
import oracle.dbtools.raptor.runner.Parameter;
import oracle.dbtools.raptor.runner.Procedure;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.runner.Type;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.parser.plsql.data.PlsqlName;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlPkg;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.javatools.parser.plsql.data.PlsqlTypedef;
import oracle.javatools.parser.plsql.data.PlsqlVariable;

public final class ParamTableModel
extends AbstractTableModel {
    private static final int NAME_IDX = 0;
    private static final int TYPE_IDX = 1;
    private static final int MODE_IDX = 2;
    private static final int HAS_DEF_IDX = 3;
    private static final int POSITION_POS = 1;
    private static final int NAME_POS = 2;
    private static final int LEVEL_POS = 3;
    private static final int DATA_TYPE_POS = 4;
    private static final int MODE_POS = 5;
    private static final int TYPE_LEN_POS = 6;
    private static final int TYPE_PREC_POS = 7;
    private static final int TYPE_SCALE_POS = 8;
    private static final int TYPE_OWNER_POS = 9;
    private static final int TYPE_NAME_POS = 10;
    private static final int TYPE_SUBNAME_POS = 11;
    private static final int PLS_TYPE_POS = 12;
    private String[] _headers;
    private List _paramList = new ArrayList();
    private static final Set FAKE_NAMES = new HashSet<String>(Arrays.asList("REF CURSOR", "PL/SQL TABLE"));
    private static final Map BOGUS_NAMES = new HashMap();

    public ParamTableModel(Procedure procedure) throws SQLException {
        this();
        this._init(procedure);
    }

    public ParamTableModel() {
        this._headers = new String[4];
        this._headers[0] = RunnerArb.getString(0);
        this._headers[1] = RunnerArb.getString(1);
        this._headers[2] = RunnerArb.getString(2);
        this._headers[3] = RunnerArb.getString(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _init(Procedure procedure) throws SQLException {
        Object object;
        Parameter[] parameterArray;
        PlsqlTypedef[] plsqlTypedefArray;
        PlsqlType[] plsqlTypeArray;
        Connection connection;
        OracleDatabase oracleDatabase = procedure.getDatabase();
        String string = procedure.getOwner();
        String string2 = procedure.getName();
        int n = procedure.getOverload();
        int n2 = procedure.getObjectID();
        boolean bl = false;
        Connection connection2 = connection = oracleDatabase.getConnection();
        synchronized (connection2) {
            plsqlTypeArray = null;
            try {
                plsqlTypedefArray = ParamTableModel.getQuery(oracleDatabase);
                parameterArray = new HashMap();
                parameterArray.put("OWNER", string);
                parameterArray.put("ID", new Integer(n2));
                parameterArray.put("NAME", string2);
                parameterArray.put("OVERLOAD", Integer.toString(n));
                plsqlTypeArray = DBUtil.getInstance().executeQuery(oracleDatabase.getConnection(), plsqlTypedefArray.getSql(), (Map)parameterArray);
                while (plsqlTypeArray.next()) {
                    String string3;
                    Object object2;
                    Object object3;
                    if (plsqlTypeArray.getInt(3) != 0) continue;
                    String string4 = plsqlTypeArray.getString(2);
                    int n3 = plsqlTypeArray.getInt(1);
                    if (n3 != 0 && string4 == null) continue;
                    object = null;
                    String string5 = plsqlTypeArray.getString(12);
                    if (string5 == null && (object3 = plsqlTypeArray.getString(10)) != null) {
                        string5 = "";
                        object2 = plsqlTypeArray.getString(9);
                        if ("PUBLIC".equals(object2)) {
                            object2 = null;
                        }
                        string3 = plsqlTypeArray.getString(11);
                        if (object2 != null) {
                            string5 = string5 + (String)object2 + ".";
                        }
                        string5 = string5 + (String)object3;
                        if (string3 != null) {
                            string5 = string5 + "." + string3;
                        }
                        object = new Type(string5, false);
                    }
                    if (object == null) {
                        object3 = string5;
                        string5 = plsqlTypeArray.getString(4);
                        if (string5 == null) {
                            object = new Type("UNKOWN TYPE", false);
                        } else if (ParamTableModel.unknownType(string5)) {
                            object = new Type(null, string5, false);
                            bl = true;
                        } else {
                            object = new Type(ParamTableModel.validateTypeName(string5));
                        }
                    }
                    if (((Type)object).isCharType()) {
                        object3 = plsqlTypeArray.getObject(6);
                        object2 = object3 instanceof Number ? (Number)((Number)object3) : (Number)new Integer(200);
                        string3 = new FastStringBuffer(((Type)object).getTypeName());
                        string3.append("(").append(object2).append(")");
                        string5 = string3.toString();
                        ((Type)object).setTypeName(string5);
                    }
                    if (n3 == 0) {
                        this._paramList.add(new ParamImpl((Type)object));
                        continue;
                    }
                    object3 = plsqlTypeArray.getString(5);
                    this._paramList.add(new ParamImpl(string4, (Type)object, Mode.getMode((String)object3), false));
                }
            }
            finally {
                if (plsqlTypeArray != null) {
                    try {
                        plsqlTypeArray.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        if (bl) {
            connection2 = procedure.getParseTree();
            plsqlTypeArray = this._resolveParsedProgram((PlsqlRoot)connection2, procedure);
            plsqlTypedefArray = ParamTableModel.getTypedefs((PlsqlRoot)connection2);
            parameterArray = this._paramList.toArray(new Parameter[this._paramList.size()]);
            for (int i = 0; i < parameterArray.length; ++i) {
                Type type = parameterArray[i].getType();
                if (type.getTypeName() != null) continue;
                if (plsqlTypeArray.length == 0) {
                    type.setTypeName(type.getDeclaredName());
                    continue;
                }
                object = plsqlTypeArray[i].getTypeName().toString();
                if (ParamTableModel.isLocalType((String)object, plsqlTypedefArray)) {
                    object = ParamTableModel.getQualifiedName((String)object, procedure);
                }
                type.setTypeName((String)object);
            }
        }
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public int findColumn(String string) {
        for (int i = 0; i < this._headers.length; ++i) {
            if (!this._headers[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getRowCount() {
        return this._paramList.size();
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n >= 0 && n < this.getRowCount()) {
            Parameter parameter = (Parameter)this._paramList.get(n);
            switch (n2) {
                case 0: {
                    object = parameter.getParamName();
                    break;
                }
                case 1: {
                    object = parameter.getType().getTypeName();
                    break;
                }
                case 2: {
                    object = parameter.getMode();
                    break;
                }
                case 3: {
                    object = parameter.isDefaultProvided() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    public int getColumnCount() {
        return this._headers.length;
    }

    public String getColumnName(int n) {
        return this._headers[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Parameter getParameter(int n) {
        return (Parameter)this._paramList.get(n);
    }

    private PlsqlType[] _resolveParsedProgram(PlsqlRoot plsqlRoot, Procedure procedure) {
        PlsqlSubprg[] plsqlSubprgArray;
        PlsqlNode[] plsqlNodeArray = plsqlRoot != null ? plsqlRoot.getUnits() : null;
        int n = plsqlNodeArray != null ? plsqlNodeArray.length : 0;
        PlsqlSubprg plsqlSubprg = null;
        if (n > 0 && (plsqlSubprgArray = ParamTableModel._findProgramsByName(plsqlNodeArray[0], procedure.getName())).length > 0) {
            PlsqlSubprg plsqlSubprg2;
            int n2 = procedure.getOverload();
            plsqlSubprg = n2 == 0 ? plsqlSubprgArray[0] : (this.matches(plsqlSubprg2 = plsqlSubprgArray[n2 - 1]) ? plsqlSubprg2 : this.findMatch(plsqlSubprgArray));
        }
        return plsqlSubprg != null ? ParamTableModel.getTypeList(plsqlSubprg) : new PlsqlType[]{};
    }

    private static PlsqlSubprg[] _findProgramsByName(PlsqlNode plsqlNode, String string) {
        PlsqlSubprg[] plsqlSubprgArray = null;
        switch (plsqlNode.getTreeKind()) {
            case 18: {
                PlsqlNode[] plsqlNodeArray = ((PlsqlPkg)plsqlNode).getDeclarations();
                plsqlSubprgArray = new PlsqlSubprg[plsqlNodeArray.length];
                int n = 0;
                for (int i = 0; i < plsqlNodeArray.length; ++i) {
                    if (plsqlNodeArray[i].getTreeKind() != 17 || !string.equals(ParamTableModel.convertName(((PlsqlSubprg)plsqlNodeArray[i]).getName().toString()))) continue;
                    plsqlSubprgArray[n++] = (PlsqlSubprg)plsqlNodeArray[i];
                }
                if (n >= plsqlSubprgArray.length) break;
                PlsqlSubprg[] plsqlSubprgArray2 = plsqlSubprgArray;
                plsqlSubprgArray = new PlsqlSubprg[n];
                System.arraycopy(plsqlSubprgArray2, 0, plsqlSubprgArray, 0, n);
                break;
            }
            case 17: {
                PlsqlName plsqlName = ((PlsqlSubprg)plsqlNode).getName();
                if (!string.equals(ParamTableModel.convertName(plsqlName.toString()))) break;
                plsqlSubprgArray = new PlsqlSubprg[]{(PlsqlSubprg)plsqlNode};
                break;
            }
        }
        return plsqlSubprgArray != null ? plsqlSubprgArray : new PlsqlSubprg[]{};
    }

    private boolean matches(PlsqlSubprg plsqlSubprg) {
        Parameter parameter;
        boolean bl = false;
        Parameter[] parameterArray = this._paramList.toArray(new Parameter[this._paramList.size()]);
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        if (plsqlType == null == ((parameter = parameterArray.length > 0 && parameterArray[0].isReturn() ? parameterArray[0] : null) == null)) {
            Parameter[] parameterArray2;
            PlsqlVariable[] plsqlVariableArray = plsqlSubprg.getFormalParameters();
            if (parameter != null && (parameterArray = new Parameter[(parameterArray2 = parameterArray).length - 1]).length > 0) {
                System.arraycopy(parameterArray2, 1, parameterArray, 0, parameterArray.length);
            }
            if (plsqlVariableArray.length == parameterArray.length && ParamTableModel.paramsMatch(plsqlType, parameter != null ? parameter.getType() : null)) {
                bl = true;
                for (int i = 0; i < plsqlVariableArray.length; ++i) {
                    if (ParamTableModel.paramsMatch(plsqlVariableArray[i].getVariableType(), parameterArray[i].getType())) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private PlsqlSubprg findMatch(PlsqlSubprg[] plsqlSubprgArray) {
        for (int i = 0; i < plsqlSubprgArray.length; ++i) {
            if (!this.matches(plsqlSubprgArray[i])) continue;
            return plsqlSubprgArray[i];
        }
        return null;
    }

    private static boolean paramsMatch(PlsqlType plsqlType, Type type) {
        int n;
        String string;
        String string2;
        boolean bl = true;
        if (plsqlType != null && type != null && (string2 = type.getTypeName()) != null && !string2.equals(string = ParamTableModel.convertName(plsqlType.getTypeName().toString())) && !type.isOutputSupported() && (n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(n + 1);
            bl = string2.equals(string);
        }
        return bl;
    }

    private static PlsqlType[] getTypeList(PlsqlSubprg plsqlSubprg) {
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        PlsqlVariable[] plsqlVariableArray = plsqlSubprg.getFormalParameters();
        PlsqlType[] plsqlTypeArray = new PlsqlType[plsqlVariableArray.length + (plsqlType != null ? 1 : 0)];
        int n = 0;
        if (plsqlType != null) {
            plsqlTypeArray[n++] = plsqlType;
        }
        for (int i = 0; i < plsqlVariableArray.length; ++i) {
            plsqlTypeArray[n++] = plsqlVariableArray[i].getVariableType();
        }
        return plsqlTypeArray;
    }

    private static Query getQuery(OracleDatabase oracleDatabase) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/runner/source.xml");
        return queryXMLSupport.getQuery("params", oracleDatabase.getConnection());
    }

    private static boolean unknownType(String string) {
        return string == null || FAKE_NAMES.contains(string.toUpperCase());
    }

    private static String validateTypeName(String string) {
        String string2 = (String)BOGUS_NAMES.get(string = string.toString());
        return string2 != null ? string2 : string;
    }

    private static String convertName(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    private static PlsqlTypedef[] getTypedefs(PlsqlRoot plsqlRoot) {
        PlsqlNode plsqlNode;
        int n;
        PlsqlTypedef[] plsqlTypedefArray = null;
        PlsqlNode[] plsqlNodeArray = plsqlRoot != null ? plsqlRoot.getUnits() : null;
        int n2 = n = plsqlNodeArray != null ? plsqlNodeArray.length : 0;
        if (n > 0 && (plsqlNode = plsqlNodeArray[0]).getTreeKind() == 18) {
            PlsqlNode[] plsqlNodeArray2 = ((PlsqlPkg)plsqlNode).getDeclarations();
            plsqlTypedefArray = new PlsqlTypedef[plsqlNodeArray2.length];
            int n3 = 0;
            block3: for (int i = 0; i < plsqlNodeArray2.length; ++i) {
                switch (plsqlNodeArray2[i].getTreeKind()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        plsqlTypedefArray[n3++] = (PlsqlTypedef)plsqlNodeArray2[i];
                        continue block3;
                    }
                }
            }
            if (n3 < plsqlTypedefArray.length) {
                PlsqlTypedef[] plsqlTypedefArray2 = plsqlTypedefArray;
                plsqlTypedefArray = new PlsqlTypedef[n3];
                if (n3 > 0) {
                    System.arraycopy(plsqlTypedefArray2, 0, plsqlTypedefArray, 0, n3);
                }
            }
        }
        return plsqlTypedefArray != null ? plsqlTypedefArray : new PlsqlTypedef[]{};
    }

    private static boolean isLocalType(String string, PlsqlTypedef[] plsqlTypedefArray) {
        boolean bl = false;
        if (string != null) {
            string = ParamTableModel.convertName(string);
            for (int i = 0; i < plsqlTypedefArray.length; ++i) {
                String string2 = plsqlTypedefArray[i].getName().toString();
                if (!string.equals(ParamTableModel.convertName(string2))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static String getQualifiedName(String string, Procedure procedure) {
        String string2 = procedure.getOwner();
        String string3 = procedure.getPackage();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (ModelUtil.hasLength((String)string2)) {
            fastStringBuffer.append(string2).append('.');
        }
        if (ModelUtil.hasLength((String)string3)) {
            fastStringBuffer.append(string3).append('.');
        }
        fastStringBuffer.append(string);
        return fastStringBuffer.toString();
    }

    static {
        BOGUS_NAMES.put("PL/SQL BOOLEAN", "BOOLEAN");
    }
}

