/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.runner.DatabaseRunHelper;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public class DBStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private Logger logger = Logger.getLogger(DBStarterFactory.class.getName());

    public String getName() {
        return null;
    }

    public Object canStart(RunProcess runProcess, Node node, List list) {
        Object object;
        if (runProcess instanceof JRunProcess && node instanceof RunnableSourceNode && (object = DBStarterFactory.findBaseTarget(node, list)) != null) {
            try {
                Database database = DBStarterFactory.getDatabase(node);
                if (runProcess.canRun("Database", (Object)database, node, list)) {
                    return object;
                }
            }
            catch (DBException dBException) {
                list.add(dBException.getLocalizedMessage());
            }
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object object) {
        RunnableSourceNode runnableSourceNode = (RunnableSourceNode)object;
        return new PlSqlStarter((JRunProcess)runProcess, runnableSourceNode);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node instanceof RunnableSourceNode && Boolean.parseBoolean((String)((RunnableSourceNode)node).getProperty("RUNNABLE"));
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object object) {
        return new DefaultDisplayable(){

            public String getShortLabel() {
                return RunMgrArb.getString((int)86);
            }

            public Icon getIcon() {
                return ConnectionArb.getIcon((int)269);
            }
        };
    }

    private static Object findBaseTarget(Node node, List list) {
        URL uRL = node.getURL();
        if (DBURLFormatHelper.isDBURL(uRL)) {
            if (node instanceof RunnableSourceNode) {
                RunnableSourceNode runnableSourceNode = ((RunnableSourceNode)node).getRunTarget();
                if (runnableSourceNode != null) {
                    return runnableSourceNode;
                }
                list.add("Source does not have a runnable target.");
            } else {
                list.add("Not a runnable DB source");
            }
        } else {
            String string = RunMgrArb.format((int)87, (Object)node.getShortLabel());
            list.add(string);
        }
        return null;
    }

    private static Database getDatabase(Node node) throws DBException {
        URL uRL = node.getURL();
        String string = DBURLFormatHelper.getConnectionName(uRL);
        return Connections.getInstance().getDatabase(string, true);
    }

    class PlSqlStarter
    extends JStarter {
        private TextBuffer buf;
        private RunnableSourceNode target;
        private Database database;
        private Connection executionConnection;
        private boolean connectHappened;
        private boolean dbSupportsCall;
        private static final String DBMS_OUTPUT_GET_LINE = "DBMS_OUTPUT.GET_LINE( ?, ? )";

        PlSqlStarter(JRunProcess jRunProcess, RunnableSourceNode runnableSourceNode) {
            super(jRunProcess, null);
            this.jrunProcess = jRunProcess;
            this.target = runnableSourceNode;
        }

        private Database getDatabase() {
            String string;
            URL uRL;
            if (this.database == null && !this.connectHappened && (uRL = this.target.getURL()) != null && (string = DBURLFormatHelper.getConnectionName(uRL)) != null) {
                try {
                    this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)90, (Object)string));
                    this.executionConnection = Connections.getInstance().getUniqueConnection(string);
                    this.database = Connections.getInstance().getDatabase(string);
                    this.connectHappened = true;
                    int n = this.database instanceof OracleDatabase ? ((OracleDatabase)this.database).getOracleDatabaseType() : 0;
                    this.dbSupportsCall = 0 != n && 1 != n;
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
                catch (CMException cMException) {
                    // empty catch block
                }
            }
            return this.database;
        }

        private void disconnect() {
            if (this.database != null) {
                this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)91, (Object)this.database.getConnectionName()));
                try {
                    this.executionConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.database = null;
            }
        }

        public File getStartDirectory() {
            return null;
        }

        public String[] getStartCommand() {
            return null;
        }

        public boolean canStart(List list) {
            return true;
        }

        public boolean start() {
            if (this.getDatabase() != null) {
                boolean bl = this.jrunProcess instanceof DebuggingProcess;
                this.buf = PlSqlRunnerPanel.runDialog(this.target, bl, false);
                if (this.buf == null) {
                    this.disconnect();
                    return false;
                }
                final DatabaseRunHelper databaseRunHelper = (DatabaseRunHelper)this.jrunProcess.getValue("Database", (Object)this.database, "DatabaseRunHelper");
                final String[][] stringArray = databaseRunHelper != null ? databaseRunHelper.getDatabaseCommands((Object)this.database) : (String[][])null;
                Thread thread = new Thread("PL/SQL Starter Thread"){

                    public void run() {
                        int n;
                        int n2;
                        int n3;
                        PlSqlStarter.this.enableDbmsOutput();
                        boolean bl = false;
                        if (stringArray != null && stringArray.length >= 1 && stringArray[0] != null) {
                            n3 = stringArray[0].length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                n = PlSqlStarter.this.executeSQL(stringArray[0][n2], true);
                                if (n == 0) continue;
                                if (databaseRunHelper != null) {
                                    databaseRunHelper.handleDatabaseError(stringArray, 0, n2, n);
                                }
                                bl = true;
                                break;
                            }
                        }
                        if (!bl && (databaseRunHelper == null || databaseRunHelper.waitForDatabase())) {
                            n3 = PlSqlStarter.this.executePlSqlNode();
                            int n4 = n2 = PlSqlStarter.this.database instanceof OracleDatabase && (n3 == 6543 || n3 == 30687) ? 1 : 0;
                            if (stringArray != null && stringArray.length >= 2 && stringArray[1] != null) {
                                n = stringArray[1].length;
                                for (int i = 0; i < n; ++i) {
                                    int n5 = PlSqlStarter.this.executeSQL(stringArray[1][i], true);
                                    if (n5 == 0 || databaseRunHelper == null) continue;
                                    databaseRunHelper.handleDatabaseError(stringArray, 1, i, n5);
                                }
                            }
                            if (n2 == 0) {
                                PlSqlStarter.this.logDbmsOutput();
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PlSqlStarter.this.jrunProcess.finished();
                                PlSqlStarter.this.finished();
                            }
                        });
                    }
                };
                thread.start();
                return true;
            }
            this.disconnect();
            return false;
        }

        private void logMsg(String string) {
            this.logMsg(string, null);
        }

        private void logMsg(String string, AttributeSet attributeSet) {
            if (string != null) {
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                if (attributeSet != null) {
                    this.jrunProcess.log((Object)new StyledMessage(attributeSet, string));
                } else {
                    this.jrunProcess.log((Object)string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeSQL(String string, boolean bl) {
            int n = 0;
            if (bl) {
                boolean bl2 = true;
                StringBuffer stringBuffer = new StringBuffer(RunMgrArb.getString((int)92));
                String string2 = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.logMsg(string2 + string3 + "\n");
                    if (!bl2) continue;
                    for (int i = stringBuffer.length() - 1; i >= 0; --i) {
                        stringBuffer.setCharAt(i, ' ');
                    }
                    string2 = stringBuffer.toString();
                    bl2 = false;
                }
            }
            Statement statement = null;
            try {
                statement = this.executionConnection.createStatement();
                statement.execute(string);
            }
            catch (SQLException sQLException) {
                n = this.handleError(sQLException, bl);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                    statement = null;
                }
            }
            return n;
        }

        private int handleError(SQLException sQLException, boolean bl) {
            int n = sQLException.getErrorCode();
            String string = sQLException.getMessage();
            if (bl) {
                this.logMsg(string, RunProcess.getSystemErrAttributeSet());
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executePlSqlNode() {
            int n = 0;
            if (this.buf != null) {
                String string = this.buf.getString(0, this.buf.getLength());
                Statement statement = null;
                try {
                    statement = this.executionConnection.createStatement();
                    statement.setEscapeProcessing(false);
                    statement.execute(string);
                }
                catch (SQLException sQLException) {
                    n = this.handleError(sQLException, true);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return n;
        }

        private String getSQL(String string, boolean bl) {
            return this.getSQL(string, this.dbSupportsCall, bl);
        }

        private String getSQL(String string, boolean bl, boolean bl2) {
            StringBuffer stringBuffer = new StringBuffer(100);
            if (bl) {
                stringBuffer.append("{ CALL ");
            } else {
                stringBuffer.append("BEGIN ");
            }
            stringBuffer.append(string);
            if (bl) {
                if (bl2) {
                    stringBuffer.append("()");
                }
                stringBuffer.append("}");
            } else {
                stringBuffer.append("; END;");
            }
            return stringBuffer.toString();
        }

        private void enableDbmsOutput() {
            this.executeSQL(this.getSQL("DBMS_OUTPUT.DISABLE", true), false);
            this.executeSQL(this.getSQL("DBMS_OUTPUT.ENABLE", true), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logDbmsOutput() {
            while (true) {
                Statement statement = null;
                try {
                    String string = this.getSQL(DBMS_OUTPUT_GET_LINE, false);
                    statement = this.executionConnection.prepareCall(string);
                    statement.registerOutParameter(1, 12);
                    statement.registerOutParameter(2, 4);
                    statement.execute();
                    String string2 = statement.getString(1);
                    int n = statement.getInt(2);
                    this.logMsg(string2, RunProcess.getSystemOutAttributeSet());
                    if (n <= 0) continue;
                    return;
                }
                catch (Exception exception) {
                    DBStarterFactory.this.logger.log(Level.SEVERE, "logDbmsOutput", exception);
                    return;
                }
                finally {
                    if (statement == null) continue;
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }

        public boolean canTerminate() {
            return false;
        }

        public void terminate() {
        }

        public void finished() {
            this.disconnect();
            super.finished();
        }
    }
}

