/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.queryBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import oracle.bali.dbUI.queryBuilder.CustomizedQueryBuilder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderDatabase;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class QueryBuilderContextMenu
implements Controller,
ContextMenuListener {
    public static int QB_POPUP = Ide.findOrCreateCmdID((String)"sqldev.qb.launch");
    private static QueryBuilderContextMenu _instance;
    private IdeAction _qbLaunch;
    private String _currText;

    private QueryBuilderContextMenu() {
    }

    public static synchronized QueryBuilderContextMenu getInstance() {
        if (_instance == null) {
            _instance = new QueryBuilderContextMenu();
        }
        return _instance;
    }

    private Database getDatabase(Context context) {
        Database database = null;
        Node node = context.getNode();
        if (context.getView() instanceof IDBEditor) {
            database = ((IDBEditor)context.getView()).getDatabase();
        } else if (node instanceof RunnableSourceNode) {
            try {
                database = Connections.getInstance().getDatabase(((RunnableSourceNode)node).getConnectionName());
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        }
        return database;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == QB_POPUP) {
            String string = null;
            Database database = this.getDatabase(context);
            if (database != null) {
                Object object;
                BasicEditorPane basicEditorPane = null;
                if (context.getView() instanceof Editor && (object = (Editor)context.getView()).getDefaultFocusComponent() instanceof BasicEditorPane) {
                    basicEditorPane = (BasicEditorPane)object.getDefaultFocusComponent();
                    string = basicEditorPane.getText();
                }
                object = new CustomizedQueryBuilder(new QueryBuilderDatabase(database));
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)object, "Center");
                jPanel.setMinimumSize(new Dimension(400, 400));
                BasicEditorPane basicEditorPane2 = basicEditorPane;
                HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_popupquerybuilder_html");
                UIUtils.showPanelAsDialog(jPanel, "Query Builder", new ActionListener((CustomizedQueryBuilder)object, basicEditorPane2){
                    final /* synthetic */ CustomizedQueryBuilder val$qb;
                    final /* synthetic */ BasicEditorPane val$editorPane;
                    {
                        this.val$qb = customizedQueryBuilder;
                        this.val$editorPane = basicEditorPane;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                        String string = this.val$qb.getSQLString();
                        int n = this.val$editorPane.getCaretPosition();
                        try {
                            this.val$editorPane.getDocument().insertString(n, string, null);
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                });
            } else {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)"Could not find a connection", (String)"Query Builder Error", (String)"f1_no_connection_html");
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Database database = this.getDatabase(contextMenu.getContext());
        if (database != null) {
            String string = database.getConnectionName();
            if (!Connections.getInstance().isOracle(string)) {
                return;
            }
            if (this._qbLaunch == null) {
                this.init();
            }
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this._qbLaunch));
        }
    }

    private void init() {
        this._qbLaunch = IdeAction.get((int)QB_POPUP, null, (String)"Query Builder", null, null, null, null, (boolean)true);
        this._qbLaunch.addController((Controller)this);
    }
}

