/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.folding;

import oracle.dbtools.raptor.plsql.folding.PlSqlFoldingBlock;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.syntax.PlsqlLexer;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel {
    private Lexer _lexer = new PlsqlLexer();
    private LexerToken _token = this._lexer.createLexerToken();

    public PlSqlFoldingModel(BasicDocument basicDocument) {
        super(basicDocument);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.readLock();
        try {
            PlSqlFoldingBlock plSqlFoldingBlock = new PlSqlFoldingBlock(0, textBuffer.getLength(), PlSqlFoldingBlock.BlockType.FILE, "");
            this.parse(textBuffer, plSqlFoldingBlock);
            this.setRoot((Object)plSqlFoldingBlock);
        }
        finally {
            textBuffer.readUnlock();
        }
        super.reload();
    }

    private void parse(TextBuffer textBuffer, PlSqlFoldingBlock plSqlFoldingBlock) {
        this._lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        this._lexer.setPosition(0);
        this.start(plSqlFoldingBlock);
    }

    private void start(PlSqlFoldingBlock plSqlFoldingBlock) {
        PlSqlFoldingBlock plSqlFoldingBlock2 = (PlSqlFoldingBlock)((Object)this.getRoot());
        int n = plSqlFoldingBlock.getEndOffset();
        if (plSqlFoldingBlock2 != null) {
            n -= plSqlFoldingBlock2.getEndOffset();
        }
        block12: while (true) {
            int n2 = this._lexer.lex(this._token);
            switch (n2) {
                case 0: {
                    return;
                }
                case 228: 
                case 341: {
                    int n3;
                    int n4 = this._lexer.lex(this._token);
                    if (!PlSqlFoldingModel.isOperator(n4)) {
                        int n5 = this._lexer.lex(this._token);
                        if (n5 == 72) {
                            n3 = this._lexer.lex(this._token);
                            if (PlSqlFoldingModel.isOperator(n3)) {
                                this._lexer.setPosition(this._token.getStartOffset());
                            }
                        } else {
                            this._lexer.setPosition(this._token.getStartOffset());
                        }
                    }
                    PlSqlFoldingBlock.BlockType blockType = n2 == 341 ? PlSqlFoldingBlock.BlockType.PROCEDURE : PlSqlFoldingBlock.BlockType.FUNCTION;
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, blockType, "...");
                    break;
                }
                case 137: 
                case 256: {
                    plSqlFoldingBlock.setSeenIs(true);
                    break;
                }
                case 143: {
                    PlSqlFoldingBlock.BlockType blockType = plSqlFoldingBlock.getType();
                    boolean bl = true;
                    if (!(blockType != PlSqlFoldingBlock.BlockType.PROCEDURE && blockType != PlSqlFoldingBlock.BlockType.FUNCTION || plSqlFoldingBlock.hasSeenBegin())) {
                        bl = false;
                        plSqlFoldingBlock.setSeenBegin(true);
                    }
                    if (!bl) break;
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.BEGIN_END, "BEGIN...");
                    break;
                }
                case 271: {
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.LOOP, "LOOP...");
                    break;
                }
                case 159: {
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.CASE, "CASE...");
                    break;
                }
                case 239: {
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.THEN, "THEN...");
                    plSqlFoldingBlock.setWaitingForThenAfterIf(true);
                    break;
                }
                case 404: {
                    if (!plSqlFoldingBlock.isWaitingForThenAfterIf()) break;
                    int n6 = this._token.getStartOffset();
                    plSqlFoldingBlock.setStartOffset(n6);
                    plSqlFoldingBlock.setWaitingForThenAfterIf(false);
                    break;
                }
                case 209: {
                    PlSqlFoldingBlock plSqlFoldingBlock3;
                    PlSqlFoldingBlock plSqlFoldingBlock4 = (PlSqlFoldingBlock)plSqlFoldingBlock.getParent();
                    if (plSqlFoldingBlock4 == null) break;
                    int n7 = this._token.getEndOffset();
                    int n3 = this._lexer.lex(this._token);
                    if (!PlSqlFoldingModel.isOperator(n3)) {
                        n3 = this._lexer.lex(this._token);
                        n7 = this._token.getEndOffset();
                    }
                    if (n3 == 94) {
                        n7 = this._token.getEndOffset();
                    } else {
                        this._lexer.setPosition(this._token.getStartOffset());
                    }
                    int n8 = plSqlFoldingBlock.getStartOffset();
                    if (this.isSameLine(n8, n7)) {
                        plSqlFoldingBlock4.remove((FoldingBlock)plSqlFoldingBlock);
                    } else {
                        plSqlFoldingBlock.setEndOffset(n7);
                        if (plSqlFoldingBlock2 != null && (plSqlFoldingBlock3 = PlSqlFoldingBlock.searchShiftedBlock(plSqlFoldingBlock2, plSqlFoldingBlock, n)) != null) {
                            plSqlFoldingBlock.setExpanded(plSqlFoldingBlock3.isExpanded());
                        }
                    }
                    plSqlFoldingBlock = plSqlFoldingBlock4;
                    break;
                }
                case 94: {
                    PlSqlFoldingBlock plSqlFoldingBlock3;
                    PlSqlFoldingBlock.BlockType blockType = plSqlFoldingBlock.getType();
                    if (blockType != PlSqlFoldingBlock.BlockType.FUNCTION && blockType != PlSqlFoldingBlock.BlockType.PROCEDURE || plSqlFoldingBlock.hasSeenIs()) continue block12;
                    int n9 = plSqlFoldingBlock.getStartOffset();
                    int n3 = this._token.getEndOffset();
                    PlSqlFoldingBlock plSqlFoldingBlock5 = (PlSqlFoldingBlock)plSqlFoldingBlock.getParent();
                    if (this.isSameLine(n9, n3)) {
                        plSqlFoldingBlock5.remove((FoldingBlock)plSqlFoldingBlock);
                    } else {
                        plSqlFoldingBlock.setEndOffset(n3);
                        if (plSqlFoldingBlock2 != null && (plSqlFoldingBlock3 = PlSqlFoldingBlock.searchShiftedBlock(plSqlFoldingBlock2, plSqlFoldingBlock, n)) != null) {
                            plSqlFoldingBlock.setExpanded(plSqlFoldingBlock3.isExpanded());
                        }
                    }
                    plSqlFoldingBlock = plSqlFoldingBlock5;
                }
            }
        }
    }

    private boolean isSameLine(int n, int n2) {
        int n3;
        TextBuffer textBuffer = (TextBuffer)this._lexer.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int n4 = lineMap.getLineEndOffset(n3 = lineMap.getLineFromOffset(n));
        return n2 < n4;
    }

    private static boolean isOperator(int n) {
        return 64 <= n && n <= 99;
    }

    private PlSqlFoldingBlock push(PlSqlFoldingBlock plSqlFoldingBlock, PlSqlFoldingBlock.BlockType blockType, String string) {
        int n = this._token.getStartOffset();
        PlSqlFoldingBlock plSqlFoldingBlock2 = new PlSqlFoldingBlock(n, blockType, string);
        plSqlFoldingBlock.add((FoldingBlock)plSqlFoldingBlock2);
        return plSqlFoldingBlock2;
    }
}

