/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.ui.search.SearchField;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.run.RunArb;

public class PLSQLEditorToolbar
implements EditorPlugin {
    public void install(BasicEditorPane basicEditorPane) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        final Toolbar toolbar = codeEditor.getToolbar();
        RaptorDnD raptorDnD = new RaptorDnD((JTextComponent)basicEditorPane);
        Node node = codeEditor.getContext().getNode();
        if (DBURLFormatHelper.isDBURL(codeEditor.getContext().getNode().getURL())) {
            DBObject dBObject = new DBObject((Element)codeEditor.getContext().getNode());
            String string = dBObject.getObjectType();
            if (string != null && !"XML SCHEMA".equals(string)) {
                if (!("TRIGGER".equals(string) || "TYPE".equals(string) || "PACKAGE BODY".equals(string))) {
                    this.addRunActions(codeEditor, toolbar, dBObject);
                }
                this.addCompileActions(codeEditor, toolbar);
            }
        } else if (codeEditor.getContext().getNode() instanceof PlSqlNode) {
            this.addCompileActions(codeEditor, toolbar);
            final DBConnectionComboBox dBConnectionComboBox = new DBConnectionComboBox();
            Component component = toolbar.getComponent(0);
            if (component instanceof SearchField) {
                component.setMinimumSize(new Dimension(150, component.getHeight()));
                component.setPreferredSize(new Dimension(150, component.getHeight()));
            }
            toolbar.add(Box.createHorizontalGlue());
            toolbar.add((Component)dBConnectionComboBox.getJComboBox());
            final PlSqlNode plSqlNode = (PlSqlNode)codeEditor.getContext().getNode();
            dBConnectionComboBox.getJComboBox().addItemListener(new ItemListener(){
                private Object lastConn;

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        try {
                            Database database = dBConnectionComboBox.getCurrentDatabase();
                            plSqlNode.setConnectionName(dBConnectionComboBox.getCurrentConnectionName());
                        }
                        catch (DBException dBException) {
                            DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
                            ExceptionHandler.handleException((Exception)((Object)dBException2));
                            if (this.lastConn != null) {
                                dBConnectionComboBox.setCurrentConnection(((JLabel)this.lastConn).getText());
                            }
                            dBConnectionComboBox.getJComboBox().setSelectedIndex(-1);
                        }
                        View.updateToolbarActions((Toolbar)toolbar);
                    } else if (itemEvent.getStateChange() == 2 && Connections.getInstance().isConnectionOpen(((JLabel)itemEvent.getItem()).getText())) {
                        this.lastConn = itemEvent.getItem();
                    }
                }
            });
            plSqlNode.attach(new Observer(){

                public void update(Object object, UpdateMessage updateMessage) {
                    dBConnectionComboBox.setCurrentConnection(plSqlNode.getConnectionName());
                }
            });
        }
        View.updateToolbarActions((Toolbar)toolbar);
    }

    private void addCompileActions(CodeEditor codeEditor, Toolbar toolbar) {
        toolbar.add((ToggleAction)this.createLocalAction((View)codeEditor, CompArb.getIcon((int)19), Translate.translate("Compile"), JCompiler.MAKE_SELECTED_CMD_ID, true));
        toolbar.add((ToggleAction)this.createLocalAction((View)codeEditor, CompileArb.getIcon(2), StringUtils.stripMnemonic((String)CompileArb.getString(0)), PLSQLController.COMPILE_DEBUG_COMMAND, true));
    }

    private void addRunActions(CodeEditor codeEditor, Toolbar toolbar, DBObject dBObject) {
        boolean bl = dBObject.getSchemaObject() != null;
        toolbar.add((ToggleAction)this.createLocalAction((View)codeEditor, RunArb.getIcon((int)3), Translate.translate("Run"), Ide.findOrCreateCmdID((String)"RunSelectionCommand"), bl));
        toolbar.add((ToggleAction)this.createLocalAction((View)codeEditor, DbgArb.getIcon((int)5), Translate.translate("Debug"), Ide.findOrCreateCmdID((String)"DebugSelectionCommand"), bl));
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private IdeAction createLocalAction(View view, Icon icon, String string, int n, boolean bl) {
        IdeAction ideAction = IdeAction.newLocalAction((int)n, (View)view);
        ideAction.putValue("SmallIcon", (Object)icon);
        ideAction.putValue("ShortDescription", (Object)string);
        ideAction.setEnabled(bl);
        return ideAction;
    }
}

