/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.CompileArb;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;

public class PLSQLController
implements Controller {
    private Logger logger = Logger.getLogger(PLSQLController.class.getName());
    private static final Object LOCK = new Object();
    private static PLSQLController _controller;
    public static final int COMPILE_DEBUG_COMMAND;
    public JMenuItem compileMenu;
    public IdeAction actionCompileDebug;
    public JMenuItem compileDebugMenu = null;
    private int cmdRun = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
    private int cmdDebug = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");

    private PLSQLController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PLSQLController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_controller == null) {
                _controller = new PLSQLController();
            }
        }
        return _controller;
    }

    private void createActions() {
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        IdeAction ideAction = IdeAction.get((int)JCompiler.MAKE_SELECTED_CMD_ID, null, (String)ConnectionArb.getString((int)278), (String)jMenu.getText(), null, (ArrayResourceBundle)CompArb.getInstance(), (int)6, null, (boolean)true);
        ideAction.addController((Controller)this);
        this.actionCompileDebug = IdeAction.get((int)COMPILE_DEBUG_COMMAND, (String)StringUtils.stripMnemonic((String)CompileArb.getString(0)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CompileArb.getString(0))));
        this.actionCompileDebug.addController((Controller)this);
        IdeAction.addController((int)this.cmdRun, (Controller)this);
        IdeAction.addController((int)this.cmdDebug, (Controller)this);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.cmdRun || n == this.cmdDebug) {
            if (ideAction.isLocalAction() && context.getView() instanceof CodeEditor) {
                if (context.getNode() instanceof PlSqlNode) {
                    ideAction.setEnabled(Boolean.valueOf((String)((PlSqlNode)context.getNode()).getProperty("INVALID")) == false);
                }
                return true;
            }
        } else if (n == JCompiler.MAKE_SELECTED_CMD_ID || n == COMPILE_DEBUG_COMMAND) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Node node;
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = false;
        int n = ideAction.getCommandId();
        if ((n == JCompiler.MAKE_SELECTED_CMD_ID || n == COMPILE_DEBUG_COMMAND) && (node = context.getNode()) instanceof PlSqlNode) {
            if (DBURLFormatHelper.isDBURL(node.getURL())) {
                Command command;
                node.ensureOpen();
                node.markDirty(true);
                IdeSettings ideSettings = Ide.getSettings();
                ConnectionOptions connectionOptions = (ConnectionOptions)ideSettings.getData("ConnectionOptions");
                boolean bl2 = true;
                if (connectionOptions != null) {
                    bl2 = connectionOptions.isGeneratePlSqlDebugInfo();
                    connectionOptions.setGeneratePlSqlDebugInfo(n == COMPILE_DEBUG_COMMAND);
                }
                if ((command = CommandProcessor.createCommand((String)"oracle.ide.cmd.SaveCommand", (Context)context)) != null) {
                    try {
                        CommandProcessor.getInstance().invoke(command);
                    }
                    catch (Exception exception) {
                        FeedbackManager.reportException((Throwable)exception);
                    }
                }
                if (connectionOptions != null) {
                    connectionOptions.setGeneratePlSqlDebugInfo(bl2);
                }
                if (context.getView() != null) {
                    View.updateToolbarActions((Toolbar)context.getView().getToolbar());
                }
            } else {
                try {
                    String string = ScriptUtils.runAsScript(((PlSqlNode)node).getReader(), ((PlSqlNode)node).getConnectionName());
                    ((PlSqlNode)node).setConnectionName(string);
                }
                catch (IOException iOException) {
                    this.logger.log(Level.SEVERE, "run plsql node", iOException);
                }
                node.notifyObservers((Object)node, new UpdateMessage(UpdateMessage.newMessageID((String)"connChanged"), (Object)node));
            }
            bl = true;
        }
        return bl;
    }

    static {
        COMPILE_DEBUG_COMMAND = Ide.findOrCreateCmdID((String)"oracle.dbdev.compilemenu.CompileAddin.COMPILE_DEBUG");
    }
}

