/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.view.View;
import oracle.ideimpl.db.explorer.BaseElement;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.JCompiler;

public class PLSQLContextMenu
implements ContextMenuListener {
    private PLSQLController _controller = PLSQLController.getInstance();

    public PLSQLContextMenu() {
        this.initializeListeners();
    }

    private void initializeListeners() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        ContextMenu contextMenu2 = navigatorManager.getContextMenu();
        contextMenu2.addContextMenuListener((ContextMenuListener)this);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (contextMenu.getContext().getNode() instanceof RunnableSourceNode) {
            Element[] elementArray;
            for (int i = 0; i < contextMenu.getGUI(true).getComponentCount(); ++i) {
                if (!(contextMenu.getGUI(true).getComponent(i) instanceof JMenuItem) || ((JMenuItem)contextMenu.getGUI(true).getComponent(i)).getAction() == null || ((IdeAction)((JMenuItem)contextMenu.getGUI(true).getComponent(i)).getAction()).getCommandId() != 57) continue;
                contextMenu.getGUI(true).remove(i);
            }
            Context context = contextMenu.getContext();
            View view = context.getView();
            if (view != null && (elementArray = context.getSelection()) != null && elementArray.length > 0) {
                IdeAction ideAction;
                boolean bl = true;
                for (int i = 0; bl && i < elementArray.length; ++i) {
                    Element element = elementArray[i];
                    if (element instanceof PlSqlNode) continue;
                    bl = false;
                }
                if (bl && (ideAction = IdeAction.find((int)JCompiler.MAKE_SELECTED_CMD_ID)) != null) {
                    this._controller.update(ideAction, context);
                    if (this._controller.compileMenu == null) {
                        this._controller.compileMenu = contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
                    }
                    contextMenu.add((Component)this._controller.compileMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                    if (this._controller.compileDebugMenu == null) {
                        this._controller.compileDebugMenu = contextMenu.createMenuItem((ToggleAction)this._controller.actionCompileDebug, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
                    }
                    contextMenu.add((Component)this._controller.compileDebugMenu, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray.length > 0 && elementArray[elementArray.length - 1] instanceof BaseElement) {
            BaseElement baseElement = (BaseElement)elementArray[elementArray.length - 1];
            baseElement.handleDoubleClick();
            return true;
        }
        return false;
    }
}

