/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.nls;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.log.LogManager;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.util.Version;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.cm.CMException;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleNLSProvider
extends DefaultNLSProvider {
    private static final Logger LOGGER = Logger.getLogger(OracleNLSProvider.class.getName());
    private final HashMap<Object, HashMap<String, String>> nlsMappings = new HashMap();
    private String sep;

    @Override
    public void initConnection(String string) {
        this.setNlsFromPrefs(string);
    }

    private boolean applySetting(Connection connection, String string, String string2) {
        String string3 = DBConfig.getInstance().getString(string);
        String string4 = this.getNLSMap(connection).get(string2);
        LOGGER.fine("Checking:" + string2 + ":" + string3 + ":" + string4);
        return string3 != null && !string3.equals("") && !string3.equals(string4);
    }

    @Override
    public void setNlsFromPrefs(String string) {
        String string2 = "";
        String string3 = "\"";
        Connection connection = null;
        boolean bl = false;
        try {
            connection = Connections.getInstance().getConnection(string);
        }
        catch (CMException cMException) {
            cMException.printStackTrace();
        }
        DBUtil.getInstance();
        Version version = DBUtil.getDbVersion(connection);
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        if (this.applySetting(connection, "NLS_LANG", "NLS_LANGUAGE")) {
            string2 = "alter session set NLS_LANGUAGE=\"" + DBConfig.getInstance().getString("NLS_LANG") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_TERR", "NLS_TERRITORY")) {
            string2 = "alter session set NLS_TERRITORY=\"" + DBConfig.getInstance().getString("NLS_TERR") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_SORT", "NLS_SORT")) {
            string2 = "alter session set NLS_SORT=\"" + DBConfig.getInstance().getString("NLS_SORT") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_COMP", "NLS_COMP")) {
            if (version.compareTo((Object)new Version("9")) < 0) {
                LogManager.getIdeLogWindow().log((Object)"NLS_COMP not set\n");
            } else if (version.compareTo((Object)new Version("10.2")) < 0) {
                string2 = "alter session set NLS_COMP=\"ANSI" + string3;
                LogManager.getIdeLogWindow().log((Object)"NLS_COMP set to ANSI \n");
            } else {
                string2 = "alter session set NLS_COMP=\"" + DBConfig.getInstance().getString("NLS_COMP") + string3;
            }
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_DATE_LANG", "NLS_DATE_LANGUAGE")) {
            string2 = "alter session set NLS_DATE_LANGUAGE=\"" + DBConfig.getInstance().getString("NLS_DATE_LANG") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_DATE_FORM", "NLS_DATE_FORMAT")) {
            string2 = "alter session set NLS_DATE_FORMAT=\"" + DBConfig.getInstance().getString("NLS_DATE_FORM") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_TS_FORM", "NLS_TIMESTAMP_FORMAT")) {
            string2 = "alter session set NLS_TIMESTAMP_FORMAT=\"" + DBConfig.getInstance().getString("NLS_TS_FORM") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_TS_TZ_FORM", "NLS_TIMESTAMP_TZ_FORMAT")) {
            string2 = "alter session set NLS_TIMESTAMP_TZ_FORMAT=\"" + DBConfig.getInstance().getString("NLS_TS_TZ_FORM") + string3;
            if (version.compareTo((Object)new Version("9")) < 0) {
                LogManager.getIdeLogWindow().log((Object)"NLS_TIMESTAMP_TZ_FORMAT not set\n");
            } else {
                DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
                bl = true;
            }
        }
        String string4 = hashMap.get("NLS_NUMERIC_CHARACTERS");
        String string5 = DBConfig.getInstance().getString("NLS_DEC_SEP");
        String string6 = DBConfig.getInstance().getString("NLS_GRP_SEP");
        if (!(string5 == null || string6 == null || string5.equals("") || string6.equals("") || string4.equals(string5 + string6))) {
            string2 = "alter session set NLS_NUMERIC_CHARACTERS=\"" + DBConfig.getInstance().getString("NLS_DEC_SEP") + DBConfig.getInstance().getString("NLS_GRP_SEP") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_CURR", "NLS_CURRENCY")) {
            string2 = "alter session set NLS_CURRENCY=\"" + DBConfig.getInstance().getString("NLS_CURR") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_ISO_CURR", "NLS_ISO_CURRENCY")) {
            string2 = "alter session set NLS_ISO_CURRENCY=\"" + DBConfig.getInstance().getString("NLS_ISO_CURR") + string3;
            DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
            bl = true;
        }
        if (this.applySetting(connection, "NLS_LENGTH", "NLS_LENGTH_SEMANTICS")) {
            string2 = "alter session set NLS_LENGTH_SEMANTICS=\"" + DBConfig.getInstance().getString("NLS_LENGTH") + string3;
            if (version.compareTo((Object)new Version("9")) < 0) {
                LogManager.getIdeLogWindow().log((Object)"NLS_COMP not set\n");
            } else {
                DBUtil.getInstance().execute(string, string2, new HashMap<String, Object>());
                bl = true;
            }
        }
        if (bl) {
            this.populateNLS(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateNLS(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/utils/loadNLS.xml");
            Query query = queryXMLSupport.getQuery("loadnls", connection);
            HashMap<String, String> hashMap = this.nlsMappings.get(connection) == null ? new HashMap<String, String>() : this.nlsMappings.get(connection);
            statement = connection.prepareStatement(query.getSql());
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                hashMap.put(resultSet.getString(1), resultSet.getString(2));
                LOGGER.fine("Loaded:" + resultSet.getString(1) + "=" + resultSet.getString(2));
            }
            this.nlsMappings.put(connection, hashMap);
        }
        catch (Exception exception) {
            LOGGER.severe("Error loading nls:" + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void populateNLS(OracleDatabase oracleDatabase) {
        this.populateNLS(oracleDatabase.getConnection());
    }

    public HashMap<String, String> getNLSMap(Connection connection) {
        if (this.nlsMappings.get(connection) == null) {
            this.populateNLS(connection);
        }
        return this.nlsMappings.get(connection);
    }

    @Override
    public String formatDate(Connection connection, DATE dATE) throws SQLException {
        String string = null;
        try {
            OraDATEFormat oraDATEFormat = this.getOraDATEFormat(connection);
            string = oraDATEFormat == null ? dATE.stringValue() : oraDATEFormat.format(dATE);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return string;
    }

    public OraDATEFormat getOraDATEFormat(Connection connection) throws ParseException {
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        try {
            OraDATEFormat oraDATEFormat = new OraDATEFormat(hashMap.get("NLS_DATE_FORMAT"), OraLocaleInfo.getInstance((String)hashMap.get("NLS_LANGUAGE"), (String)hashMap.get("NLS_TERRITORY")));
            return oraDATEFormat;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDateFormat(OracleDatabase oracleDatabase) {
        if (oracleDatabase == null) {
            return null;
        }
        return this.getDateFormat(oracleDatabase.getConnection());
    }

    public String getDateFormat(Connection connection) {
        if (connection == null) {
            return null;
        }
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        try {
            return hashMap.get("NLS_DATE_FORMAT");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTimeStampFormat(Connection connection) {
        if (connection == null) {
            return null;
        }
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        return hashMap.get("NLS_TIMESTAMP_FORMAT");
    }

    public String getTimeStampTZFormat(Connection connection) {
        if (connection == null) {
            return null;
        }
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        return hashMap.get("NLS_TIMESTAMP_TZ_FORMAT");
    }

    public String getFormat(Connection connection, String string) {
        if (connection == null) {
            return null;
        }
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        try {
            return hashMap.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDateFormat(String string) {
        OracleDatabase oracleDatabase = null;
        try {
            oracleDatabase = (OracleDatabase)Connections.getInstance().getDatabase(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDateFormat(oracleDatabase);
    }

    public String formatDate(String string, DATE dATE) throws SQLException {
        OracleDatabase oracleDatabase = null;
        try {
            oracleDatabase = (OracleDatabase)Connections.getInstance().getDatabase(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.formatDate(oracleDatabase.getConnection(), dATE);
    }

    public String formatTIMESTAMP(Connection connection, TIMESTAMP tIMESTAMP) {
        String string = null;
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(hashMap.get("NLS_TIMESTAMP_FORMAT"), OraLocaleInfo.getInstance((String)hashMap.get("NLS_LANGUAGE"), (String)hashMap.get("NLS_TERRITORY")));
            hashMap.put("NLS_TIMESTAMP_FORMAT", oraTIMESTAMPFormat.toPattern());
            string = oraTIMESTAMPFormat.format(tIMESTAMP);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    public String formatTIMESTAMPTZ(Connection connection, TIMESTAMPTZ tIMESTAMPTZ) {
        String string = null;
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        try {
            OraTIMESTAMPTZFormat oraTIMESTAMPTZFormat = new OraTIMESTAMPTZFormat(hashMap.get("NLS_TIMESTAMP_TZ_FORMAT"), OraLocaleInfo.getInstance((String)hashMap.get("NLS_LANGUAGE"), (String)hashMap.get("NLS_TERRITORY")));
            hashMap.put("NLS_TIMESTAMP_TZ_FORMAT", oraTIMESTAMPTZFormat.toPattern());
            string = oraTIMESTAMPTZFormat.format(tIMESTAMPTZ);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    public String formatTIMESTAMPLTZ(Connection connection, TIMESTAMPLTZ tIMESTAMPLTZ) {
        String string = null;
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        try {
            OraTIMESTAMPFormat oraTIMESTAMPFormat = new OraTIMESTAMPFormat(hashMap.get("NLS_TIMESTAMP_FORMAT"), OraLocaleInfo.getInstance((String)hashMap.get("NLS_LANGUAGE"), (String)hashMap.get("NLS_TERRITORY")), hashMap.get("DB_TIMEZONE"));
            string = oraTIMESTAMPFormat.format(tIMESTAMPLTZ, this.getSessionTimeZone(connection));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return string;
    }

    public String formatNUMBER(Connection connection, NUMBER nUMBER) {
        String string = null;
        string = nUMBER.stringValue();
        if (string.indexOf(46) != -1) {
            char c = this.getDecimalSeparator(connection);
            try {
                BigDecimal bigDecimal = nUMBER.bigDecimalValue();
                string = bigDecimal.toPlainString();
                if (c != '.') {
                    string = string.replace('.', c);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return string;
    }

    public String formatBigDecimal(Connection connection, BigDecimal bigDecimal) {
        String string = null;
        string = bigDecimal.toPlainString();
        if (string.indexOf(46) != -1 && connection instanceof OracleConnection) {
            char c = this.getDecimalSeparator(connection);
            string = bigDecimal.toPlainString();
            if (c != '.') {
                string = string.replace('.', c);
            }
        }
        return string;
    }

    @Override
    public Object getValue(Connection connection, Object object) {
        if (object == null) {
            return object;
        }
        String string = "";
        try {
            string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMP && connection != null ? this.formatTIMESTAMP(connection, (TIMESTAMP)object) : (object instanceof TIMESTAMPTZ && connection != null ? this.formatTIMESTAMPTZ(connection, (TIMESTAMPTZ)object) : (object instanceof TIMESTAMPLTZ && connection != null ? this.formatTIMESTAMPLTZ(connection, (TIMESTAMPLTZ)object) : (object instanceof DATE && connection != null ? this.formatDate(connection, (DATE)object) : (object instanceof Date && connection != null ? this.formatDate(connection, new DATE((Date)object)) : (object instanceof NUMBER && connection != null ? this.formatNUMBER(connection, (NUMBER)object) : (object instanceof BigDecimal && connection != null ? this.formatBigDecimal(connection, (BigDecimal)object) : (object instanceof INTERVALDS && connection != null ? ((INTERVALDS)object).toString() : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))))))))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    @Override
    public char getDecimalSeparator(Connection connection) {
        String string = this.getNLSMap(connection).get("NLS_NUMERIC_CHARACTERS");
        return string.substring(0, 1).charAt(0);
    }

    @Override
    public char getGroupSeparator(Connection connection) {
        String string = this.getNLSMap(connection).get("NLS_NUMERIC_CHARACTERS");
        return string.substring(1, 2).charAt(0);
    }

    public TimeZone getSessionTimeZone(Connection connection) {
        TimeZone timeZone = null;
        HashMap<String, String> hashMap = this.getNLSMap(connection);
        String string = hashMap.get("SESSION_TIMEZONE");
        if (string.charAt(0) == '+' || string.charAt(0) == '-') {
            string = "GMT" + string;
        }
        if ((timeZone = TimeZone.getTimeZone(string)).getID().equals("GMT") && !string.equals("GMT")) {
            String string2 = "GMT" + hashMap.get("SESSION_TIMEZONE_OFFSET");
            byte[] byArray = string2.getBytes();
            if (byArray[byArray.length - 1] == 0) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            timeZone = TimeZone.getTimeZone(string2);
        }
        return timeZone;
    }

    public static void main(String[] stringArray) {
        OraNumberFormat oraNumberFormat = OraNumberFormat.getNumberInstance((OraLocaleInfo)OraLocaleInfo.getInstance((String)"AMERICAN", (String)"AMERICA"));
        oraNumberFormat.setGroupingUsed(false);
        oraNumberFormat.setParseIntegerOnly(false);
        BigDecimal bigDecimal = new BigDecimal("123456789123456789.987654321987654321");
    }
}

