/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseChild;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.xml.XmlDBObject;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.xml.XmlObjectType;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLNode;

public class XmlNodeImpl
implements XmlDBObject,
NavigatorXmlElements {
    private XmlObjectType m_type;
    private XMLNode m_node;
    private String m_iconKey;
    private Icon m_icon;
    private NavigatorDescriptor m_desc;
    private List<XmlChildImpl> m_childTypes = new ArrayList<XmlChildImpl>();
    private String m_nodeClassName;
    private Class m_nodeClass;
    private String m_implClassName;
    private Class m_implClass;
    private String m_instClassName;
    private Class m_instClass;

    public XmlNodeImpl(XmlObjectType xmlObjectType, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        this.m_type = xmlObjectType;
        this.m_node = xMLNode;
        this.m_desc = navigatorDescriptor;
        this.m_nodeClassName = XmlNavigatorUtils.getAttributeValue("", "nodeClass", xMLNode);
        this.m_implClassName = XmlNavigatorUtils.getAttributeValue("", "itemClass", xMLNode);
        this.m_instClassName = XmlNavigatorUtils.getAttributeValue("", "instanceClass", xMLNode);
        this.m_iconKey = XmlNavigatorUtils.getAttributeValue("icon", "RSKEY", xMLNode);
        XMLNode[] xMLNodeArray = XmlNavigatorUtils.getElements("childType", xMLNode);
        if (xMLNodeArray != null) {
            for (XMLNode xMLNode2 : xMLNodeArray) {
                String string = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode2);
                if (string == null) continue;
                this.m_childTypes.add(new XmlChildImpl(string, navigatorDescriptor, xmlObjectType.getType(), xMLNode2));
            }
        }
    }

    public Icon getIcon() {
        if (this.m_icon == null && this.m_iconKey != null) {
            this.m_icon = XmlNavigatorUtils.getIcon(this.m_desc.getString(this.m_iconKey));
        }
        return this.m_icon;
    }

    public String[] getChildTypes() {
        String[] stringArray = new String[this.m_childTypes.size()];
        int n = 0;
        for (XmlChildImpl xmlChildImpl : this.m_childTypes) {
            stringArray[n++] = xmlChildImpl.getChildType();
        }
        return stringArray;
    }

    public DatabaseChild getChildType(String string) {
        return this.getChildTypeImpl(string);
    }

    private XmlChildImpl getChildTypeImpl(String string) {
        for (XmlChildImpl xmlChildImpl : this.m_childTypes) {
            if (!ModelUtil.areEqual((Object)string, (Object)xmlChildImpl.getChildType())) continue;
            return xmlChildImpl;
        }
        return null;
    }

    public String getType() {
        return this.m_type.getType();
    }

    public Class getImplementationClass() {
        if (this.m_nodeClass == null && this.m_nodeClassName != null) {
            try {
                this.m_nodeClass = Class.forName(this.m_nodeClassName);
                assert (DatabaseNode.class.isAssignableFrom(this.m_nodeClass));
                BaseNavigatorManager.registerObjectNodeClass(this.m_type.getType(), this.m_nodeClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_nodeClass;
    }

    Class getDBObjectImplementationClass() {
        if (this.m_implClass == null && this.m_implClassName != null) {
            try {
                this.m_implClass = Class.forName(this.m_implClassName);
                assert (DatabaseObject.class.isAssignableFrom(this.m_implClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_nodeClass;
    }

    public Class getDBObjectInstanceClass() {
        if (this.m_instClass == null && this.m_instClassName != null) {
            try {
                this.m_instClass = Class.forName(this.m_instClassName);
                assert (DBObjectInstance.class.isAssignableFrom(this.m_instClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.m_instClass;
    }

    public Class getChildProvider(String string) {
        XmlChildImpl xmlChildImpl = this.getChildTypeImpl(string);
        return xmlChildImpl != null ? xmlChildImpl.getProviderImpl() : null;
    }
}

