/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.navigator.xml.ObjectQueries;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.navigator.xml.XmlObjectType;
import oracle.xml.parser.v2.XMLNode;

public class XmlFolderImpl
implements DatabaseFolder,
NavigatorXmlElements {
    private XmlObjectType m_type;
    private XMLNode m_node;
    private String m_labelKey;
    private String m_label;
    private String m_iconKey;
    private Icon m_icon;
    private ObjectQueries m_queries;
    private boolean m_currentSchemaOnly;
    private NavigatorDescriptor m_desc;
    private double m_weight = Double.NEGATIVE_INFINITY;

    public XmlFolderImpl(XmlObjectType xmlObjectType, NavigatorDescriptor navigatorDescriptor, XMLNode xMLNode) {
        this.m_type = xmlObjectType;
        this.m_desc = navigatorDescriptor;
        this.m_node = xMLNode;
        this.m_labelKey = XmlNavigatorUtils.getAttributeValue("label", "RSKEY", xMLNode);
        this.m_iconKey = XmlNavigatorUtils.getAttributeValue("icon", "RSKEY", xMLNode);
        this.m_queries = new ObjectQueries(XmlNavigatorUtils.getSingleElement("queries", xMLNode));
        this.m_currentSchemaOnly = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "currentSchemaOnly", xMLNode));
    }

    public String getLabel() {
        if (this.m_label == null) {
            this.m_label = this.m_desc != null && this.m_labelKey != null ? this.m_desc.getString(this.m_labelKey) : this.m_type.getType();
        }
        return this.m_label;
    }

    public Icon getIcon() {
        if (this.m_icon == null && this.m_iconKey != null) {
            this.m_icon = XmlNavigatorUtils.getIcon(this.m_desc.getString(this.m_iconKey));
        }
        return this.m_icon;
    }

    public String getType() {
        return this.m_type.getType();
    }

    public ObjectQueries getQueries() {
        return this.m_queries;
    }

    public double getWeight() {
        if (this.m_weight == Double.NEGATIVE_INFINITY) {
            this.m_weight = this.m_type.getWeight();
            String string = XmlNavigatorUtils.getAttributeValue(null, "relativeWeight", this.m_node);
            if (string != null) {
                try {
                    this.m_weight += Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.m_weight;
    }

    public String getSchemaOverride() {
        return XmlNavigatorUtils.getAttributeValue(null, "schemaOverride", this.m_node);
    }

    public boolean isCurrentSchemaOnly() {
        return this.m_currentSchemaOnly;
    }

    public Class getImplementationClass() {
        return null;
    }

    boolean isSupportsSynonyms() {
        return this.m_type.isIncludesSynonyms();
    }
}

