/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.raptor.navigator.xml.NavigatorXmlElements;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Version;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class ObjectQueries
implements NavigatorXmlElements {
    private List<Query> m_queryList;
    private Query m_default;
    private Map<VersionEntry, Query> m_queryMap = new TreeMap<VersionEntry, Query>();

    public ObjectQueries(XMLNode xMLNode) {
        this.initQueries(xMLNode);
    }

    public void addQuery(Version version, Version version2, Query query) {
        this.m_queryMap.put(new VersionEntry(version, version2), query);
    }

    public void setDefaultQuery(Query query) {
        this.m_default = query;
    }

    public Query getQuery(String string) {
        return QueryUtils.getQuery(this.m_queryList, string);
    }

    public Query getQuery(Connection connection) {
        return QueryUtils.getQuery(this.m_queryList, connection);
    }

    public Query getQuery(Version version) {
        Query query = null;
        for (VersionEntry versionEntry : this.m_queryMap.keySet()) {
            if (version.compareTo((Object)versionEntry.m_min) < 0) break;
            if (versionEntry.m_max != null && version.compareTo((Object)versionEntry.m_max) > 0) continue;
            query = this.m_queryMap.get(versionEntry);
        }
        return query != null ? query : this.m_default;
    }

    private void initQueries(XMLNode xMLNode) {
        this.m_queryList = new ArrayList<Query>();
        if (xMLNode != null) {
            this.m_queryList.addAll(Query.getQueries((Node)xMLNode));
            for (Query query : this.m_queryList) {
                Version version = query.getMinversion();
                Version version2 = query.getMaxversion();
                if (version == null && version2 == null) {
                    this.setDefaultQuery(query);
                    continue;
                }
                this.addQuery(version, version2, query);
            }
        }
    }

    private class VersionEntry
    implements Comparable {
        private Version m_min;
        private Version m_max;

        private VersionEntry(Version version, Version version2) {
            assert (version != null || version2 != null);
            this.m_min = version;
            this.m_max = version2;
        }

        public int compareTo(Object object) {
            VersionEntry versionEntry = (VersionEntry)object;
            if (this == versionEntry) {
                return 0;
            }
            int n = this.m_min.compareTo((Object)versionEntry.m_min);
            if (n == 0) {
                n = this.m_max != null ? (versionEntry.m_max != null ? this.m_max.compareTo((Object)versionEntry.m_max) : 1) : (versionEntry.m_max != null ? -1 : 0);
            }
            return n;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof VersionEntry && ModelUtil.areEqual((Object)this.m_min, (Object)((VersionEntry)object).m_min) && ModelUtil.areEqual((Object)this.m_max, (Object)((VersionEntry)object).m_max);
        }

        public int hashCode() {
            return this.m_min.hashCode() + (this.m_max != null ? this.m_max.hashCode() : 0);
        }
    }
}

