/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorDescriptor {
    private static String RESOURCE_KEY = "/navigator/@RESOURCE_FILE";
    private XMLDocument m_doc;
    private ResourceBundle m_bundle;
    private Map<String, ConnectionType> m_types = new HashMap<String, ConnectionType>();

    public NavigatorDescriptor(XMLDocument xMLDocument) {
        this.m_doc = xMLDocument;
        try {
            Object object;
            XMLNode xMLNode = (XMLNode)xMLDocument.selectSingleNode(RESOURCE_KEY);
            if (xMLNode != null && (object = xMLNode.getText()) != null) {
                this.m_bundle = ResourceBundle.getBundle((String)object);
            }
            if ((object = xMLDocument.selectNodes("/navigator/connection")) != null) {
                for (int i = 0; i < object.getLength(); ++i) {
                    ConnectionType connectionType = new ConnectionType((XMLNode)object.item(i), this);
                    this.m_types.put(connectionType.getType(), connectionType);
                }
            }
        }
        catch (XSLException xSLException) {
            // empty catch block
        }
    }

    public XMLDocument getDocument() {
        return this.m_doc;
    }

    public String getString(String string) {
        try {
            return this.m_bundle != null ? this.m_bundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("No Value for key:" + string);
            return string;
        }
    }

    public ConnectionType getConnectionType(String string) {
        return this.m_types.get(string);
    }

    public Iterator<ConnectionType> getConnectionTypes() {
        return this.m_types.values().iterator();
    }
}

