/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.xml;

import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.filter.FilterDetails;
import oracle.dbtools.raptor.navigator.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.xml.parser.v2.XMLNode;

public class ConnectionTypeDetails {
    public static final float UNORDERED = 100.0f;
    private String m_type;
    private boolean m_otherSchemasSupported;
    private boolean m_showAllSchemasAtTopLevel;
    private boolean m_supportsCatalogs;
    private String m_providerClass;
    private String m_panelClass;
    private boolean m_rowid;
    private String m_iconKey;
    private Icon m_icon;
    private NavigatorDescriptor m_desc;
    private String m_panelLabel;

    protected ConnectionTypeDetails() {
    }

    void init(XMLNode xMLNode, NavigatorDescriptor navigatorDescriptor) {
        this.m_desc = navigatorDescriptor;
        this.m_type = XmlNavigatorUtils.getAttributeValue("", "id", xMLNode);
        this.m_otherSchemasSupported = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "supportsOtherSchemas", xMLNode));
        this.m_showAllSchemasAtTopLevel = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "showAllSchemas", xMLNode));
        this.m_supportsCatalogs = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "supportsCatalog", xMLNode));
        this.m_providerClass = XmlNavigatorUtils.getAttributeValue("", "providerClass", xMLNode);
        this.m_rowid = Boolean.parseBoolean(XmlNavigatorUtils.getAttributeValue("", "supportsRowId", xMLNode));
        this.m_iconKey = XmlNavigatorUtils.getAttributeValue("icon", "RSKEY", xMLNode);
        this.m_panelClass = XmlNavigatorUtils.getAttributeValue("", "connectionPanelClass", xMLNode);
        this.m_panelLabel = XmlNavigatorUtils.getAttributeValue("", "connectionTabName", xMLNode);
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isOtherSchemasSupported() {
        return this.m_otherSchemasSupported;
    }

    public String getProviderClass() {
        return this.m_providerClass;
    }

    public boolean isShowAllSchemasAtTopLevel() {
        return this.m_showAllSchemasAtTopLevel;
    }

    public boolean isSupportsCatalog() {
        return this.m_supportsCatalogs;
    }

    public boolean isRowIdSupported() {
        return this.m_rowid;
    }

    public Icon getIcon() {
        if (this.m_icon == null && this.m_iconKey != null) {
            this.m_icon = XmlNavigatorUtils.getIcon(this.m_desc.getString(this.m_iconKey));
        }
        return this.m_icon;
    }

    public String getConnectionPanel() {
        return this.m_panelClass;
    }

    public String getConnectionPanelLabel() {
        return this.m_panelLabel;
    }

    public Integer getPreferredFetchSize() {
        return null;
    }

    public boolean isSupportsAutocommit() {
        return false;
    }

    public boolean isOracle() {
        return false;
    }

    public float getWeight() {
        return 100.0f;
    }

    public FilterDetails getFilterDetails() {
        return new FilterDetails();
    }

    public Class getNLSProvider() {
        return DefaultNLSProvider.class;
    }

    public static ConnectionTypeDetails getTypeDetails(String string, Connection connection) {
        ConnectionTypeDetails connectionTypeDetails = null;
        ObjectFactory objectFactory = ObjectFactory.getFactory(string, connection);
        if (objectFactory != null) {
            connectionTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
        }
        return connectionTypeDetails;
    }
}

