/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.compiler.PlSqlTranslator;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.runner.ArgusHelper;
import oracle.ide.Ide;
import oracle.ide.compiler.Compiler;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.Debugger;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class PlSqlNode
extends RunnableSourceNode {
    public static final String HAS_BODY_KEY = "HAS_BODY";
    public static final String CONN_NAME = "connectionName";
    private boolean m_isBody;
    private String _connName;

    public PlSqlNode() {
        Attributes attributes = this.getAttributes();
        attributes.set(ElementAttributes.BUILDABLE);
        attributes.unset(ElementAttributes.RENAMEABLE);
        attributes.set(ElementAttributes.SAVEABLE_AS);
    }

    public void setConnectionName(String string) {
        this._connName = string;
    }

    public String getConnectionName() {
        return this._connName;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        String string = (String)this.getProperty("TYPE");
        this.m_isBody = "PACKAGE BODY".equals(string) || "TYPE BODY".equals(string);
    }

    public boolean mayHaveChildren() {
        return DBURLFormatHelper.isDBURL(this.getURL());
    }

    public Icon getIcon() {
        return DBURLFormatHelper.isDBURL(this.getURL()) ? this.getNodeInstance().getDescriptor().getIcon() : super.getIcon();
    }

    public boolean isBody() {
        return this.m_isBody;
    }

    public String getPackage(Project project) {
        URL uRL = this.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        if (string == null) {
            return null;
        }
        string = ArgusHelper.getArgusNameForType(string);
        String string2 = DBURLFormatHelper.getSchema(uRL);
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append("$Oracle.");
        fastStringBuffer.append(string);
        fastStringBuffer.append(".");
        fastStringBuffer.append(string2);
        return fastStringBuffer.toString();
    }

    public String getSourceFile() {
        String string = (String)this.getProperty("NAME");
        return ModelUtil.hasLength((String)string) ? string + ".pls" : URLFileSystem.getFileName((URL)this.getURL());
    }

    protected void saveImpl() throws IOException {
        boolean bl = this.isDirty();
        if (bl && !DBURLFormatHelper.isDBURL(this.getURL())) {
            super.saveImpl();
        } else if (bl) {
            Debugger debugger = Debugger.getDebugger();
            if (debugger.isDebugging()) {
                throw new IOException(ConnectionArb.getString((int)636));
            }
            TextBuffer textBuffer = this.getTextBufferDirectly();
            if (textBuffer != null) {
                textBuffer.clearModified();
            }
            Compiler compiler = Compiler.getCompiler();
            PlSqlTranslator plSqlTranslator = new PlSqlTranslator();
            IdeStorage ideStorage = new IdeStorage((Node)this);
            IdeLog ideLog = new IdeLog();
            LogPage logPage = compiler.getErrorLog();
            ideLog.registerAsynchronousLogPage(logPage);
            ideLog.setProject(Ide.getActiveProject() != null ? Ide.getActiveProject() : Ide.getDefaultProject());
            ideLog.setWorkspace(Ide.getActiveWorkspace() != null ? Ide.getActiveWorkspace() : Ide.getDefaultWorkspace());
            ideLog.clear((Storage)ideStorage);
            plSqlTranslator.setLog((Translator.Log)ideLog);
            ArrayList<IdeStorage> arrayList = new ArrayList<IdeStorage>();
            arrayList.add(ideStorage);
            ArrayList arrayList2 = new ArrayList();
            int n = plSqlTranslator.translate(null, false, arrayList, arrayList2);
            this.setProperty("INVALID", "false");
            boolean bl2 = false;
            boolean bl3 = false;
            for (PlSqlErrorInfo plSqlErrorInfo : arrayList2) {
                if (!plSqlErrorInfo.isWarning()) {
                    this.setProperty("INVALID", "true");
                    bl3 = true;
                    continue;
                }
                bl2 = true;
            }
            DatabaseOverlayClient.updateOverlay(this);
            plSqlTranslator.setLog(null);
            ideLog.completed();
            ideLog.unregisterAsynchronousLogPage(logPage);
            if (bl3 && bl2) {
                compiler.getOutputLog().log((Object)(this.getShortLabel() + " Compiled (with errors and warnings)\n"));
            } else if (bl3) {
                compiler.getOutputLog().log((Object)(this.getShortLabel() + " Compiled (with errors) \n"));
            } else if (bl2) {
                compiler.getOutputLog().log((Object)(this.getShortLabel() + " Compiled (with warnings)\n"));
            } else {
                compiler.getOutputLog().log((Object)(this.getShortLabel() + " Compiled \n"));
            }
        }
    }

    public String getShortLabel() {
        if (DBURLFormatHelper.isDBURL(this.getURL())) {
            String string = super.getShortLabel();
            return this.m_isBody ? string + " Body" : string;
        }
        return super.getShortLabel();
    }

    public static int offset(String string, String string2) {
        int n = -1;
        int n2 = 0;
        String string3 = string.toLowerCase();
        if ("TRIGGER".equals(string2)) {
            n = string3.indexOf("begin");
            int n3 = string3.indexOf("declare");
            if (n3 >= 0) {
                n = n3;
            }
            n2 = 1;
            String string4 = string.substring(0, n);
            String[] stringArray = string4.split("\n");
            n = stringArray.length + n2;
            return n;
        }
        return string3.startsWith("create") ? 1 : 0;
    }

    public Object getProperty(String string) {
        return "SHORT_NAME".equals(string) && "BLOCK".equals(this.m_type) ? "ANONYMOUS_BLOCK" : super.getProperty(string);
    }
}

