/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseItem;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.navigator.xml.AbstractChildInstance;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlSubprogramDeclarator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.parser.plsql.data.PlsqlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlArguments
implements FilterChildProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DBChildInstance> listChildren(DatabaseNode databaseNode, String string) throws AbortException, SQLException {
        ArrayList<DBChildInstance> arrayList = new ArrayList<DBChildInstance>();
        if (!"ARGS".equals(string)) return arrayList;
        DBObjectInstance dBObjectInstance = databaseNode.getNodeInstance();
        DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
        DatabaseItem databaseItem = databaseObject.getChildType(string);
        if (databaseItem == null) return arrayList;
        String string2 = databaseObject.getType();
        String string3 = null;
        if ("PACKAGE".equals(string2)) {
            string3 = "Spec";
        } else if ("PACKAGE BODY".equals(string2)) {
            string2 = "PACKAGE";
            string3 = "Body";
        }
        ObjectFactory objectFactory = dBObjectInstance.getObjectFactory();
        Connection connection = objectFactory.getConnection();
        if (!Connections.getInstance().lock(connection)) {
            throw new AbortException("listChildren");
        }
        TextBuffer textBuffer = ((PlSqlNode)databaseNode).acquireTextBuffer();
        try {
            if (textBuffer == null) return arrayList;
            String string4 = textBuffer.getString(0, textBuffer.getLength());
            Database database = Connections.getInstance().getDatabase(connection);
            if (database == null) return arrayList;
            if ("PROCEDURE".equals(string2) || "FUNCTION".equals(string2)) {
                Procedure procedure = "PROCEDURE".equals(string2) ? new Procedure((String)databaseNode.getProperty("NAME"), database.getSchema((String)databaseNode.getProperty("SCHEMA"))) : new Function((String)databaseNode.getProperty("NAME"), database.getSchema((String)databaseNode.getProperty("SCHEMA")));
                procedure.setSource(string4);
                PlSqlSubprogramDeclarator plSqlSubprogramDeclarator = new PlSqlSubprogramDeclarator((DBObjectProvider)database);
                plSqlSubprogramDeclarator.loadDeclarativeInfo((SourceObject)procedure);
                for (PlSqlParameter plSqlParameter : procedure.getParameters()) {
                    ArgChildInstance argChildInstance = new ArgChildInstance(objectFactory);
                    argChildInstance.setDescriptor(databaseItem);
                    argChildInstance.setProperty("NAME", plSqlParameter.getName());
                    argChildInstance.setProperty("CODE_OFFSET", -1);
                    arrayList.add(argChildInstance);
                }
                if (!"FUNCTION".equals(string2)) return arrayList;
                DataType dataType = procedure.getReturnType();
                ArgChildInstance argChildInstance = new ArgChildInstance(objectFactory);
                argChildInstance.setDescriptor(databaseItem);
                argChildInstance.setProperty("NAME", dataType != null ? dataType.getName() : "NO RETURN FOUND");
                argChildInstance.setProperty("CODE_OFFSET", -1);
                arrayList.add(argChildInstance);
                return arrayList;
            }
            if (!"PACKAGE".equals(string2)) return arrayList;
            PlSqlInterrogator plSqlInterrogator = new PlSqlInterrogator(string4);
            PlSqlFragment plSqlFragment = this.getInitialFragment(plSqlInterrogator.getRoot());
            if (plSqlFragment == null) return arrayList;
            switch (plSqlFragment.getType()) {
                case 6: 
                case 7: {
                    PlsqlNode[] plsqlNodeArray = plSqlFragment.getUnits();
                    int n = plsqlNodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PlsqlNode plsqlNode = plsqlNodeArray[n2];
                        ArgChildInstance argChildInstance = this.createChild(plsqlNode, objectFactory, textBuffer);
                        if (argChildInstance != null) {
                            argChildInstance.setDescriptor(databaseItem);
                            arrayList.add(argChildInstance);
                        }
                        ++n2;
                    }
                    return arrayList;
                }
            }
            return arrayList;
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            dBException.printStackTrace();
            return arrayList;
        }
        finally {
            Connections.getInstance().unlock(connection);
            ((PlSqlNode)databaseNode).releaseTextBuffer();
        }
    }

    private PlSqlFragment getInitialFragment(PlSqlFragment plSqlFragment) {
        PlsqlNode[] plsqlNodeArray;
        PlSqlFragment plSqlFragment2 = null;
        if (plSqlFragment != null && (plsqlNodeArray = plSqlFragment.getUnits()) != null && plsqlNodeArray.length == 1 && plsqlNodeArray[0] instanceof PlSqlFragment) {
            plSqlFragment2 = (PlSqlFragment)plsqlNodeArray[0];
        }
        return plSqlFragment2;
    }

    private ArgChildInstance createChild(PlsqlNode plsqlNode, ObjectFactory objectFactory, TextBuffer textBuffer) {
        String string;
        StringTokenizer stringTokenizer;
        assert (plsqlNode instanceof PlSqlFragment);
        PlSqlFragment plSqlFragment = (PlSqlFragment)plsqlNode;
        ArgChildInstance argChildInstance = new ArgChildInstance(objectFactory);
        String string2 = plSqlFragment.getDescriptionString();
        if ("CURSOR".equals(string2)) {
            string2 = plSqlFragment.getSource();
            stringTokenizer = new StringTokenizer(string2);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (bl) {
                    string2 = string;
                    break;
                }
                if (!"CURSOR".equals(string)) continue;
                bl = true;
            }
        }
        argChildInstance.setProperty("NAME", string2);
        argChildInstance.setProperty("CODE_OFFSET", plSqlFragment.getStartOffset());
        argChildInstance.offsetMark = textBuffer.addOffsetMark(plSqlFragment.getStartOffset());
        stringTokenizer = plSqlFragment.getFirstToken();
        PlSqlToken plSqlToken = stringTokenizer.getNextCodeToken();
        string = stringTokenizer.getSource();
        argChildInstance.setProperty("MEMBER_TYPE", string);
        if (plSqlToken != null) {
            if ("DATE".equalsIgnoreCase(plSqlToken.getSource()) || "TIME".equalsIgnoreCase(plSqlToken.getSource()) || "TIMESTAMP".equalsIgnoreCase(plSqlToken.getSource())) {
                argChildInstance.setProperty("MEMBER_TYPE", "DATE");
            } else if (plSqlToken.getSource().toUpperCase().contains("CHAR")) {
                argChildInstance.setProperty("MEMBER_TYPE", "STRING");
            } else if ((string + plSqlToken.getSource()).toUpperCase().contains("EXCEPTION")) {
                argChildInstance.setProperty("MEMBER_TYPE", "EXCEPTION");
            }
        }
        return argChildInstance;
    }

    private static class ArgChildInstance
    extends AbstractChildInstance {
        private ArgChildInstance(ObjectFactory objectFactory) {
            super(objectFactory);
        }

        protected void setDescriptor(DatabaseItem databaseItem) {
            super.setDescriptor(databaseItem);
        }
    }
}

