/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.jdbc.JDBCDBFolder;
import oracle.dbtools.raptor.navigator.jdbc.JDBCDBItem;
import oracle.dbtools.raptor.navigator.jdbc.JDBCObjectInstance;
import oracle.dbtools.raptor.navigator.jdbc.JDBCObjectType;
import oracle.dbtools.raptor.navigator.jdbc.JDBCSchemaInstance;
import oracle.dbtools.raptor.navigator.jdbc.JDBCTableFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.util.ModelUtil;

public class JDBCNavProvider
extends ObjectFactory {
    private List<JDBCObjectType> m_types;
    private Map<String, List<String>> m_catalogsAndSchemas;
    private boolean m_hasCatalogs;

    public JDBCNavProvider(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        super(connectionInfo, connectionType);
        this.initCatalogs();
    }

    public DBSchemaInstance createSchemaInstance(String string) {
        JDBCSchemaInstance jDBCSchemaInstance = new JDBCSchemaInstance(this);
        jDBCSchemaInstance.setProperty("SCHEMA", string);
        jDBCSchemaInstance.setProperty("ConnectionType", this.getConnectionType());
        return jDBCSchemaInstance;
    }

    public DBCatalogInstance createCatalogInstance(String string) {
        return null;
    }

    public DBChildInstance createChildInstance(String string, String string2) {
        return null;
    }

    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        JDBCTableFolderInstance jDBCTableFolderInstance = new JDBCTableFolderInstance(this, (JDBCDBFolder)databaseFolder);
        jDBCTableFolderInstance.setProperty("TYPE", string);
        return jDBCTableFolderInstance;
    }

    public DBObjectInstance createNodeInstance(String string) {
        JDBCObjectInstance jDBCObjectInstance = new JDBCObjectInstance(this, (JDBCDBItem)this.getObjectDescriptor(string));
        jDBCObjectInstance.setProperty("TYPE", string);
        return jDBCObjectInstance;
    }

    public DBCatalogsInstance getCatalogsInstance() {
        return null;
    }

    public DatabaseObject getObjectDescriptor(String string) {
        ObjectType objectType = this.getObjectType(string);
        return objectType != null ? objectType.getNode() : null;
    }

    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        return null;
    }

    public ObjectType[] listTypes() {
        if (this.m_types == null) {
            this.initTypes();
        }
        return this.m_types.toArray(new JDBCObjectType[0]);
    }

    private ObjectType getObjectType(String string) {
        assert (string != null);
        if (this.m_types == null) {
            this.initTypes();
        }
        for (JDBCObjectType jDBCObjectType : this.m_types) {
            if (!ModelUtil.areEqual((Object)string, (Object)jDBCObjectType.getType())) continue;
            return jDBCObjectType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTypes() {
        this.m_types = new ArrayList<JDBCObjectType>();
        DatabaseMetaData databaseMetaData = null;
        ResultSet resultSet = null;
        try {
            databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getTableTypes();
            while (resultSet.next()) {
                this.m_types.add(new JDBCObjectType(this.getConnectionType(), resultSet.getString(1), "/oracle/dbtools/raptor/images/table_folder.png", "/oracle/ide/icons/images/db/table.png"));
            }
            if (databaseMetaData.supportsStoredProcedures()) {
                this.m_types.add(new JDBCObjectType(this.getConnectionType(), "Procedures", "/oracle/dbtools/raptor/images/table_folder.png", "/oracle/ide/icons/images/db/table.png"));
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isShowAllSchemasAtTopLevel() {
        return super.isShowAllSchemasAtTopLevel();
    }

    public boolean isSupportsCatalog() {
        return super.isSupportsCatalog();
    }

    public boolean isShowOtherSchemas() {
        return super.isShowOtherSchemas();
    }

    private DatabaseMetaData getMetaData() {
        DatabaseMetaData databaseMetaData = null;
        Connection connection = this.getConnection();
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        return databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCatalogs() {
        DatabaseMetaData databaseMetaData;
        if (this.m_catalogsAndSchemas == null && (databaseMetaData = this.getMetaData()) != null) {
            ResultSet resultSet = null;
            try {
                this.m_catalogsAndSchemas = new HashMap<String, List<String>>();
                resultSet = databaseMetaData.getCatalogs();
                while (resultSet.next()) {
                    this.m_catalogsAndSchemas.put(resultSet.getString(1), new ArrayList());
                }
                this.m_hasCatalogs = true;
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    resultSet = null;
                }
            }
            try {
                resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    String string2 = resultSet.getString(2);
                    List<String> list = this.m_catalogsAndSchemas.get(string2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.m_catalogsAndSchemas.put(string2, list);
                    }
                    list.add(string);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                    resultSet = null;
                }
            }
        }
    }
}

