/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.XMLSchema;

public class XmlSchemaNode
extends DatabaseSourceNode {
    public static final String REGISTER_SCHEMA_BLOCK = "BEGIN\n  DBMS_XMLSCHEMA.REGISTERSCHEMA(\n    SCHEMAURL => :URL,\n    SCHEMADOC => XMLTYPE(:DOC)\n);END;";

    protected void saveImpl() throws IOException {
        boolean bl = this.isDirty();
        if (bl) {
            if (!DBURLFormatHelper.isDBURL(this.getURL())) {
                super.saveImpl();
            } else {
                String string = (String)this.getProperty("ConnectionName");
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("URL", (String)this.getProperty("NAME"));
                TextBuffer textBuffer = this.getTextBufferDirectly();
                hashMap.put("DOC", textBuffer.getString(0, textBuffer.getLength()));
                if (!DBUtil.getInstance().execute(string, REGISTER_SCHEMA_BLOCK, hashMap)) {
                    throw new IOException("Error saving XML schema");
                }
            }
        }
    }

    protected Reader createReader(URL uRL) throws IOException {
        StringReader stringReader = null;
        String string = (String)this.getProperty("ConnectionName");
        try {
            Database database = Connections.getInstance().getDatabase(string, false);
            XMLSchema xMLSchema = (XMLSchema)database.getObject((String)this.getProperty("TYPE"), database.getSchema((String)this.getProperty("SCHEMA")), (String)this.getProperty("NAME"));
            if (xMLSchema != null) {
                Map map = xMLSchema.getProperties();
                String string2 = xMLSchema.getSchemaText();
                stringReader = string2 != null ? new StringReader(string2) : new StringReader("");
            }
        }
        catch (DBException dBException) {
            throw new IOException(dBException.getMessage());
        }
        return stringReader;
    }
}

