/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import java.text.MessageFormat;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.ModelUtil;

public class ObjectNode
extends Node
implements DatabaseNode {
    private String m_name;
    private String m_cName;
    private String m_type;
    private String m_schema;
    private DBObjectInstance m_node;
    private boolean m_isFolder = DatabaseNavigatorManager.getInstance().getChildFilterFactoryForType(this.getClass()) != null;
    private static final String LONG_DISPLAY_FORMAT = "{0} {1}.{2}@{3}";

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.m_name = DBURLFormatHelper.getName(uRL);
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_type = DBURLFormatHelper.getBaseType(uRL);
        this.m_schema = DBURLFormatHelper.getSchema(uRL);
    }

    public void setNodeInstance(DBObjectInstance dBObjectInstance) {
        DBObjectInstance dBObjectInstance2 = this.m_node;
        this.m_node = dBObjectInstance;
        if (dBObjectInstance2 != null && ModelUtil.areDifferent((Object)dBObjectInstance2, (Object)this.m_node)) {
            IconOverlayTracker iconOverlayTracker;
            UpdateMessage.fireStructureChanged((Subject)this);
            if (ModelUtil.areDifferent((Object)dBObjectInstance2.getProperty("INVALID"), (Object)this.m_node.getProperty("INVALID")) && (iconOverlayTracker = DatabaseOverlayClient.getTracker()) != null) {
                iconOverlayTracker.validateOverlay((Element)this);
                iconOverlayTracker.repaintOverlays();
            }
        }
        this.m_isFolder = DatabaseNavigatorManager.getInstance().getChildFilterFactoryForType(this.getClass()) != null && ((DatabaseObject)this.m_node.getDescriptor()).getChildTypes() != null;
    }

    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public Icon getIcon() {
        return this.m_node.getDescriptor().getIcon();
    }

    public void setProperty(String string, Object object) {
        this.m_node.setProperty(string, object);
    }

    public Object getProperty(String string) {
        Object object = null;
        object = "INTERNAL_NAME".equals(string) ? this.m_name : ("SCHEMA".equals(string) ? this.m_schema : ("TYPE".equals(string) ? this.m_type : ("ConnectionName".equals(string) ? this.m_cName : this.m_node.getProperty(string))));
        return object;
    }

    public String getToolTipText() {
        return this.m_node.getProperty("TOOLTIP") != null && !this.m_node.getProperty("TOOLTIP").equals("") ? (String)this.m_node.getProperty("TOOLTIP") : ObjectNode.getDefaultLongDisplay(this.getURL(), this.getShortLabel());
    }

    public static String getDefaultLongDisplay(URL uRL, String string) {
        String string2 = DBURLFormatHelper.getConnectionName(uRL);
        String string3 = DBURLFormatHelper.getBaseType(uRL);
        String string4 = DBURLFormatHelper.getSchema(uRL);
        if (string == null) {
            string = DBURLFormatHelper.getName(uRL);
        }
        return MessageFormat.format(LONG_DISPLAY_FORMAT, string3, string4, string, string2);
    }

    public String getLongLabel() {
        return this.m_node.getProperty("LONG_NAME") != null && !this.m_node.getProperty("LONG_NAME").equals("") ? (String)this.m_node.getProperty("LONG_NAME") : ObjectNode.getDefaultLongDisplay(this.getURL(), this.getShortLabel());
    }

    public boolean mayHaveChildren() {
        return this.m_isFolder;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public String getShortLabel() {
        if (this.m_node.getProperty("SHORT_NAME") != null && !this.m_node.getProperty("SHORT_NAME").equals("")) {
            return (String)this.m_node.getProperty("SHORT_NAME");
        }
        return this.m_name;
    }
}

