/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import java.text.MessageFormat;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class ObjectFolder
extends DefaultFolder
implements Subject,
Locatable,
DatabaseElement {
    private String m_cName;
    private String m_objType;
    private URL m_url;
    private Subject m_subjectProxy = new IdeSubject();
    private DBFolderInstance m_folder;

    public ObjectFolder(URL uRL) {
        this.setURL(uRL);
    }

    void setFolderInstance(DBFolderInstance dBFolderInstance) {
        this.m_folder = dBFolderInstance;
    }

    public String getShortLabel() {
        return ObjectFolder.getShortLabel(this.m_folder);
    }

    public static String getShortLabel(DBContainerInstance dBContainerInstance) {
        String string = ((DatabaseContainer)dBContainerInstance.getDescriptor()).getLabel();
        return dBContainerInstance.isFiltered() ? MessageFormat.format("{0} (Filtered)", string) : string;
    }

    public Icon getIcon() {
        return this.m_folder.getDescriptor().getIcon();
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public DBFolderInstance getFolderInstance() {
        return this.m_folder;
    }

    public void setProperty(String string, Object object) {
        this.m_folder.setProperty(string, object);
    }

    public Object getProperty(String string) {
        Object object = null;
        object = "TYPE".equals(string) ? this.m_objType : ("ConnectionName".equals(string) ? this.m_cName : this.m_folder.getProperty(string));
        return object;
    }

    public void attach(Observer observer) {
        this.m_subjectProxy.attach(observer);
    }

    public void detach(Observer observer) {
        this.m_subjectProxy.detach(observer);
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.m_subjectProxy.notifyObservers(object, updateMessage);
    }

    public URL getURL() {
        return this.m_url;
    }

    public String getObjectType() {
        return this.m_objType;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_objType = DBURLFormatHelper.getBaseType(uRL);
    }
}

