/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.ModelUtil;

public class DatabaseSourceNode
extends TextNode
implements DatabaseNode {
    protected String m_name;
    protected String m_cName;
    protected String m_type;
    protected String m_schema;
    protected DBObjectInstance m_node;

    public void setURL(URL uRL) {
        super.setURL(uRL);
        if (DBURLFormatHelper.isDBURL(uRL)) {
            this.m_name = DBURLFormatHelper.getName(uRL);
            this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
            this.m_type = DBURLFormatHelper.getBaseType(uRL);
            this.m_schema = DBURLFormatHelper.getSchema(uRL);
        }
    }

    public void setNodeInstance(DBObjectInstance dBObjectInstance) {
        DBObjectInstance dBObjectInstance2 = this.m_node;
        this.m_node = dBObjectInstance;
        if (dBObjectInstance2 != null && ModelUtil.areDifferent((Object)dBObjectInstance2, (Object)this.m_node)) {
            IconOverlayTracker iconOverlayTracker;
            UpdateMessage.fireStructureChanged((Subject)this);
            if (ModelUtil.areDifferent((Object)dBObjectInstance2.getProperty("INVALID"), (Object)this.m_node.getProperty("INVALID")) && (iconOverlayTracker = DatabaseOverlayClient.getTracker()) != null) {
                iconOverlayTracker.validateOverlay((Element)this);
                iconOverlayTracker.repaintOverlays();
            }
        }
    }

    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public void setProperty(String string, Object object) {
        if (this.m_node != null) {
            this.m_node.setProperty(string, object);
        }
    }

    public Object getProperty(String string) {
        Object object = null;
        object = "NAME".equals(string) ? this.m_name : ("SCHEMA".equals(string) ? this.m_schema : ("TYPE".equals(string) ? this.m_type : ("ConnectionName".equals(string) ? this.m_cName : (this.m_node == null ? null : this.m_node.getProperty(string)))));
        return object;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public NavigationPoint getNavigationPoint(ChildObjectElement childObjectElement) {
        OffsetNavigationPoint offsetNavigationPoint = null;
        Integer n = (Integer)childObjectElement.getProperty("CODE_OFFSET");
        if (childObjectElement.getOffsetMark() != null) {
            n = childObjectElement.getOffsetMark().getOffset();
        }
        if (n != null) {
            Integer n2 = (Integer)childObjectElement.getProperty("CODE_LENGTH");
            offsetNavigationPoint = new OffsetNavigationPoint(Context.newIdeContext((Node)this), n.intValue(), n2 != null ? n2 : 0);
            offsetNavigationPoint.setPreferredEditorType(null);
        }
        return offsetNavigationPoint;
    }

    public final String getSource() {
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer == null) {
            textBuffer = this.acquireTextBuffer();
        }
        if (textBuffer == null) {
            return null;
        }
        int n = textBuffer.getLength();
        char[] cArray = textBuffer.getChars(0, n);
        String string = new String(cArray);
        return string;
    }

    public String getShortLabel() {
        String string = null;
        if (DBURLFormatHelper.isDBURL(this.getURL()) && (string = (String)this.getProperty("SHORT_NAME")) == null) {
            string = this.m_name;
        }
        return string != null ? string : super.getShortLabel();
    }
}

