/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.xml.AbstractChildInstance;
import oracle.dbtools.raptor.navigator.xml.XmlChildImpl;
import oracle.dbtools.raptor.navigator.xml.XmlNavigatorUtils;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.icons.OracleIcons;

public class ChildObjectElement
extends DefaultElement
implements Locatable,
Subject {
    private URL m_url;
    private DBChildInstance m_impl;
    private IdeSubject m_proxy;
    private String m_label;

    public ChildObjectElement(URL uRL, DBChildInstance dBChildInstance) {
        this.setURL(uRL);
        this.m_impl = dBChildInstance;
    }

    public OffsetMark getOffsetMark() {
        if (this.m_impl instanceof AbstractChildInstance) {
            return ((AbstractChildInstance)this.m_impl).offsetMark;
        }
        return null;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
    }

    public String getShortLabel() {
        return DBURLFormatHelper.getChildName(this.m_url);
    }

    public Icon getIcon() {
        String string = (String)this.m_impl.getProperty("MEMBER_TYPE");
        if ("TYPE".equalsIgnoreCase(string)) {
            return XmlNavigatorUtils.getIcon(((XmlChildImpl)this.m_impl.getDescriptor()).getPath("TYPE_NODE_ICON"));
        }
        if ("DATE".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon(7);
        }
        if ("STRING".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon(47);
        }
        if ("EXCEPTION".equalsIgnoreCase(string)) {
            return RaptorImagesArb.getIcon(14);
        }
        if ("CURSOR".equalsIgnoreCase(string)) {
            return OracleIcons.getIcon((String)"table.png");
        }
        if ("FUNCTION".equalsIgnoreCase(string) || "PROCEDURE".equalsIgnoreCase(string)) {
            return XmlNavigatorUtils.getIcon(((XmlChildImpl)this.m_impl.getDescriptor()).getPath("FUNCTION_NODE_ICON"));
        }
        return this.m_impl.getDescriptor().getIcon();
    }

    public Object getProperty(String string) {
        return this.m_impl.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.m_impl.setProperty(string, object);
    }

    public void attach(Observer observer) {
        if (this.m_proxy == null) {
            this.m_proxy = new IdeSubject();
        }
        this.m_proxy.attach(observer);
    }

    public void detach(Observer observer) {
        if (this.m_proxy != null) {
            this.m_proxy.detach(observer);
        }
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        if (this.m_proxy != null) {
            this.m_proxy.notifyObservers(object, updateMessage);
        }
    }
}

