/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.dbapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.navigator.dbapi.MetadataInstance;
import oracle.dbtools.raptor.navigator.dbapi.MetadataObjectFactory;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemas;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataSchemasInstance
extends MetadataInstance
implements DBSchemasInstance {
    MetadataSchemasInstance(MetadataObjectFactory metadataObjectFactory, DBSchemas dBSchemas) {
        super(metadataObjectFactory, dBSchemas);
    }

    @Override
    public List<DBChildInstance> listChildren() {
        return this.listChildren(null);
    }

    @Override
    public List<DBChildInstance> listChildren(QueryProgressListener queryProgressListener) {
        ArrayList<DBChildInstance> arrayList = new ArrayList<DBChildInstance>();
        Database database = this.getDatabase();
        if (queryProgressListener != null) {
            queryProgressListener.rsOpened();
        }
        try {
            Schema[] schemaArray = database.listSchemas();
            if (schemaArray != null) {
                for (Schema schema : schemaArray) {
                    if (queryProgressListener != null) {
                        queryProgressListener.rsRowFetched();
                    }
                    DBSchemaInstance dBSchemaInstance = this.m_factory.createSchemaInstance(schema.getName());
                    dBSchemaInstance.setProperty("dbapi.schema", schema);
                    Map map = schema.getProperties();
                    if (map != null) {
                        for (Object k : map.keySet()) {
                            dBSchemaInstance.setProperty((String)k, map.get(k));
                        }
                    }
                    arrayList.add(dBSchemaInstance);
                }
            }
            if (queryProgressListener != null) {
                queryProgressListener.rsClosed();
            }
        }
        catch (DBException dBException) {
            ExceptionHandler.handleException((Exception)((Object)dBException));
        }
        return arrayList;
    }

    @Override
    public boolean isFiltered() {
        return false;
    }

    @Override
    public void clearFilter() {
    }

    @Override
    public boolean promptForFilter() {
        return false;
    }
}

