/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.dbapi;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.dbapi.MetadataFolder;
import oracle.dbtools.raptor.navigator.dbapi.MetadataFolderInstance;
import oracle.dbtools.raptor.navigator.dbapi.MetadataObject;
import oracle.dbtools.raptor.navigator.dbapi.MetadataObjectInstance;
import oracle.dbtools.raptor.navigator.dbapi.MetadataObjectType;
import oracle.dbtools.raptor.navigator.dbapi.MetadataSchema;
import oracle.dbtools.raptor.navigator.dbapi.MetadataSchemaInstance;
import oracle.dbtools.raptor.navigator.dbapi.MetadataSchemas;
import oracle.dbtools.raptor.navigator.dbapi.MetadataSchemasInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchema;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemas;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.Database;

public class MetadataObjectFactory
extends ObjectFactory {
    private static DBSchemas s_schemasDesc = new MetadataSchemas();
    private static DBSchema s_schemaDesc = new MetadataSchema();
    private Database m_db;
    private Map<String, ObjectType> m_types = new HashMap<String, ObjectType>();
    private DBSchemasInstance m_schemas;

    public MetadataObjectFactory(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        super(connectionInfo, connectionType);
        this.m_db = Connections.getInstance().getDatabase(connectionInfo.getConnectionName(), connectionInfo.getConnection());
        for (String string : this.m_db.listObjectTypes()) {
            MetadataObjectType metadataObjectType = new MetadataObjectType(this.m_db, string);
            this.m_types.put(string, metadataObjectType);
        }
    }

    public ObjectType[] listTypes() {
        return this.m_types.values().toArray(new ObjectType[0]);
    }

    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        if (this.m_schemas == null) {
            this.m_schemas = new MetadataSchemasInstance(this, s_schemasDesc);
        }
        return this.m_schemas;
    }

    public DatabaseObject getObjectDescriptor(String string) {
        DatabaseObject databaseObject = null;
        ObjectType objectType = this.m_types.get(string);
        if (objectType != null) {
            databaseObject = objectType.getNode();
        }
        return databaseObject;
    }

    public DBCatalogsInstance getCatalogsInstance() {
        return null;
    }

    public DBSchemaInstance createSchemaInstance(String string) {
        return new MetadataSchemaInstance(this, s_schemaDesc, string);
    }

    public DBObjectInstance createNodeInstance(String string) {
        DBItemInstance dBItemInstance = null;
        DatabaseObject databaseObject = this.getObjectDescriptor(string);
        if (databaseObject != null) {
            dBItemInstance = new MetadataObjectInstance(this, (MetadataObject)databaseObject);
        }
        dBItemInstance.setProperty("ConnectionType", this.getConnectionType());
        dBItemInstance.setProperty("TYPE", string);
        return dBItemInstance;
    }

    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        MetadataFolderInstance metadataFolderInstance = new MetadataFolderInstance(this, (MetadataFolder)databaseFolder);
        metadataFolderInstance.setProperty("TYPE", string);
        metadataFolderInstance.setProperty("ConnectionType", this.getConnectionType());
        return metadataFolderInstance;
    }

    public DBChildInstance createChildInstance(String string, String string2) {
        return null;
    }

    public DBCatalogInstance createCatalogInstance(String string) {
        return null;
    }

    public boolean isShowAllSchemasAtTopLevel() {
        return true;
    }

    public boolean isSupportsCatalog() {
        return false;
    }

    Database getDatabase() {
        return this.m_db;
    }
}

