/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.FilterChildProvider;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.UpdateMessage;

public class ObjectNodeFilter
extends BaseRaptorFilter {
    private List<Element> m_children;

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        if (this.m_children != null) {
            for (Object e : updateMessage.getAddObjects()) {
                Element element = (Element)e;
                if (this.m_children.contains(element)) continue;
                this.m_children.add(element);
                TNode tNode2 = treeExplorer.addChild(element, tNode, treeExplorer.getTreeModel());
                this.cache(tNode2);
            }
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        return super.childrenRemoved(updateMessage, tNode, treeExplorer);
    }

    public boolean canRefresh(TNode[] tNodeArray) {
        return true;
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<Element>();
            DatabaseNode databaseNode = (DatabaseNode)this.getOwner().getData();
            URL uRL = databaseNode.getURL();
            DBObjectInstance dBObjectInstance = databaseNode.getNodeInstance();
            DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
            try {
                for (String string : databaseObject.getChildTypes()) {
                    Class clazz = databaseObject.getChildProvider(string);
                    List<DBChildInstance> list = null;
                    if (clazz != null) {
                        assert (FilterChildProvider.class.isAssignableFrom(clazz));
                        try {
                            FilterChildProvider filterChildProvider = (FilterChildProvider)clazz.newInstance();
                            list = filterChildProvider.listChildren(databaseNode, string);
                        }
                        catch (Exception exception) {}
                    } else {
                        list = dBObjectInstance.listChildren(string);
                    }
                    if (list == null) continue;
                    for (DBChildInstance dBChildInstance : list) {
                        String string2 = (String)dBChildInstance.getProperty("NAME");
                        if (string2 == null) continue;
                        this.m_children.add(DatabaseNavigatorElementFactory.createChildElement(uRL, string, dBChildInstance));
                    }
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException(sQLException);
            }
            catch (AbortException abortException) {
                this.m_children.clear();
            }
        }
        return this.m_children.iterator();
    }

    public void closeChildren() {
        if (this.m_children != null) {
            this.m_children = null;
        }
    }

    protected Object getKey(Object object) {
        return null;
    }

    public void refresh(TNode[] tNodeArray) {
        if (this.m_children != null) {
            this.m_children = null;
        }
    }

    public Comparator getComparator() {
        return null;
    }
}

