/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.navigator.dbapi.MetadataObjectFactory;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.model.ObjectType;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.xml.XmlObjectFactory;
import oracle.javatools.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory {
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";
    private static Map<Connection, ObjectFactory> s_factories = new HashMap<Connection, ObjectFactory>();
    private static List<ConnectionRecognizer> s_recognizers = new ArrayList<ConnectionRecognizer>();
    private static ConnectionRecognizer s_defaultRecognizer = new DefaultConnectionRecognizer();
    private ConnectionInfo m_info;
    private ConnectionType m_type;
    private Map<String, Object> _globalBinds;

    public static final ObjectFactory getFactory(String string, Connection connection) {
        ObjectFactory objectFactory = s_factories.get(connection);
        if (objectFactory == null) {
            objectFactory = ObjectFactory.createFactory(string, connection);
            s_factories.put(connection, objectFactory);
        }
        return objectFactory;
    }

    private static ObjectFactory createFactory(String string, Connection connection) {
        ObjectFactory objectFactory = null;
        ConnectionInfo connectionInfo = ObjectFactory.createConnectionInfo(string, connection);
        ConnectionType connectionType = NavigatorHook.getConnectionType(connectionInfo.getConnectionType());
        if (connectionType != null) {
            String string2 = connectionType.getProviderClass();
            if (string2 != null) {
                try {
                    Class<?> clazz = Class.forName(string2);
                    Constructor<?> constructor = clazz.getConstructor(ConnectionInfo.class, ConnectionType.class);
                    if (constructor != null) {
                        objectFactory = (ObjectFactory)constructor.newInstance(connectionInfo, connectionType);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (objectFactory == null) {
                objectFactory = new XmlObjectFactory(connectionInfo, connectionType);
            }
        }
        if (objectFactory == null) {
            objectFactory = new MetadataObjectFactory(connectionInfo, connectionType);
        }
        return objectFactory;
    }

    public static void registerRecognizer(ConnectionRecognizer connectionRecognizer) {
        if (!s_recognizers.contains(connectionRecognizer)) {
            s_recognizers.add(connectionRecognizer);
        }
    }

    public static void unregisterRecognizer(ConnectionRecognizer connectionRecognizer) {
        s_recognizers.remove(connectionRecognizer);
    }

    private static ConnectionInfo createConnectionInfo(String string, Connection connection) {
        for (ConnectionRecognizer connectionRecognizer : s_recognizers) {
            ConnectionInfo connectionInfo = connectionRecognizer.createConnectionInfo(string, connection);
            if (connectionInfo == null) continue;
            return connectionInfo;
        }
        return s_defaultRecognizer.createConnectionInfo(string, connection);
    }

    protected ObjectFactory(ConnectionInfo connectionInfo, ConnectionType connectionType) {
        this.m_info = connectionInfo;
        this.m_type = connectionType;
    }

    public Map<String, Object> getGlobalBindMap() {
        return this._globalBinds != null ? new HashMap<String, Object>(this._globalBinds) : new HashMap();
    }

    public void setGlobalBindMap(Map<String, Object> map) {
        this._globalBinds = map != null ? new HashMap<String, Object>(map) : null;
    }

    public final String getSchema() {
        return this.m_info.getSchema();
    }

    public final Version getVersion() {
        return this.m_info.getVersion();
    }

    public final Connection getConnection() {
        return this.m_info.getConnection();
    }

    public final String getConnectionType() {
        return this.m_info.getConnectionType();
    }

    public final String getConnectionName() {
        return this.m_info.getConnectionName();
    }

    public boolean isShowAllSchemasAtTopLevel() {
        return this.m_type.isShowAllSchemasAtTopLevel();
    }

    public boolean isShowOtherSchemas() {
        return this.m_type.isOtherSchemasSupported();
    }

    public boolean isSupportsCatalog() {
        return this.m_type.isSupportsCatalog();
    }

    protected ConnectionInfo getConnectionInfo() {
        return this.m_info;
    }

    public ConnectionType getConnectionTypeDescriptor() {
        return this.m_type;
    }

    public abstract ObjectType[] listTypes();

    public abstract DatabaseObject getObjectDescriptor(String var1);

    public abstract DBFolderInstance createFolderInstance(String var1, DatabaseFolder var2);

    public abstract DBObjectInstance createNodeInstance(String var1);

    public abstract DBChildInstance createChildInstance(String var1, String var2);

    public abstract DBSchemasInstance getSchemasInstance(DBCatalogInstance var1);

    public abstract DBSchemaInstance createSchemaInstance(String var1);

    public abstract DBCatalogsInstance getCatalogsInstance();

    public abstract DBCatalogInstance createCatalogInstance(String var1);

    private static class DefaultConnectionRecognizer
    implements ConnectionRecognizer {
        private DefaultConnectionRecognizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionInfo createConnectionInfo(String string, Connection connection) {
            ConnectionInfo connectionInfo = null;
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = connection.getMetaData();
                String string2 = databaseMetaData.getDatabaseProductVersion();
                Pattern pattern = Pattern.compile(ObjectFactory.VERSION_PATTERN);
                Matcher matcher = pattern.matcher(string2);
                String string3 = matcher.find() ? matcher.group() : null;
                connectionInfo = new ConnectionInfo(string, connection, new Version(string3), databaseMetaData.getDatabaseProductName(), null, databaseMetaData.getUserName());
            }
            catch (SQLException sQLException) {}
            return connectionInfo;
        }
    }
}

