/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class Databases
extends DefaultContainer
implements ConnectionListener {
    private static Databases INSTANCE;

    public static synchronized Databases getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Databases();
        }
        return INSTANCE;
    }

    private Databases() {
    }

    public String getShortLabel() {
        return "Connections";
    }

    public Icon getIcon() {
        return RaptorImagesArb.getIcon(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        Connections connections = Connections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            for (String string : connections.getConnNames()) {
                DatabaseConnection databaseConnection = Databases.getConnectionNode(string, true);
                if (databaseConnection == null) continue;
                this.updateOverlaysForNode(databaseConnection);
                this._children.add(databaseConnection);
            }
        }
        connections.addConnectionListener(this);
    }

    private static boolean isJDBCConnection(String string) {
        boolean bl = false;
        ConnectionDescriptor connectionDescriptor = Connections.getInstance().getConnectionInfo(string);
        if (connectionDescriptor != null) {
            String string2 = connectionDescriptor.getConnectionType();
            bl = "JDBC".equals(string2) || "ORACLE_LITE".equals(string2) || "JDBC_ODBC".equals(string2) || "OTHER_JDBC".equals(string2);
        }
        return bl;
    }

    static DatabaseConnection getConnectionNode(String string, boolean bl) {
        DatabaseConnection databaseConnection = null;
        URL uRL = URLFactory.newURL((String)"sqldev.nav", (String)string);
        try {
            databaseConnection = bl ? (DatabaseConnection)NodeFactory.findOrCreate(DatabaseConnection.class, (URL)uRL) : (DatabaseConnection)NodeFactory.find((URL)uRL);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return databaseConnection;
    }

    protected void closeImpl() throws IOException {
        Connections.getInstance().removeConnectionListener(this);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
        DatabaseConnection databaseConnection;
        String string = connectionEvent.getConnectionName();
        if (Databases.isJDBCConnection(string) && (databaseConnection = Databases.getConnectionNode(string, true)) != null) {
            this.updateOverlaysForNode(databaseConnection);
            this.add((Element)databaseConnection, true);
        }
    }

    private void updateOverlaysForNode(DatabaseConnection databaseConnection) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)databaseConnection);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        DatabaseConnection databaseConnection = Databases.getConnectionNode(string, false);
        if (databaseConnection != null) {
            if (databaseConnection.isOpen()) {
                Context context = Context.newIdeContext((Node)databaseConnection);
                Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.CloseNodeCommand", (Context)context);
                try {
                    CommandProcessor.getInstance().invoke(command);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.remove((Element)databaseConnection, true);
        }
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void markDirty(boolean bl) {
    }
}

