/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import javax.swing.JTree;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.BaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.net.DBURLFileSystemHelper;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.ArrayResourceBundle;

public class DatabaseNavigatorManager
extends BaseNavigatorManager {
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final String DATABASE_NAVIGATOR_WINDOW_ID = "DatabaseNavigatorWindow";
    private static final String DB_NAV_CMD = "DatabaseNavigator.SHOW_NAVIGATOR";
    private static final int DB_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.SHOW_NAVIGATOR");
    private static NavigatorManager s_instance;

    private static String getNavigatorLabel() {
        return DatabaseNavigatorResources.getString(RaptorExtensionConstants.isStandAlone() ? 9 : 10);
    }

    public static synchronized NavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseNavigatorManager();
        }
        return s_instance;
    }

    private DatabaseNavigatorManager() {
        L l = new L();
        Node.addNodeListenerForType(DatabaseConnection.class, (NodeListener)l);
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
        super.configureNavigator(navigatorWindow);
        TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
        JTree jTree = treeExplorer.getJTree();
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)DB_NAV_CMD_ID, (String)AddinManager.getAddinManager().getCommand(DB_NAV_CMD_ID, DB_NAV_CMD), (String)StringUtils.stripMnemonic((String)DatabaseNavigatorManager.getNavigatorLabel()), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorManager.getNavigatorLabel()), (ArrayResourceBundle)RaptorImagesArb.getInstance(), (int)2, null, (boolean)true);
    }

    protected NavigatorWindow createNavigatorWindow() {
        NavigatorWindow navigatorWindow = this.createNavigatorWindow((Folder)Databases.getInstance(), true, RaptorExtensionConstants.isStandAlone() ? 1 : 0);
        return navigatorWindow;
    }

    protected String getDefaultName() {
        return StringUtils.stripMnemonic((String)DatabaseNavigatorManager.getNavigatorLabel());
    }

    protected String getViewCategory() {
        return DATABASE_NAVIGATOR_WINDOW_ID;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)CommonArb.getString(7), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)CommonArb.getInteger(8), (ArrayResourceBundle)RaptorImagesArb.getInstance(), (int)2, null, (boolean)true);
    }

    public void initialize() {
        super.initialize();
        URLFileSystem.registerHelper((String)"sqldev.nav", (URLFileSystemHelper)new DBURLFileSystemHelper());
    }

    private static final class L
    extends NodeListener {
        private L() {
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            this.updateNodeState(nodeEvent);
        }

        private void updateNodeState(NodeEvent nodeEvent) {
            IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
            if (iconOverlayTracker != null) {
                iconOverlayTracker.validateOverlay((Element)nodeEvent.getNode());
                iconOverlayTracker.repaintOverlays();
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.updateNodeState(nodeEvent);
        }
    }
}

