/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.AbstractDatabaseFilter;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.ExceptionDialogRunnable;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.dbtools.raptor.navigator.ObjectFilter;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.ObjectPriv.PermissionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderAdapter;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.ConnectionCanceledException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ConnectionEditor;
import oracle.jdevimpl.cm.dt.impexp.ImportExportWizard;

public class DatabaseNavigatorController
implements Controller {
    private static final String OBJECT_TYPE_KEY = "DBObjectType";
    private static final String DATABASE_KEY = "Database";
    public static final String DB_EDITOR_FACTORY_KEY = "DBEditorFactory";
    private static final String OBJECT_URL = "URL";
    private static final String OBJECT_KEY = "OBJECT";
    public static final String FILTER_CMD = "DatabaseNavigator.FILTER";
    public static final int FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.FILTER");
    public static final String CLEAR_FILTER_CMD = "DatabaseNavigator.CLEAR_FILTER";
    public static final int CLEAR_FILTER_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CLEAR_FILTER");
    public static final String NEW_CONN_CMD = "DatabaseNavigator.NewConnection";
    public static final int NEW_DBCONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewConnection");
    public static final String IMP_CONN_CMD = "DatabaseNavigator.ImportConnections";
    public static final int IMP_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.ImportConnections");
    public static final String EXP_CONN_CMD = "DatabaseNavigator.ExportConnections";
    public static final int EXP_CONN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.ExportConnections");
    public static final String OPEN_CMD = "DatabaseNavigator.CONNECT";
    public static final int OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.CONNECT");
    public static final String CLOSE_CMD = "DatabaseNavigator.DISCONNECT";
    public static final int CLOSE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DISCONNECT");
    public static final String NEW_OBJECT_CMD = "DatabaseNavigator.NewObject";
    public static final int NEW_OJBECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.NewObject");
    public static final String EDIT_OBJECT_CMD = "DatabaseNavigator.EditObject";
    public static final int EDIT_OBJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.EditObject");
    public static final IdeAction ACTION_FILTER = IdeAction.find((String)"DatabaseNavigator.FILTER");
    public static final IdeAction ACTION_CLEAR_FILTER = IdeAction.find((String)"DatabaseNavigator.CLEAR_FILTER");
    public static final IdeAction ACTION_NEW_CONN = IdeAction.find((String)"DatabaseNavigator.NewConnection");
    public static final IdeAction ACTION_IMP_CONN = IdeAction.find((String)"DatabaseNavigator.ImportConnections");
    public static final IdeAction ACTION_EXP_CONN = IdeAction.find((String)"DatabaseNavigator.ExportConnections");
    public static final IdeAction ACTION_CONNECT = IdeAction.get((int)OPEN_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(3)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(3))));
    public static final IdeAction ACTION_DISCONNECT = IdeAction.get((int)CLOSE_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(4)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(4))));
    public static final IdeAction ACTION_NEWOBJECT = IdeAction.get((int)NEW_OJBECT_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(7)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(7))));
    public static final IdeAction ACTION_EDITOBJECT = IdeAction.get((int)EDIT_OBJECT_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(8)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(8))));
    private static Map<String, Database> s_databases = new HashMap<String, Database>();
    private static ContextMenuListener s_listener;
    private static final Set<String> EDITABLE_TYPES;
    private Controller m_parent;

    public static synchronized ContextMenuListener getContextMenuListener() {
        if (s_listener == null) {
            s_listener = new NavigatorMenuListener();
        }
        return s_listener;
    }

    protected DatabaseNavigatorController(Controller controller) {
        this.m_parent = controller;
        IdeAction ideAction = IdeAction.find((int)20);
        if (ideAction != null) {
            ideAction.addController((Controller)this);
        }
    }

    private void attachToAction(int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            ideAction.addController((Controller)this);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (DatabaseNavigatorManager.isDatabaseNavigatorContext(context)) {
            Element element = context.getElement();
            Element[] elementArray = context.getSelection();
            int n = ideAction.getCommandId();
            if (n == 51) {
                bl = true;
                this.refreshNode(context);
            } else if (n == NEW_DBCONN_CMD_ID) {
                DatabaseNavigatorController.runNewConnectionDialog("", 1);
                bl = true;
            } else if (n == IMP_CONN_CMD_ID) {
                ImportExportWizard.invoke((String)"CLASS_DATABASE", (String)"IMPORT");
                bl = true;
            } else if (n == EXP_CONN_CMD_ID) {
                ImportExportWizard.invoke((String)"CLASS_DATABASE", (String)"EXPORT");
                bl = true;
            } else if (n == OPEN_CMD_ID) {
                if (element instanceof DatabaseConnection) {
                    for (Element element2 : elementArray) {
                        DatabaseNavigatorController.connect((DatabaseConnection)element2, context);
                    }
                    bl = true;
                }
            } else if (n == CLOSE_CMD_ID) {
                if (element instanceof DatabaseConnection) {
                    for (Element element3 : elementArray) {
                        DatabaseNavigatorController.disconnect((DatabaseConnection)element3, context);
                    }
                    bl = true;
                }
            } else if (n == 20) {
                if (element instanceof DatabaseConnection) {
                    for (Element element4 : elementArray) {
                        DatabaseNavigatorController.deleteConnection((DatabaseConnection)element4, context);
                    }
                    bl = true;
                }
            } else if (n == 56) {
                if (element instanceof DatabaseConnection) {
                    DatabaseNavigatorController.runNewConnectionDialog(((DatabaseConnection)element).getConnectionName(), 2);
                    bl = true;
                }
            } else if (n == NEW_OJBECT_CMD_ID) {
                bl = this.createObject(ideAction, context);
                if (bl) {
                    this.refreshParent(context);
                }
            } else if (n == EDIT_OBJECT_CMD_ID) {
                bl = this.editObject(ideAction, context);
            } else if (n == CLEAR_FILTER_CMD_ID) {
                AbstractDatabaseFilter abstractDatabaseFilter;
                TNode tNode = ExplorerContext.getFirstTNode((Context)context);
                if (tNode != null && (abstractDatabaseFilter = (AbstractDatabaseFilter)tNode.findChildFilter()) != null) {
                    DBContainerInstance dBContainerInstance = abstractDatabaseFilter.getFolderInstance();
                    dBContainerInstance.clearFilter();
                    DatabaseOverlayClient.updateOverlay(tNode.getData());
                    IdeAction ideAction2 = IdeAction.find((int)51);
                    if (ideAction2 != null) {
                        this.handleEvent(ideAction2, context);
                    }
                }
                bl = true;
            }
        }
        return bl || this.m_parent.handleEvent(ideAction, context);
    }

    private boolean createObject(IdeAction ideAction, final Context context) {
        boolean bl = false;
        String string = (String)ideAction.getValue(OBJECT_TYPE_KEY);
        final Database database = (Database)ideAction.getValue(DATABASE_KEY);
        DBEditorFactory dBEditorFactory = (DBEditorFactory)ideAction.getValue(DB_EDITOR_FACTORY_KEY);
        if (dBEditorFactory != null) {
            DBObjectProviderAdapter dBObjectProviderAdapter = new DBObjectProviderAdapter(){

                public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, SchemaObject[] schemaObjectArray) {
                    ObjectFolder objectFolder = (ObjectFolder)context.getElement();
                    URL uRL = objectFolder.getURL();
                    String string = DBURLFormatHelper.getBaseType(uRL);
                    if (schemaObjectArray != null) {
                        ObjectFilter objectFilter;
                        Object object;
                        String[] stringArray = new String[schemaObjectArray.length];
                        int n = 0;
                        TNode tNode = schemaObjectArray;
                        int n2 = ((SchemaObject[])tNode).length;
                        for (int i = 0; i < n2; ++i) {
                            object = tNode[i];
                            if (!ModelUtil.areEqual((Object)object.getType(), (Object)string)) continue;
                            stringArray[n++] = object.getName();
                        }
                        if (n < stringArray.length) {
                            tNode = stringArray;
                            stringArray = new String[n];
                            System.arraycopy(tNode, 0, stringArray, 0, n);
                        }
                        if ((tNode = ExplorerContext.getFirstTNode((Context)context)) != null && (objectFilter = (ObjectFilter)tNode.findChildFilter()) != null) {
                            DBFolderInstance dBFolderInstance = (DBFolderInstance)objectFilter.getFolderInstance();
                            object = new ArrayList();
                            try {
                                for (DBObjectInstance dBObjectInstance : dBFolderInstance.getChildren(stringArray, true)) {
                                    DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, dBObjectInstance);
                                    if (databaseNode == null) continue;
                                    object.add(databaseNode);
                                }
                            }
                            catch (SQLException sQLException) {
                                ExceptionHandler.handleException(sQLException);
                            }
                            catch (AbortException abortException) {
                                object.clear();
                            }
                            UpdateMessage.fireChildrenAdded((Subject)objectFolder, (Collection)object);
                        }
                    }
                    database.removeProviderListener((DBObjectProviderListener)this);
                }
            };
            database.addProviderListener((DBObjectProviderListener)dBObjectProviderAdapter);
            boolean bl2 = bl = dBEditorFactory.createDBObject(null, (DBObjectProvider)database, string) != null;
            if (!bl) {
                database.removeProviderListener((DBObjectProviderListener)dBObjectProviderAdapter);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean editObject(IdeAction ideAction, final Context context) {
        DatabaseNode databaseNode;
        boolean bl = false;
        Node node = context.getNode();
        if (node instanceof TextNode) {
            Context context2 = Context.newIdeContext((Element)context.getNode());
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            context2.setProject(Ide.getDefaultProject());
            try {
                waitCursor.show(0L);
                EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
            finally {
                waitCursor.hide();
            }
            bl = true;
        } else if (node instanceof DatabaseNode && DatabaseNavigatorController.canEditObject(databaseNode = (DatabaseNode)node)) {
            Database database = (Database)ideAction.getValue(DATABASE_KEY);
            try {
                SchemaObject schemaObject = DatabaseNavigatorController.getSchemaObject(database, databaseNode);
                if (schemaObject == null) {
                    throw new DBException(null, "Cannot load object");
                }
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database);
                SchemaObjectListener schemaObjectListener = new SchemaObjectListener(){

                    public void schemaObjectUpdated(DBObjectChange dBObjectChange) {
                        DatabaseNode databaseNode = (DatabaseNode)context.getElement();
                        UpdateMessage.fireStructureChanged((Subject)databaseNode);
                    }
                };
                schemaObject.addObjectListener(schemaObjectListener);
                bl = dBEditorFactory.editDBObject((oracle.javatools.db.DBObject)schemaObject, (DBObjectProvider)database);
                schemaObject.removeObjectListener(schemaObjectListener);
                if (bl) {
                    this.refreshParent(context);
                }
            }
            catch (DBException dBException) {
                ExceptionHandler.handleException((Exception)((Object)dBException));
            }
        }
        return bl;
    }

    private static SchemaObject getSchemaObject(Database database, DatabaseNode databaseNode) throws DBException {
        String string = (String)databaseNode.getProperty("API_NAME");
        if (string == null) {
            string = (String)databaseNode.getProperty("NAME");
        }
        return database.getObject((String)databaseNode.getProperty("TYPE"), database.getSchema((String)databaseNode.getProperty("SCHEMA")), string);
    }

    private static boolean canEditObject(DatabaseNode databaseNode) {
        SchemaObject schemaObject;
        Database database;
        DBObject dBObject;
        String string = (String)databaseNode.getProperty("TYPE");
        if (EDITABLE_TYPES.contains(string) && PermissionRegistry.canAlter(dBObject = new DBObject(databaseNode)) && (database = DatabaseNavigatorController.getDatabase((String)databaseNode.getProperty("ConnectionName"))) != null && (schemaObject = dBObject.getSchemaObject()) != null) {
            return DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database) != null;
        }
        return false;
    }

    public void refreshParent(Context context) {
        View view;
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        if (tNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            tNode = tNode.getAncestorTNode(ObjectFolder.class, false);
            TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            treeExplorer.refresh(tNode);
        }
    }

    public void refreshNode(Context context) {
        View view;
        TNode tNode = ExplorerContext.getSingleTNode((Context)context);
        if (tNode != null && (view = context.getView()) instanceof NavigatorWindow) {
            TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
            treeExplorer.refresh(tNode);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (DatabaseNavigatorManager.isDatabaseNavigatorContext(context)) {
            Element element = context.getElement();
            int n = ideAction.getCommandId();
            if (n == 51) {
                View view = context.getView();
                TreeExplorer treeExplorer = ((NavigatorWindow)view).getTreeExplorer();
                TNode tNode = ExplorerContext.getSingleTNode((Context)context);
                if (tNode != null) {
                    Element element2 = tNode.getData();
                    boolean bl2 = false;
                    bl2 = element2 instanceof DatabaseNode ? true : treeExplorer.canRefresh(tNode, element2.getClass());
                    ideAction.setEnabled(bl2);
                    bl = true;
                }
            } else if (n == FILTER_CMD_ID) {
                ideAction.setEnabled(this.isFilterable(element));
                bl = true;
            } else if (n == CLEAR_FILTER_CMD_ID) {
                AbstractDatabaseFilter abstractDatabaseFilter;
                TNode tNode = ExplorerContext.getFirstTNode((Context)context);
                if (tNode != null && (abstractDatabaseFilter = (AbstractDatabaseFilter)tNode.findChildFilter()) != null) {
                    DBContainerInstance dBContainerInstance = abstractDatabaseFilter.getFolderInstance();
                    ideAction.setEnabled(dBContainerInstance.isFiltered());
                }
                bl = true;
            } else if (n == OPEN_CMD_ID) {
                ideAction.setEnabled(element instanceof DatabaseConnection && !((DatabaseConnection)element).isOpen());
                bl = true;
            } else if (n == CLOSE_CMD_ID) {
                ideAction.setEnabled(element instanceof DatabaseConnection && ((DatabaseConnection)element).isOpen());
                bl = true;
            } else if (n == 20) {
                ideAction.setEnabled(element instanceof DatabaseConnection);
                bl = true;
            } else if (n == 56) {
                ideAction.setEnabled(element instanceof DatabaseConnection);
                bl = true;
            } else if (n == NEW_OJBECT_CMD_ID) {
                boolean bl3 = false;
                if (element instanceof ObjectFolder && PermissionRegistry.canCreate(new DBObject(element))) {
                    String string = (String)ideAction.getValue(OBJECT_TYPE_KEY);
                    Database database = (Database)ideAction.getValue(DATABASE_KEY);
                    DBEditorFactory dBEditorFactory = (DBEditorFactory)ideAction.getValue(DB_EDITOR_FACTORY_KEY);
                    bl3 = dBEditorFactory != null && dBEditorFactory.canCreateDBObject(null, (DBObjectProvider)database, string);
                }
                ideAction.setEnabled(bl3);
                bl = true;
            } else if (n == EDIT_OBJECT_CMD_ID) {
                if (element instanceof TextNode) {
                    ideAction.setEnabled(true);
                } else if (element instanceof DatabaseNode) {
                    ideAction.setEnabled(DatabaseNavigatorController.canEditObject((DatabaseNode)element));
                }
                bl = true;
            } else if (n == EXP_CONN_CMD_ID) {
                int n2 = 0;
                try {
                    n2 = Connections.getInstance().getCm().getConnectionNames().length;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (n2 < 1) {
                    ideAction.setEnabled(false);
                } else {
                    ideAction.setEnabled(true);
                }
            }
        }
        return bl || this.m_parent.update(ideAction, context);
    }

    private boolean isFilterable(Element element) {
        return element instanceof ObjectFolder || element instanceof OtherSchemasFolder;
    }

    private static void connect(final DatabaseConnection databaseConnection, Context context) {
        try {
            Connection connection = databaseConnection.getConnection();
            TNode[] tNodeArray = ExplorerContext.getTNodes((Context)context);
            if (tNodeArray.length == 1) {
                TNode tNode = tNodeArray[0];
                TreeExplorer treeExplorer = tNode.getOwner();
                treeExplorer.expand(tNode, false);
            }
        }
        catch (IOException iOException) {
            Throwable throwable = iOException;
            if (iOException instanceof AbstractConnectionNode.ExceptionWrapper) {
                throwable = iOException.getCause();
            }
            if (!(throwable instanceof ConnectionCanceledException)) {
                ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable("Could not connect: {0}", throwable);
                if (SwingUtilities.isEventDispatchThread()) {
                    exceptionDialogRunnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(exceptionDialogRunnable);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        databaseConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private static boolean disconnect(DatabaseConnection databaseConnection, Context context) {
        assert (databaseConnection != null);
        boolean bl = false;
        if (context == null) {
            context = Context.newIdeContext((Node)databaseConnection);
        }
        Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.CloseNodeCommand", (Context)context);
        try {
            CommandProcessor.getInstance().invoke(command);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static void deleteConnection(DatabaseConnection databaseConnection, Context context) {
        assert (databaseConnection != null);
        String string = databaseConnection.getConnectionName();
        String string2 = DatabaseNavigatorResources.format(5, string);
        if (MessageDialog.confirm(null, (Object)string2, (String)DatabaseNavigatorResources.getString(6), null, (boolean)true)) {
            List list = EditorManager.getEditorManager().getAllEditors();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object : list) {
                if (object.getContext().getNode() instanceof IViewerNode) {
                    arrayList.add(object);
                    continue;
                }
                if (!(object.getContext().getNode() instanceof PlSqlNode) || object.getContext().getNode().getURL().getProtocol().equals("file")) continue;
                arrayList.add(object);
            }
            EditorManager.getEditorManager().closeEditors(arrayList);
            boolean bl = true;
            for (Editor editor : arrayList) {
                if (!editor.isVisible()) continue;
                bl = false;
            }
            if (bl && DatabaseNavigatorController.disconnect(databaseConnection, context)) {
                try {
                    ConnectionManager.getInstance().removeConnectionDescriptor(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static void runNewConnectionDialog(String string, int n) {
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        String[] stringArray = null;
        try {
            stringArray = connectionManager.getConnectionTypeNamesForClass("CLASS_DATABASE");
        }
        catch (IOException iOException) {
            stringArray = null;
        }
        ConnectionExpander connectionExpander = new ConnectionExpander();
        connectionManager.addConnectionListener((ConnectionListener)connectionExpander);
        ConnectionEditor connectionEditor = new ConnectionEditor((Frame)Ide.getMainWindow());
        if (connectionEditor.runConnectionEditor(string, n, stringArray)) {
            connectionExpander.selectConnection();
        }
        connectionManager.removeConnectionListener((ConnectionListener)connectionExpander);
        connectionEditor = null;
    }

    private static Database getDatabase(String string) {
        Database database = s_databases.get(string);
        if (database == null) {
            try {
                database = Connections.getInstance().getDatabase(string);
                s_databases.put(string, database);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return database;
    }

    static {
        EDITABLE_TYPES = new HashSet<String>();
        ObjectActionController.addListener(new NavActionListener(DatabaseNavigatorManager.getInstance()));
        Connections.getInstance().addConnectionListener(new ConnectionAdapter());
        EDITABLE_TYPES.add("TABLE");
        EDITABLE_TYPES.add("VIEW");
        EDITABLE_TYPES.add("INDEX");
        EDITABLE_TYPES.add("SEQUENCE");
        EDITABLE_TYPES.add("MATERIALIZED VIEW");
        EDITABLE_TYPES.add("MATERIALIZED VIEW LOG");
        EDITABLE_TYPES.add("DATABASE LINK");
        EDITABLE_TYPES.add("SYNONYM");
    }

    private static class SchemaObjectWrapper {
        private URL m_url;
        private SchemaObject m_so;

        SchemaObjectWrapper(URL uRL, SchemaObject schemaObject) {
            this.m_url = uRL;
            this.m_so = schemaObject;
        }

        public URL getURL() {
            return this.m_url;
        }

        public SchemaObject getSchemaObject() {
            return this.m_so;
        }

        public int hashCode() {
            return this.m_url.hashCode();
        }

        public String toString() {
            return this.m_url.toString();
        }

        public boolean equals(Object object) {
            return object == this || object instanceof SchemaObjectWrapper && ModelUtil.areEqual((Object)this.m_url, (Object)((SchemaObjectWrapper)object).m_url);
        }
    }

    private static class ConnectionExpander
    implements ConnectionListener {
        private String _cName;

        private ConnectionExpander() {
        }

        public void connectionAdded(oracle.jdeveloper.cm.ConnectionEvent connectionEvent) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
            if (connectionDescriptor != null) {
                this._cName = connectionDescriptor.getConnectionName();
            }
        }

        public void connectionClosed(oracle.jdeveloper.cm.ConnectionEvent connectionEvent) {
        }

        public void connectionModified(oracle.jdeveloper.cm.ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(oracle.jdeveloper.cm.ConnectionEvent connectionEvent) {
        }

        public void connectionRemoved(oracle.jdeveloper.cm.ConnectionEvent connectionEvent) {
        }

        private void selectConnection() {
            NavigatorWindow navigatorWindow;
            NavigatorManager navigatorManager;
            if (this._cName == null || (navigatorManager = NavigatorManager.getConnectionNavigatorManager()) == null || (navigatorWindow = navigatorManager.getNavigatorWindow()) != null) {
                // empty if block
            }
        }
    }

    private static class ConnectionAdapter
    implements oracle.dbtools.raptor.connections.ConnectionListener {
        private ConnectionAdapter() {
        }

        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DatabaseConnection databaseConnection = Databases.getConnectionNode(string, true);
            if (databaseConnection != null) {
                databaseConnection.ensureOpen();
            }
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            DatabaseConnection databaseConnection;
            String string = connectionEvent.getConnectionName();
            Database database = (Database)s_databases.remove(string);
            if (database != null) {
                database.close();
            }
            if ((databaseConnection = Databases.getConnectionNode(string, false)) != null && databaseConnection.isOpen()) {
                DatabaseNavigatorController.disconnect(databaseConnection, null);
            }
        }
    }

    private static class NavigatorMenuListener
    implements ContextMenuListener {
        private JMenuItem m_NewConn;
        private JMenuItem m_import;
        private JMenuItem m_export;
        private JMenuItem m_connect;
        private JMenuItem m_disconnect;
        private JMenuItem m_delete;
        private JMenuItem m_editConnection;
        private JMenuItem m_refresh;
        private JMenuItem m_filter;
        private JMenuItem m_clearFilter;
        private JMenuItem m_newObject;
        private JMenuItem m_editObject;

        private NavigatorMenuListener() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            if (DatabaseNavigatorManager.isDatabaseNavigatorContext(context)) {
                contextMenu.remove((Component)NavigatorConstants.New);
                Element[] elementArray = context.getSelection();
                boolean bl = elementArray.length > 1;
                Element element = elementArray[0];
                this.buildMenus((MenuManager)contextMenu);
                if (element instanceof Databases) {
                    contextMenu.add((Component)this.m_NewConn, 1.0f);
                    contextMenu.add((Component)this.m_import, 1.0f);
                    contextMenu.add((Component)this.m_export, 1.0f);
                } else if (!bl && element instanceof DatabaseConnection) {
                    contextMenu.add((Component)this.m_connect, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
                    contextMenu.add((Component)this.m_disconnect, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
                    contextMenu.add((Component)this.m_delete, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
                    contextMenu.add((Component)this.m_editConnection, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                } else if (!bl && element instanceof ObjectFolder) {
                    DBEditorFactory dBEditorFactory;
                    AbstractButton abstractButton = null;
                    ObjectFolder objectFolder = (ObjectFolder)element;
                    DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
                    String string = dBFolderInstance.getType();
                    Database database = DatabaseNavigatorController.getDatabase(objectFolder.getConnectionName());
                    if (database != null && (dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string)) != null) {
                        String string2 = dBEditorFactory.getCreateLabel(string);
                        abstractButton = this.m_newObject;
                        Action action = abstractButton.getAction();
                        action.putValue("Name", StringUtils.stripMnemonic((String)string2));
                        action.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
                        action.putValue("SmallIcon", DBUtil.getNodeIcon((String)string));
                        action.putValue(DatabaseNavigatorController.OBJECT_TYPE_KEY, string);
                        action.putValue(DatabaseNavigatorController.DATABASE_KEY, database);
                        action.putValue(DatabaseNavigatorController.DB_EDITOR_FACTORY_KEY, dBEditorFactory);
                    }
                    if (abstractButton != null) {
                        contextMenu.add(abstractButton, 1.0f);
                        ((IdeAction)abstractButton.getAction()).updateAction(contextMenu.getContext());
                    }
                    contextMenu.add((Component)this.m_refresh, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                    contextMenu.add((Component)this.m_filter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                    contextMenu.add((Component)this.m_clearFilter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                } else if (element instanceof OtherSchemasFolder) {
                    contextMenu.add((Component)this.m_refresh, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                    contextMenu.add((Component)this.m_filter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                    contextMenu.add((Component)this.m_clearFilter, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
                } else {
                    JMenuItem jMenuItem = null;
                    if (!bl && element instanceof TextNode) {
                        jMenuItem = this.m_editObject;
                    } else if (!bl && element instanceof DatabaseNode) {
                        DatabaseNode databaseNode = (DatabaseNode)element;
                        String string = (String)databaseNode.getProperty("ConnectionName");
                        String string3 = (String)databaseNode.getProperty("TYPE");
                        Database database = DatabaseNavigatorController.getDatabase(string);
                        if (database != null && DatabaseNavigatorController.canEditObject(databaseNode)) {
                            jMenuItem = this.m_editObject;
                            Action action = jMenuItem.getAction();
                            action.putValue(DatabaseNavigatorController.OBJECT_TYPE_KEY, string3);
                            action.putValue(DatabaseNavigatorController.DATABASE_KEY, database);
                            action.putValue(DatabaseNavigatorController.OBJECT_URL, databaseNode.getURL());
                        }
                    }
                    if (jMenuItem != null) {
                        contextMenu.add((Component)jMenuItem, element instanceof TextNode ? 1.0f : JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                    }
                }
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            Element element;
            boolean bl = false;
            NavigationPoint navigationPoint = null;
            if (DatabaseNavigatorManager.isDatabaseNavigatorContext(context)) {
                TNode tNode;
                element = context.getElement();
                if (element instanceof ChildObjectElement) {
                    RunnableSourceNode runnableSourceNode;
                    tNode = ExplorerContext.getSingleTNode((Context)context);
                    if (tNode != null && (runnableSourceNode = (RunnableSourceNode)tNode.getAncestor(RunnableSourceNode.class, true)) != null) {
                        navigationPoint = runnableSourceNode.getNavigationPoint((ChildObjectElement)element);
                    }
                    bl = true;
                } else if (element instanceof DatabaseSourceNode) {
                    tNode = ExplorerContext.getFirstTNode((Context)context);
                    TreeExplorer treeExplorer = tNode.getOwner();
                    treeExplorer.expand(tNode, false);
                    bl = false;
                }
            }
            if (navigationPoint != null) {
                element = NavigationManager.getNavigationManager();
                try {
                    if (element != null) {
                        element.navigateTo(navigationPoint);
                    } else {
                        navigationPoint.navigate();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return bl;
        }

        private void buildMenus(MenuManager menuManager) {
            if (this.m_NewConn == null) {
                this.m_NewConn = menuManager.createMenuItem((ToggleAction)ACTION_NEW_CONN);
                this.m_import = menuManager.createMenuItem((ToggleAction)ACTION_IMP_CONN);
                this.m_export = menuManager.createMenuItem((ToggleAction)ACTION_EXP_CONN);
                this.m_connect = menuManager.createMenuItem((ToggleAction)ACTION_CONNECT);
                this.m_disconnect = menuManager.createMenuItem((ToggleAction)ACTION_DISCONNECT);
                this.m_refresh = this.createMenu(menuManager, 51);
                this.m_delete = this.createMenu(menuManager, 20);
                this.m_editConnection = this.createMenu(menuManager, 56);
                this.m_filter = menuManager.createMenuItem((ToggleAction)ACTION_FILTER);
                this.m_clearFilter = menuManager.createMenuItem((ToggleAction)ACTION_CLEAR_FILTER);
                this.m_newObject = menuManager.createMenuItem((ToggleAction)ACTION_NEWOBJECT);
                this.m_editObject = menuManager.createMenuItem((ToggleAction)ACTION_EDITOBJECT);
            }
        }

        private JMenuItem createMenu(MenuManager menuManager, int n) {
            IdeAction ideAction = IdeAction.find((int)n);
            return ideAction != null ? menuManager.createMenuItem((ToggleAction)ideAction) : null;
        }
    }
}

