/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public final class DatabaseConnection
extends AbstractConnectionNode
implements DatabaseNode {
    private Icon m_icon;

    public DatabaseConnection() {
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.CLOSEABLE | ElementAttributes.NAVIGABLE);
    }

    public DatabaseConnection(String string) {
        this();
        this.setURL(URLFactory.newURL((String)"sqldev.nav", (String)string));
    }

    protected void closeConnection() {
        Connections.getInstance().closeConnection(this.getConnectionName());
    }

    protected Connection openConnection() throws IOException {
        try {
            return Connections.getInstance().getConnection(this.getConnectionName());
        }
        catch (CMException cMException) {
            throw new AbstractConnectionNode.ExceptionWrapper(cMException);
        }
        catch (RuntimeException runtimeException) {
            throw new AbstractConnectionNode.ExceptionWrapper(runtimeException);
        }
    }

    public String getConnectionName() {
        return URLFileSystem.getPath((URL)this.getURL());
    }

    public String getShortLabel() {
        return super.getShortLabel();
    }

    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = DatabaseConnection.loadIcon(this.getConnectionName());
        }
        return this.m_icon;
    }

    public static Icon loadIcon(String string) {
        ConnectionType connectionType;
        String string2;
        Icon icon = null;
        ConnectionDescriptor connectionDescriptor = Connections.getInstance().getConnectionInfo(string);
        if (connectionDescriptor != null && (string2 = (String)connectionDescriptor.get((Object)"RaptorConnectionType")) != null && (connectionType = NavigatorHook.getConnectionType(string2)) != null) {
            icon = connectionType.getIcon();
        }
        if (icon == null) {
            icon = RaptorImage.getIcon("db.png");
        }
        return icon;
    }

    public String getToolTipText() {
        ConnectionDescriptor connectionDescriptor = Connections.getInstance().getConnectionInfo(this.getConnectionName());
        boolean bl = Connections.getInstance().isConnectionOpen(this.getConnectionName());
        String string = this.getConnectionName() + " " + (bl ? "Connected" : "");
        return string;
    }

    public String getLongLabel() {
        return super.getToolTipText();
    }
}

