/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdeveloper.cm.CMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLComboxModel
extends DefaultComboBoxModel {
    private String _connName = null;
    private Connection _conn = null;
    private ConnectionTypeDetails _connTypeDetails;
    private String _sql = null;
    private ArrayList _binds = null;
    private Map<String, Object> _namedBinds = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean _delayLoad = false;
    private boolean _loaded = false;
    private String _defaultObject;

    public SQLComboxModel(Connection connection, String string, ArrayList arrayList, String string2) {
        this._conn = connection;
        this._sql = string;
        this._binds = arrayList;
        this.setDefaultObject(string2);
        this._connName = Connections.getInstance().getConnectioName(this._conn);
        this.setConnectionTypeDetails();
    }

    public SQLComboxModel(String string, String string2, ArrayList arrayList, String string3) {
        this._connName = string;
        try {
            this._conn = Connections.getInstance().getConnection(this._connName);
        }
        catch (CMException cMException) {
            this.logger.severe("Could not get connection:" + cMException.getMessage());
        }
        this.setConnectionTypeDetails();
        this._sql = string2;
        this._binds = arrayList;
        this.setDefaultObject(string3);
    }

    public SQLComboxModel(String string, String string2, Map<String, Object> map, String string3) {
        this._connName = string;
        try {
            this._conn = Connections.getInstance().getConnection(this._connName);
        }
        catch (CMException cMException) {
            this.logger.severe("Could not get connection:" + cMException.getMessage());
        }
        this.setConnectionTypeDetails();
        this._sql = string2;
        this._namedBinds = map;
        this.setDefaultObject(string3);
    }

    private void setConnectionTypeDetails() {
        ObjectFactory objectFactory = ObjectFactory.getFactory(this._connName, this._conn);
        this._connTypeDetails = objectFactory.getConnectionTypeDescriptor().getImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!this._loaded) {
            ResultSet resultSet = null;
            resultSet = this._namedBinds == null ? DBUtil.getInstance().executeQuery(this._conn, this._sql, (List)this._binds) : DBUtil.getInstance().executeQuery(this._conn, this._sql, this._namedBinds);
            try {
                int n = 500;
                if (this._connTypeDetails != null) {
                    n = this._connTypeDetails.getPreferredFetchSize();
                }
                try {
                    resultSet.setFetchSize(n);
                }
                catch (SQLWarning sQLWarning) {
                    this.logger.warning("Setting fetch size yielded a warning, ignore");
                }
                while (resultSet != null && resultSet.next()) {
                    String string = resultSet.getString(1);
                    if (this._defaultObject != null && resultSet.getString(1).equals(this._defaultObject)) continue;
                    this.addElement(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                this.logger.severe("Could not get connection:" + sQLException.getMessage());
            }
            finally {
                try {
                    if (resultSet.getStatement() != null && resultSet != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            this._loaded = true;
        }
    }

    @Override
    public int getSize() {
        if (!this._delayLoad) {
            this.load();
        }
        return !this._loaded ? 20 : super.getSize();
    }

    @Override
    public Object getElementAt(int n) {
        if (!this._delayLoad) {
            this.load();
        }
        return !this._loaded ? "" : super.getElementAt(n);
    }

    public void setDelayed(boolean bl) {
        this._delayLoad = bl;
    }

    public void setDefaultObject(String string) {
        if (string != null) {
            this._defaultObject = string;
            this.addElement(this._defaultObject);
            this.setSelectedItem(this._defaultObject);
        }
    }

    public String getDefaultObject() {
        return this._defaultObject;
    }
}

