/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.Database;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.sql.ROWID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected final Object LOCK = new Object();
    private static final String[] LINK_COLS = new String[]{"SDEV_LINK_OWNER", "SDEV_LINK_NAME", "SDEV_LINK_TYPE"};
    protected volatile ProgressRunnable _runner;
    protected String _sql;
    protected ResultSet _rs;
    private PreparedStatement _stmt;
    private Query _query = null;
    protected List<String> _colNames;
    protected Map<String, Integer> _colNameOccurance;
    protected List _rows;
    protected boolean _allFetched;
    protected List _bindList = null;
    protected Map _bindMap = null;
    protected DBUtil _dbUtil = new DBUtil();
    private int[] _colSizes;
    private int[] _types;
    private JLabel _label = new JLabel("");
    private boolean _runInThread = true;
    private boolean _translatedColNames = true;
    private boolean _verticalDisplay = false;
    private static final int FETCH_SIZE = 50;
    private final List<String> _skipCols = new ArrayList<String>();
    private String _whereClause;
    private String _orderByClause;
    private boolean _isRunning;
    private final List<URL> _drillUrls = new ArrayList<URL>();
    private Connection m_conn;
    protected String _schemaName;
    protected boolean _isExternalTable = false;
    protected String _tablename;
    public static final String SORT_A = " asc";
    public static final String SORT_D = " desc";
    private int _line = -1;
    private int _col = -1;
    private boolean _isOracle;
    private Statement stmt = null;
    private int _sortCol;
    private String _sortDir;
    private DBObject _dbObject;
    private static final int MAX_RS_FETCHSIZE = 1000;

    public void cancelStmt() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public ResultSetTableModel() {
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, String string, List list) {
        this.setBindList(list);
        this.setBindMap(null);
        this.init(connection, resultSet, string);
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, Query query) {
        this(connection, resultSet, query.getSql(), query.getBindValues());
        this._query = query;
        this.setSkipCols(query.getSkipCols());
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, String string, Map map) {
        this.setBindMap(map);
        this.setBindList(null);
        this.init(connection, resultSet, string);
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, String string) {
        this.init(connection, resultSet, string);
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, String string, Database database) {
        this.init(connection, resultSet, string);
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, String string, Database database, DBObject dBObject) {
        this._dbObject = dBObject;
        this.init(connection, resultSet, string);
    }

    public DBObject getDBObject() {
        return this._dbObject;
    }

    public void init(Connection connection, ResultSet resultSet, String string) {
        this.m_conn = connection;
        for (String string2 : LINK_COLS) {
            this._skipCols.add(string2);
        }
        this.setConn(connection);
        this.setSql(string);
        if (resultSet != null) {
            this._rs = resultSet;
            try {
                this._stmt = (PreparedStatement)resultSet.getStatement();
                this._stmt.setEscapeProcessing(false);
            }
            catch (SQLException sQLException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExternalTable(String string) {
        String string2 = "SELECT OWNER,TABLE_NAME FROM all_external_tables";
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            resultSet = DBUtil.getInstance().executeQuery(this.getConnName(), string2, (Map)null);
            while (resultSet.next()) {
                String string3 = resultSet.getString(1) + "." + resultSet.getString(2);
                arrayList.add(string3);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                statement = resultSet.getStatement();
                resultSet.close();
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return arrayList.contains(string);
    }

    public String getSQL() {
        if (this._sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this._sql);
        if (this._whereClause != null && this._whereClause.trim().length() > 0) {
            if (this._whereClause.trim().toLowerCase().indexOf("where") != 0) {
                stringBuilder.append(" where ");
            }
            stringBuilder.append(this._whereClause);
        }
        if (this._orderByClause != null && this._orderByClause.trim().length() > 0) {
            if (this._orderByClause.trim().toLowerCase().indexOf("order by") != 0) {
                stringBuilder.append(" order by  ");
            }
            stringBuilder.append(this._orderByClause);
        }
        if (this._sortCol > 0) {
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append(this.getSortCol());
            stringBuilder.append(this.getSortDirection());
        }
        return ResultSetTableModel._sanitizeOracleSQL(stringBuilder.toString());
    }

    private ResultSet openResultSetWithMessageFormatter() throws SQLException {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        String string = DBUtil.getInstance().prepareNonOracleSql(this.m_conn, this.getSQL(), this.getBindMap());
        this.stmt = this.getConnection().createStatement();
        return this.stmt.executeQuery(string);
    }

    public ResultSet openResultSet() throws SQLException {
        Log.log("Opening:" + this.getSql());
        Connections connections = Connections.getInstance();
        if (connections.isOracle(this.getConnName())) {
            this.stmt = this.getConnection().prepareStatement(this.getSQL());
        } else {
            if (this.getSql().contains("{:")) {
                return this.openResultSetWithMessageFormatter();
            }
            ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.getSQL(), true);
            ArrayList arrayList2 = new ArrayList();
            String string = this.getSQL();
            for (Bind bind : arrayList) {
                arrayList2.add(this.getBindMap().get(bind.getName()));
                string = string.replaceFirst(":" + bind.getName(), "?");
            }
            this._bindList = arrayList2;
            Connection connection = this.getConnection();
            this.stmt = connection.prepareStatement(string);
            if (connections.isTimesTen(connection)) {
                connection.commit();
            }
        }
        if (Connections.getInstance().isOracle(this.getConnName())) {
            this.stmt.setEscapeProcessing(false);
        }
        if (this.getBindList() != null) {
            this._dbUtil.bind((PreparedStatement)this.stmt, this.getBindList());
        } else if (this.getBindMap() != null) {
            this._dbUtil.bind(this.getSql(), (PreparedStatement)this.stmt, this.getBindMap());
        }
        return ((PreparedStatement)this.stmt).executeQuery();
    }

    public boolean open() {
        return this.open(this._getFetchSize());
    }

    public boolean open(int n) {
        this._allFetched = false;
        this._isOracle = this.m_conn != null && Connections.getInstance().isOracle(this.m_conn);
        this._drillUrls.clear();
        this._fetchNext(n);
        return true;
    }

    public void setIsOracle(boolean bl) {
        this._isOracle = bl;
    }

    public boolean isOracle() {
        return Connections.getInstance().isOracle(this.getConnName());
    }

    public boolean isTimesTen() {
        return Connections.getInstance().isTimesTen(this.getConnName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanup() {
        Object object = this.LOCK;
        synchronized (object) {
            this._rows = null;
            this._allFetched = false;
            try {
                if (this._rs != null) {
                    this._rs.close();
                }
                this._rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean close() {
        if (this._rs != null) {
            try {
                Statement statement = this._rs.getStatement();
                this._cleanup();
                if (statement != null) {
                    statement.close();
                }
                this._stmt = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public void fetchAll() {
        if (this._allFetched) {
            Log.status(Translate.translate("All_Rows_Fetched"));
            return;
        }
        this._fetchNext(Integer.MAX_VALUE);
    }

    String rawToHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = n2 >>> 4;
            stringBuffer.append(this.nibbletochar(n3));
            int n4 = n2 & 0xF;
            stringBuffer.append(this.nibbletochar(n4));
        }
        return stringBuffer.toString();
    }

    char nibbletochar(int n) {
        int n2 = 48;
        if (n < 10) {
            n2 = (char)(48 + n);
        } else if (n == 10) {
            n2 = 65;
        } else if (n == 11) {
            n2 = 66;
        } else if (n == 12) {
            n2 = 67;
        } else if (n == 13) {
            n2 = 68;
        } else if (n == 14) {
            n2 = 69;
        } else if (n == 15) {
            n2 = 70;
        }
        return (char)n2;
    }

    public int getLoadedCount() {
        int n = 0;
        if (this._rows != null) {
            n = this._rows.size();
        }
        return n;
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this._rows != null) {
            n = this._rows.size();
            if (!this._allFetched) {
                n += this._getFetchSize() + 1;
            }
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        int n = this._colNames != null ? this._colNames.size() : 0;
        return n + 1;
    }

    public String getRawColumnName(int n) {
        return this._colNames.get(n);
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return ConnectionArb.getString((int)179);
        }
        if (!this._translatedColNames) {
            return this._colNames.get(n - 1);
        }
        return this._colNames != null ? Translate.translate(this._colNames.get(n - 1)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (this._rows != null) {
            boolean bl = false;
            Object object = this.LOCK;
            synchronized (object) {
                if (n >= this._rows.size() && !this._isRunning) {
                    bl = true;
                }
            }
            if (bl) {
                this._fetchNext(n - (this._rows.size() - 1));
            }
            if (n < this._rows.size()) {
                if (n2 == 0) {
                    return new Integer(n + 1);
                }
                object = (List)this._rows.get(n);
                if (object != null && object.size() > n2 - 1) {
                    return object.get(n2 - 1);
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        Object object = this.getValueAt(0, n);
        return object != null ? object.getClass() : Object.class;
    }

    protected static String _sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this._colNames = new ArrayList<String>();
        this._colNameOccurance = new HashMap<String, Integer>();
        if (this._verticalDisplay) {
            this._types = new int[2];
            this._colSizes = new int[2];
            this._colNames.add(Translate.translate("Name"));
            this._colNames.add(Translate.translate("Value"));
            this._colSizes[0] = 30;
            this._colSizes[1] = 60;
            this._types[0] = 12;
            this._types[1] = 12;
        } else {
            int n2 = 0;
            int n3 = 0;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n4 = 0;
            boolean bl = false;
            for (int i = 1; i <= n; ++i) {
                bl = false;
                for (int j = 0; this._skipCols != null && j < this._skipCols.size(); ++j) {
                    if (!this._skipCols.get(j).toUpperCase().equals(resultSetMetaData.getColumnName(i).toUpperCase())) continue;
                    bl = true;
                }
                if (bl) continue;
                String string = this.getUniqueColumnName(resultSetMetaData.getColumnLabel(i));
                this._colNames.add(string);
                this._label.setText(string);
                n2 = new Double(this._label.getPreferredSize().getWidth()).intValue();
                n3 = resultSetMetaData.getColumnDisplaySize(i);
                nArray2[n4] = n2 > n3 ? n2 : n3;
                nArray[n4] = resultSetMetaData.getColumnType(i);
                ++n4;
            }
            this._types = nArray;
            this._colSizes = nArray2;
        }
    }

    private String getUniqueColumnName(String string) {
        if (this._colNames.contains(string)) {
            this._colNameOccurance.put(string, this._colNameOccurance.get(string) + 1);
            return string + "_" + (this._colNameOccurance.get(string) - 1);
        }
        this._colNameOccurance.put(string, 1);
        return string;
    }

    public void reorderColumnNamesList(int n, int n2) throws Exception {
        if (!this._verticalDisplay) {
            if (this._types != null) {
                this.reorderArray(this._types, n, n2);
            }
            if (this._colSizes != null) {
                this.reorderArray(this._colSizes, n, n2);
            }
            if (this._colNames != null) {
                String string = this._colNames.get(n);
                this._colNames.remove(n);
                this._colNames.add(n2, string);
            }
        }
    }

    private void reorderArray(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        if (n > n2) {
            System.arraycopy(nArray, n2, nArray, n2 + 1, n - n2);
        } else {
            System.arraycopy(nArray, n + 1, nArray, n, n2 - n);
        }
        nArray[n2] = n3;
    }

    protected void _setColWidths() {
        this.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _fetchNext(int n) {
        if (this._allFetched) {
            return;
        }
        final int n2 = this._getFetchSize();
        if (this._rows == null) {
            this._rows = new ArrayList();
        }
        final List list = this._rows;
        final int n3 = Math.max(n2, n);
        final ArrayList arrayList = new ArrayList(n2);
        this._runner = new ProgressRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object doWork() throws Exception {
                ResultSetTableModel.this.setRunning(true);
                int n = n3;
                ArrayList<String> arrayList2 = null;
                Object object = ResultSetTableModel.this.LOCK;
                synchronized (object) {
                    Object object2;
                    try {
                        if (!Connections.getInstance().lock(ResultSetTableModel.this.getConnection())) {
                            Object var4_4 = null;
                            return var4_4;
                        }
                        if (ResultSetTableModel.this._rs == null) {
                            ResultSetTableModel.this._rs = ResultSetTableModel.this.openResultSet();
                        }
                        if (ResultSetTableModel.this._colNames == null) {
                            ResultSetTableModel.this._createColumnNamesList();
                        }
                        while (n > 0 && ResultSetTableModel.this._rs.next()) {
                            String string;
                            int n22;
                            if (ResultSetTableModel.this._verticalDisplay) {
                                for (n22 = 1; n22 <= ResultSetTableModel.this._rs.getMetaData().getColumnCount(); ++n22) {
                                    arrayList2 = new ArrayList();
                                    arrayList2.add(ResultSetTableModel.this._rs.getMetaData().getColumnName(n22));
                                    this.cacheObjectInARow(arrayList2, n22, ResultSetTableModel.this._rs);
                                    arrayList.add(arrayList2);
                                }
                                continue;
                            }
                            arrayList2 = new ArrayList<String>();
                            for (int i = 1; i <= ResultSetTableModel.this._rs.getMetaData().getColumnCount(); ++i) {
                                n22 = 0;
                                for (int j = 0; n22 == 0 && ResultSetTableModel.this._skipCols != null && j < ResultSetTableModel.this._skipCols.size(); ++j) {
                                    string = ((String)ResultSetTableModel.this._skipCols.get(j)).toUpperCase();
                                    String string2 = ResultSetTableModel.this._rs.getMetaData().getColumnName(i).toUpperCase();
                                    if (!((String)ResultSetTableModel.this._skipCols.get(j)).toUpperCase().equals(ResultSetTableModel.this._rs.getMetaData().getColumnName(i).toUpperCase())) continue;
                                    n22 = 1;
                                }
                                if (n22 != 0) continue;
                                this.cacheObjectInARow(arrayList2, i, ResultSetTableModel.this._rs);
                            }
                            try {
                                object2 = ResultSetTableModel.this._rs.getString("SDEV_LINK_NAME");
                                String string3 = ResultSetTableModel.this._rs.getString("SDEV_LINK_OWNER");
                                string = ResultSetTableModel.this._rs.getString("SDEV_LINK_TYPE");
                                if (string.equals("PACKAGE BODY")) {
                                    string = "PACKAGE+BODY";
                                }
                                ResultSetTableModel.this._drillUrls.add(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", ResultSetTableModel.this.getConnName(), null, string3, string), (String)object2));
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            Log.status(Translate.translate("Fetched Rows:") + (ResultSetTableModel.this.getLoadedCount() + arrayList.size()));
                            arrayList.add(arrayList2);
                            if (--n % 100 != 0) continue;
                            Thread.sleep(1L);
                        }
                    }
                    catch (SQLException sQLException) {
                        object2 = sQLException;
                        SwingUtilities.invokeLater(new Runnable((SQLException)object2){
                            final /* synthetic */ SQLException val$sqlException;
                            {
                                this.val$sqlException = sQLException;
                            }

                            public void run() {
                                if (ResultSetTableModel.this._isOracle) {
                                    int n = DBUtil.getInstance().getErrorOffset(ResultSetTableModel.this.getConnection(), ResultSetTableModel.this._sql);
                                    ExceptionHandler.handleException(this.val$sqlException, ResultSetTableModel.this._sql, n, ResultSetTableModel.this._line, ResultSetTableModel.this._col);
                                } else {
                                    ExceptionHandler.handleException(this.val$sqlException);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        Connections.getInstance().unlock(ResultSetTableModel.this.getConnection());
                    }
                    List list2 = arrayList;
                    int n32 = list2.size();
                    if (n32 > 0) {
                        list.addAll(list2);
                    }
                    if (n32 < n2 || ResultSetTableModel.this._allFetched) {
                        ResultSetTableModel.this._allFetched = true;
                        Log.status(Translate.translate("All Rows Fetched: ") + ResultSetTableModel.this.getLoadedCount());
                    } else {
                        Log.status(Translate.translate("Fetched Rows: ") + ResultSetTableModel.this.getLoadedCount());
                    }
                }
                ResultSetTableModel.this.setRunning(false);
                ResultSetTableModel.this.fireTableDataChanged();
                return null;
            }

            private void cacheObjectInARow(List list2, int n, ResultSet resultSet) throws SQLException {
                Object object = null;
                try {
                    object = resultSet instanceof OracleResultSet ? ((OracleResultSet)resultSet).getOracleObject(n) : resultSet.getObject(n);
                }
                catch (SQLException sQLException) {
                    object = resultSet.getObject(n);
                }
                if (object instanceof byte[]) {
                    list2.add(ResultSetTableModel.this.rawToHex((byte[])object));
                } else if (resultSet.getMetaData().getColumnType(n) == 1111 && object instanceof ROWID) {
                    String string = resultSet.getString(n);
                    byte[] byArray = string.getBytes();
                    list2.add(new ROWID(byArray));
                } else if (resultSet.getMetaData().getColumnType(n) == 91 && resultSet instanceof OracleResultSet) {
                    list2.add(((OracleResultSet)resultSet).getDATE(n));
                } else if (object instanceof OracleResultSet) {
                    ArrayList arrayList4 = new ArrayList();
                    try {
                        OracleResultSet oracleResultSet = (OracleResultSet)object;
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        for (int i = 1; i <= oracleResultSet.getMetaData().getColumnCount(); ++i) {
                            arrayList2.add(oracleResultSet.getMetaData().getColumnName(i));
                        }
                        arrayList4.add(arrayList2);
                        while (oracleResultSet.next()) {
                            ArrayList arrayList3 = new ArrayList();
                            for (int i = 1; i <= oracleResultSet.getMetaData().getColumnCount(); ++i) {
                                this.cacheObjectInARow(arrayList3, i, (ResultSet)oracleResultSet);
                            }
                            arrayList4.add(arrayList3);
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    list2.add(arrayList4);
                } else {
                    list2.add(object);
                }
            }
        };
        try {
            this._runner.setTitle("Running Query");
            this._runner.setMessage("Fetching Results");
            this._runner.setCancelable(this._runInThread);
            this._runner.start(this._runInThread);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh() {
        this._cleanup();
        this.open();
    }

    protected int _getFetchSize() {
        return 50;
    }

    private static int getRSFetchSize(int n) {
        return Math.max(Math.min(n, 1000), 1);
    }

    public int[] getColSizes() {
        return this._colSizes;
    }

    public void setColSizes(int[] nArray) {
        this._colSizes = nArray;
    }

    public int[] getTypes() {
        return this._types;
    }

    public int getType(int n) {
        return this._types != null && this._types.length > n ? this._types[n] : 0;
    }

    public void setTypes(int[] nArray) {
        this._types = nArray;
    }

    public Query getQuery() {
        return this._query;
    }

    public boolean allFetched() {
        return this._allFetched;
    }

    public ResultSet getResultSet() {
        return this._rs;
    }

    public void setResultSet(ResultSet resultSet) {
        this._rs = resultSet;
    }

    public ResultSet getResultSetCopy() throws SQLException {
        return this.openResultSet();
    }

    public void setRunning(boolean bl) {
        this._isRunning = bl;
    }

    public boolean getRunning() {
        return this._isRunning;
    }

    public void setThreaded(boolean bl) {
        this._runInThread = bl;
    }

    public boolean getThreaded() {
        return this._runInThread;
    }

    public void setTranslatedColNames(boolean bl) {
        this._translatedColNames = bl;
    }

    public boolean isTranslatedColNames() {
        return this._translatedColNames;
    }

    public void setConn(Connection connection) {
        this.m_conn = connection;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public Database getDatabase() {
        return Connections.getInstance().getDatabase(this.m_conn);
    }

    public void setSql(String string) {
        this._sql = string;
        int n = string.toLowerCase().indexOf("from");
        this._tablename = n < 0 ? "" : string.substring(n + "from".length(), string.length()).trim();
    }

    protected String getSql() {
        return this._sql;
    }

    public void setBindList(List list) {
        this._bindList = list;
    }

    public List getBindList() {
        return this._bindList;
    }

    public void setBindMap(Map map) {
        this._bindMap = map;
    }

    public Map getBindMap() {
        return this._bindMap;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDisplay = bl;
    }

    public List<String> getSkipCols() {
        return this._skipCols;
    }

    public void setSkipCols(List<String> list) {
        this._skipCols.clear();
        for (String string : LINK_COLS) {
            this._skipCols.add(string);
        }
        if (list != null) {
            this._skipCols.addAll(list);
        }
    }

    public void setWhere(String string) {
        this._whereClause = string;
    }

    public String getWhere() {
        return this._whereClause;
    }

    public void setOrderBy(String string) {
        this._orderByClause = string;
    }

    public List<URL> getDrillUrls() {
        return this._drillUrls;
    }

    public String getConnName() {
        return Connections.getInstance().getConnectioName(this.m_conn);
    }

    public void setSchemaName(String string) {
        this._schemaName = string;
    }

    public boolean isExternalTable() {
        return this._isExternalTable;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String string) {
        this._sortDir = string;
    }

    public void setSortCol(int n) {
        if (this._sortCol == n && this._sortDir == SORT_A) {
            this._sortCol = n;
            this._sortDir = SORT_D;
        } else if (this._sortCol == n && this._sortDir == SORT_D) {
            this._sortCol = -1;
            this._sortDir = null;
        } else {
            this._sortDir = SORT_A;
            this._sortCol = n;
        }
    }

    public int getSortCol() {
        return this._sortCol;
    }

    public int getCol() {
        return this._col;
    }

    public int getLine() {
        return this._line;
    }

    public void setCol(int n) {
        this._col = n;
    }

    public void setLine(int n) {
        this._line = n;
    }

    public String getTableName() {
        return this._tablename;
    }
}

