/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.awt.Color;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModelBuffer;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.sql.ROWID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableResultSetTableModel
extends ResultSetTableModel {
    private Logger logger = Logger.getLogger(EditableResultSetTableModel.class.getName());
    private static final String EDITABLE_COLS = "select column_name from  all_updatable_columns where TABLE_NAME = :OBJECT_NAME and owner = :OBJECT_OWNER and updatable = 'YES'";
    private Statement _stmt;
    private ResultSetMetaData _rsmd;
    private ArrayList _log;
    private boolean _insertOnly;
    private String _modifiedSql;
    private boolean _changed;
    private boolean _valid = true;
    private int _colOffset;
    private boolean _dataIntegrity;
    private boolean _updatedByAnotherUser;
    private String _whereClause;
    private String _orderByClause;
    private NamedSwingWorker _worker;
    private String _nlsDateFormat;
    private String _tsFormat;
    private String _tstzFormat;
    private TableColumnModel _tabColModel;
    private String _dbObjectType = null;
    private ArrayList<String> _editableColNames;

    public EditableResultSetTableModel(Connection connection, ResultSet resultSet, String string, Database database, DBObject dBObject) {
        super(connection, resultSet, string, database, dBObject);
        try {
            this._rsmd = this._rs.getMetaData();
        }
        catch (Exception exception) {
            this._valid = false;
        }
        this._stmt = null;
        this._log = new ArrayList();
        this._insertOnly = false;
        this._changed = false;
        this._updatedByAnotherUser = false;
        this.setTranslatedColNames(false);
        this._dbObjectType = dBObject.getObjectType();
        this.setIsOracle(this.getConnName() != null ? Connections.getInstance().isOracle(this.getConnName()) : this.getConnection() instanceof OracleConnection);
    }

    @Override
    public boolean open() {
        return this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(boolean bl) {
        Connection connection = this.getConnection();
        synchronized (connection) {
            try {
                if (this._stmt == null) {
                    this._stmt = this.getConnection().createStatement();
                }
                if (this._rs == null || bl) {
                    try {
                        this._stmt.setMaxRows(0);
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                    this._rs = this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._sql));
                }
                if (Connections.getInstance().getConnection(this.getConnName()).getMetaData().getDatabaseMajorVersion() > 8) {
                    this._isExternalTable = this.isExternalTable(this._tablename);
                }
                if (this._isExternalTable) {
                    this._valid = false;
                }
                this._buildModifiedSql(bl);
                this._rs = this.isTimesTen() || this.isOracle() || ObjectFactory.getFactory(this.getConnName(), Connections.getInstance().getConnection(this.getConnName())).getConnectionTypeDescriptor().isRowIdSupported() ? this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._modifiedSql)) : this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._sql));
                this._createColumnNamesList();
                this._fetchNext(0);
                this.fireTableDataChanged();
            }
            catch (SQLException sQLException) {
                if (!bl) {
                    this.open(true);
                } else {
                    SQLErrorDialog.showErrorDialog(null, ConnectionArb.getString((int)195), sQLException);
                }
                return false;
            }
            catch (CMException cMException) {
                ExceptionHandler.handleException((Exception)((Object)cMException));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (this._rows != null) {
            Object object;
            if (n >= this._rows.size()) {
                object = this.LOCK;
                synchronized (object) {
                    if (this._worker == null) {
                        this._fetchNext(n - this._rows.size());
                    }
                }
            }
            if (n < this._rows.size() && (object = this._rows.get(n)) != null) {
                List list = null;
                if (object instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)object;
                    if (n2 == 0 && resultSetTableModelBuffer.getDeleted()) {
                        return new String("-" + (n + 1));
                    }
                    if (n2 == 0 && resultSetTableModelBuffer.getNew()) {
                        return new String("+" + (n + 1));
                    }
                    if (n2 == 0 && resultSetTableModelBuffer.getChanged()) {
                        return new String("*" + (n + 1));
                    }
                    list = resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew() ? resultSetTableModelBuffer.getChangedRow() : resultSetTableModelBuffer.getOriginalRow();
                } else {
                    list = (ArrayList)object;
                }
                if (n2 == 0) {
                    return new Integer(n + 1);
                }
                if (list != null) {
                    return list.get(n2 - 1);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this._isExternalTable) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        if (this._insertOnly && !this.isRowNew(n)) {
            return false;
        }
        if (this.isOracle() && this.getEditableColumnNames().size() == 0) {
            return false;
        }
        return !this.isOracle() || this.isColumnEditable(this.getColumnName(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        List<Object> list;
        if (this._rows != null && n >= this._rows.size()) {
            list = this.LOCK;
            synchronized (list) {
                if (this._worker == null) {
                    this._fetchNext(n - this._rows.size());
                }
            }
        }
        if (n2 == 0) {
            return;
        }
        if (n < this._rows.size()) {
            list = null;
            Object e = this._rows.get(n);
            ResultSetTableModelBuffer resultSetTableModelBuffer = null;
            if (e != null) {
                Object var7_8 = null;
                if (e instanceof ResultSetTableModelBuffer) {
                    resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    list = resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew() ? resultSetTableModelBuffer.getChangedRow() : new ArrayList<Object>(resultSetTableModelBuffer.getOriginalRow());
                } else {
                    ArrayList arrayList = (ArrayList)e;
                    list = (ArrayList)arrayList.clone();
                    resultSetTableModelBuffer = new ResultSetTableModelBuffer((ArrayList)e);
                }
            }
            if (!(list == null || list.get(n2 - 1) != null && DataTypesUtil.isEqual(list.get(n2 - 1), object, this.getConnection(), this.getType(n2 - 1)) || list.get(n2 - 1) == null && object.toString().length() == 0)) {
                list.set(n2 - 1, object);
                resultSetTableModelBuffer.setChangedRow(list);
                resultSetTableModelBuffer.setChanged(true);
                resultSetTableModelBuffer.setError(false);
                this._rows.set(n, resultSetTableModelBuffer);
                if (resultSetTableModelBuffer.getOriginalRow() != null && !ModelUtil.areDifferent(resultSetTableModelBuffer.getOriginalRow().get(n2 - 1), resultSetTableModelBuffer.getChangedRow().get(n2 - 1))) {
                    resultSetTableModelBuffer.reset();
                }
                this._changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save() {
        if (!this._valid) {
            return 1;
        }
        int n = 0;
        this._log.clear();
        Connection connection = this.getConnection();
        synchronized (connection) {
            int n2;
            ResultSetTableModelBuffer resultSetTableModelBuffer;
            Object e;
            if (this.isOracle()) {
                this._nlsDateFormat = NLSUtils.getDateFormat(this.getConnection());
                this._tsFormat = NLSUtils.getFormat(this.getConnection(), "NLS_TIMESTAMP_FORMAT");
                this._tstzFormat = NLSUtils.getFormat(this.getConnection(), "NLS_TIMESTAMP_TZ_FORMAT");
            }
            boolean bl = true;
            try {
                bl = this.getConnection().getAutoCommit();
                this.getConnection().setAutoCommit(false);
                if (this._stmt != null) {
                    this._stmt.close();
                }
                this._stmt = this.getConnection().createStatement();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this._insertOnly) {
                int n3;
                for (n3 = 0; n3 < this._rows.size(); ++n3) {
                    e = this._rows.get(n3);
                    if (e == null || !(e instanceof ResultSetTableModelBuffer) || !(resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getDeleted() || resultSetTableModelBuffer.getNew() || this.deleteRow(resultSetTableModelBuffer)) continue;
                    ++n;
                }
                for (n3 = 0; n3 < this._rows.size(); ++n3) {
                    e = this._rows.get(n3);
                    if (e == null || !(e instanceof ResultSetTableModelBuffer) || !(resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getChanged() || resultSetTableModelBuffer.getNew() || resultSetTableModelBuffer.getDeleted() || this.updateRow(resultSetTableModelBuffer)) continue;
                    ++n;
                }
            }
            for (n2 = 0; n2 < this._rows.size(); ++n2) {
                e = this._rows.get(n2);
                if (e == null || !(e instanceof ResultSetTableModelBuffer) || !(resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getNew() || !resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getDeleted() || this.insertRow(resultSetTableModelBuffer)) continue;
                ++n;
            }
            boolean bl2 = true;
            if (n > 0) {
                bl2 = false;
                try {
                    this.getConnection().rollback();
                }
                catch (SQLException sQLException) {}
            } else {
                try {
                    this.getConnection().commit();
                }
                catch (SQLException sQLException) {
                    bl2 = false;
                    n = 1;
                }
            }
            if (bl2 && this._dataIntegrity) {
                for (n2 = 0; n2 < this._rows.size(); ++n2) {
                    resultSetTableModelBuffer = this._rows.get(n2);
                    if (resultSetTableModelBuffer == null || !(resultSetTableModelBuffer instanceof ResultSetTableModelBuffer)) continue;
                    ResultSetTableModelBuffer resultSetTableModelBuffer2 = resultSetTableModelBuffer;
                    this.selectRowscn(resultSetTableModelBuffer2);
                }
            }
            if (bl2) {
                this.clearChanges();
            }
            this.fireTableDataChanged();
            try {
                this.getConnection().setAutoCommit(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public int rollback() {
        if (!this._valid) {
            return 1;
        }
        int n = 0;
        this._log.clear();
        for (int i = this._rows.size() - 1; i >= 0; --i) {
            Object e = this._rows.get(i);
            if (e == null || !(e instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            if (resultSetTableModelBuffer.getNew()) {
                this._rows.remove(i);
                continue;
            }
            resultSetTableModelBuffer.setChangedRow(null);
            resultSetTableModelBuffer.setChanged(false);
            resultSetTableModelBuffer.setError(false);
            resultSetTableModelBuffer.setDeleted(false);
            resultSetTableModelBuffer.setNew(false);
        }
        this._changed = false;
        this._updatedByAnotherUser = false;
        this.fireTableDataChanged();
        return n;
    }

    public boolean isRowDeleted(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getDeleted();
    }

    public boolean isRowChanged(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getChanged();
    }

    public boolean isRowNew(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getNew();
    }

    public boolean isRowError(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getError();
    }

    public String getErrorMessage(int n) {
        Object e;
        if (n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            return resultSetTableModelBuffer.getErrorMessage();
        }
        return null;
    }

    public boolean markRowDeleted(int n, boolean bl) {
        if (this._insertOnly) {
            return false;
        }
        if (n < this._rows.size()) {
            Object e = this._rows.get(n);
            if (e != null) {
                if (e instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    resultSetTableModelBuffer.setDeleted(bl);
                    resultSetTableModelBuffer.setError(false);
                } else {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = new ResultSetTableModelBuffer((ArrayList)e);
                    resultSetTableModelBuffer.setDeleted(bl);
                    this._rows.set(n, resultSetTableModelBuffer);
                }
            }
            this.fireTableDataChanged();
            this._changed = true;
        }
        return true;
    }

    public boolean addRow(int n) {
        ArrayList<String> arrayList = null;
        ResultSetTableModelBuffer resultSetTableModelBuffer = null;
        arrayList = new ArrayList<String>();
        for (int i = 1; i < this.getColumnCount(); ++i) {
            arrayList.add("");
        }
        resultSetTableModelBuffer = new ResultSetTableModelBuffer();
        resultSetTableModelBuffer.setChangedRow(arrayList);
        resultSetTableModelBuffer.setNew(true);
        resultSetTableModelBuffer.setChanged(true);
        return this.addRow(n, resultSetTableModelBuffer);
    }

    public boolean addRow(int n, ResultSetTableModelBuffer resultSetTableModelBuffer) {
        if (!this._valid) {
            return false;
        }
        this._rows.add(n, resultSetTableModelBuffer);
        this._changed = true;
        this.fireTableDataChanged();
        return true;
    }

    public ArrayList getLog() {
        return this._log;
    }

    public void setInsertOnly() {
        this._insertOnly = true;
    }

    /*
     * Exception decompiling
     */
    private boolean insertRow(ResultSetTableModelBuffer var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean updateRow(ResultSetTableModelBuffer var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 53[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteRow(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        block21: {
            Object object;
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
            stringBuffer.append(this._tablename + " WHERE ROWID = ");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            stringBuffer.append("?");
            stringBuffer2.append(this.quote(resultSetTableModelBuffer.getRowId()));
            if (this._dataIntegrity && !this._dbObjectType.equals("VIEW")) {
                stringBuffer.append(" AND ORA_ROWSCN = ?");
                stringBuffer2.append(" AND ORA_ROWSCN = " + this.quote(resultSetTableModelBuffer.getRowscn()));
                object = this.getColumnDBName(1);
                stringBuffer.append(" and ( " + (String)object + " is null or " + (String)object + " is not null )");
                stringBuffer2.append(" and /* workaround for base db bug */( " + (String)object + " is null or " + (String)object + " is not null )");
            }
            this._log.add(stringBuffer2.toString());
            object = null;
            try {
                int n;
                object = this.getConnection().prepareStatement(stringBuffer.toString());
                object.setString(1, resultSetTableModelBuffer.getRowId());
                if (this._dataIntegrity && !this._dbObjectType.equals("VIEW")) {
                    object.setString(2, resultSetTableModelBuffer.getRowscn());
                }
                if ((n = object.executeUpdate()) == 1) {
                    resultSetTableModelBuffer.setCommitted();
                    break block21;
                }
                if (n == 0) {
                    resultSetTableModelBuffer.setError(ConnectionArb.getString((int)593) + System.getProperty("line.separator"));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                Log.log(exception.getLocalizedMessage());
                resultSetTableModelBuffer.setError(exception.getLocalizedMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    public void clearChanges() {
        for (int i = this._rows.size() - 1; i >= 0; --i) {
            Object e = this._rows.get(i);
            if (e == null || !(e instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            if (resultSetTableModelBuffer.getDeleted() && (resultSetTableModelBuffer.getCommitted() || resultSetTableModelBuffer.getNew()) || resultSetTableModelBuffer.getNew() && !resultSetTableModelBuffer.getChanged()) {
                this._rows.remove(i);
                continue;
            }
            if (!resultSetTableModelBuffer.getChanged() && !resultSetTableModelBuffer.getNew()) continue;
            resultSetTableModelBuffer.clearChanges();
        }
        this._changed = false;
    }

    public boolean getChanged() {
        return this._changed;
    }

    public boolean getValid() {
        return this._valid;
    }

    public boolean getUpdatedByAnotherUser() {
        return this._updatedByAnotherUser;
    }

    public void setChanged(boolean bl) {
        this._changed = bl;
    }

    @Override
    public void setOrderBy(String string) {
        if (this._orderByClause != null && this._orderByClause.indexOf(",") > -1 && this.getSortCol() != -1) {
            this.setSortCol(-1);
        } else if (string != null && string.indexOf(",") == -1) {
            this.setSortCol(this.getOrderByColumn(string));
            this.setSortDirection(this.getOrderByDir(string));
        }
        this._orderByClause = string;
    }

    public void setOrderBy(int n) {
        int n2 = this._tabColModel.getColumn(n).getModelIndex();
        if (this._orderByClause != null && this._orderByClause.indexOf(",") > -1 && this.getSortCol() != -1) {
            this.setSortCol(-1);
        } else {
            this.setSortCol(n2);
        }
        this._orderByClause = n2 > 0 && this.getSortCol() != -1 ? this.getRawColumnName(n) + this.getSortDirection() : null;
    }

    private int getOrderByColumn(String string) {
        String string2 = string.substring(0, string.indexOf(" ")).replaceAll("\"", "");
        if (this._tabColModel.getColumn(this._colNames.indexOf(string2)) != null) {
            return this._tabColModel.getColumn(this._colNames.indexOf(string2)).getModelIndex();
        }
        return -1;
    }

    private String getOrderByDir(String string) {
        if (string.toUpperCase().lastIndexOf("DESC") > -1) {
            return " desc";
        }
        return " asc";
    }

    @Override
    public void setWhere(String string) {
        this._whereClause = string;
    }

    @Override
    protected void _fetchNext(final int n) {
        final int n2 = this._getFetchSize();
        final int n3 = this._colNames.size() + this._colOffset;
        final ResultSet resultSet = this._rs;
        final int n4 = this._colOffset;
        final boolean bl = this._dataIntegrity;
        final WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show(500L);
        if (this._rows == null) {
            this._rows = new ArrayList();
        }
        final List list = this._rows;
        this._worker = new NamedSwingWorker("Fetching"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                ArrayList<ResultSetTableModelBuffer> arrayList = new ArrayList<ResultSetTableModelBuffer>(n2);
                Object object = EditableResultSetTableModel.this.LOCK;
                synchronized (object) {
                    try {
                        for (int i = Math.max(n2, n); i > 0 && resultSet.next(); --i) {
                            ArrayList<Object> arrayList2 = new ArrayList<Object>();
                            for (int j = 1 + n4; j <= n3; ++j) {
                                int n5 = EditableResultSetTableModel.this.getType(j - (1 + n4));
                                Object object2 = null;
                                object2 = resultSet instanceof OracleResultSet ? ((OracleResultSet)resultSet).getOracleObject(j) : resultSet.getObject(j);
                                if (n5 == 1111 && object2 instanceof ROWID) {
                                    String string = resultSet.getString(j);
                                    byte[] byArray = string.getBytes();
                                    object2 = new ROWID(byArray);
                                } else if (object2 instanceof byte[]) {
                                    object2 = EditableResultSetTableModel.this.rawToHex((byte[])object2);
                                }
                                arrayList2.add(object2);
                            }
                            ResultSetTableModelBuffer resultSetTableModelBuffer = new ResultSetTableModelBuffer(arrayList2);
                            resultSetTableModelBuffer.setRowId(resultSet.getString(1));
                            if (bl && resultSet.getMetaData().getColumnName(2).equals("ORA_ROWSCN")) {
                                resultSetTableModelBuffer.setRowscn(resultSet.getString(2));
                            }
                            arrayList.add(resultSetTableModelBuffer);
                        }
                    }
                    catch (SQLException sQLException) {
                        EditableResultSetTableModel.this.logger.log(Level.SEVERE, "construct", sQLException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return arrayList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                Object object;
                try {
                    object = this.get();
                    if (object instanceof List) {
                        List list2 = (List)object;
                        int n5 = list2.size();
                        if (n5 > 0) {
                            list.addAll(list2);
                        }
                        if (n5 < n2) {
                            EditableResultSetTableModel.this._allFetched = true;
                            Log.status(Translate.translate("All Rows Fetched: ") + EditableResultSetTableModel.this.getRowCount());
                        } else {
                            Log.status(Translate.translate("Fetched Rows: ") + EditableResultSetTableModel.this.getRowCount());
                        }
                        EditableResultSetTableModel.this.fireTableDataChanged();
                    }
                }
                finally {
                    waitCursor.hide();
                    object = EditableResultSetTableModel.this.LOCK;
                    synchronized (object) {
                        EditableResultSetTableModel.this._worker = null;
                    }
                }
            }
        };
        this._worker.start();
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this._rows != null) {
            n = this._rows.size();
            if (!this._allFetched) {
                n += 5;
            }
        }
        return n;
    }

    private String formatValue(Object object) {
        if (object == null) {
            return " null ";
        }
        try {
            return this.getDatabase().quoteIdentifier(object.toString(), true);
        }
        catch (Exception exception) {
            return this.quote(object.toString());
        }
    }

    private String quote(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("'", "''");
        return "'" + string2 + "'";
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this._colNames = new ArrayList(n - 1);
        int[] nArray = new int[n - this._colOffset];
        int n2 = 0;
        for (int i = 1 + this._colOffset; i <= n; ++i) {
            this._colNames.add(resultSetMetaData.getColumnLabel(i));
            nArray[n2++] = resultSetMetaData.getColumnType(i);
        }
        this.setTypes(nArray);
    }

    private void _buildModifiedSql(boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        if (this._isExternalTable && !(this.getDatabase() instanceof Oracle10gR2) || this.isOracle() && this.getEditableColumnNames().size() == 0) {
            bl2 = true;
            bl = true;
        }
        if (!bl2) {
            stringBuffer.append("ROWID,");
            this._colOffset = 1;
        }
        if (this.getDatabase() instanceof Oracle10gR2 && !bl) {
            stringBuffer.append(" ORA_ROWSCN,");
            this._colOffset = 2;
            this._dataIntegrity = true;
        }
        resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append("\"" + resultSetMetaData.getColumnLabel(i) + "\"");
            int n2 = resultSetMetaData.getColumnType(i);
            if (n2 == 1111) {
                stringBuffer.append(" ||''  \"" + resultSetMetaData.getColumnLabel(i) + "\"");
            }
            if (i == n) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM " + this._tablename);
        if (this._whereClause != null && this._whereClause.length() > 0) {
            stringBuffer.append(" WHERE " + this._whereClause);
        }
        if (this._orderByClause != null && this._orderByClause.length() > 0) {
            stringBuffer.append(" ORDER BY " + this._orderByClause);
        }
        this._modifiedSql = stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectRowscn(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        String string = "SELECT ORA_ROWSCN FROM " + this._tablename + " WHERE ROWID = ?";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getConnection().prepareStatement(string);
            preparedStatement.setString(1, resultSetTableModelBuffer.getRowId());
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                return;
            }
            resultSetTableModelBuffer.setRowscn(resultSet.getString(1));
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public String getColumnDBName(int n) {
        int n2 = n;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this._tabColModel == null || this._tabColModel.getColumn(i).getModelIndex() != n) continue;
            n2 = i;
            break;
        }
        if (n <= 0 || n2 == -1) {
            return null;
        }
        return this.getRawColumnName(n2);
    }

    @Override
    public String getRawColumnName(int n) {
        return (String)this._colNames.get(n);
    }

    public Border getRowCountBorder(int n, int n2) {
        Object var3_3 = this._rows.size() > n ? this._rows.get(n) : null;
        Border border = null;
        if (var3_3 != null && var3_3 instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer resultSetTableModelBuffer = var3_3;
            if (n2 == 0 && resultSetTableModelBuffer.getDeleted()) {
                border = BorderFactory.createEtchedBorder(Color.RED, Color.BLACK);
            } else if (n2 == 0 && resultSetTableModelBuffer.getChanged()) {
                border = BorderFactory.createEtchedBorder(Color.BLUE, Color.BLACK);
            } else if (resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew()) {
                border = BorderFactory.createEtchedBorder(Color.GREEN, Color.BLACK);
            }
        }
        return border;
    }

    @Override
    public String getSQL() {
        if (this._modifiedSql != null) {
            return this._modifiedSql.replaceAll("ROWID,", "").replaceAll("ORA_ROWSCN,", "");
        }
        return null;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        this._tabColModel = tableColumnModel;
    }

    public boolean isColumnEditable(String string) {
        for (String string2 : this.getEditableColumnNames()) {
            if (!string2.intern().equals(string.intern())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getEditableColumnNames() {
        if (this._editableColNames == null) {
            this._editableColNames = new ArrayList();
            ResultSet resultSet = null;
            try {
                resultSet = DBUtil.getInstance().executeQuery(this.getConnection(), EDITABLE_COLS, this.getDBObject().getDictionary());
                while (resultSet.next()) {
                    this._editableColNames.add(resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return this._editableColNames;
    }
}

