/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;

public class MetaDataOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox _schema;
    private JCheckBox _segments;
    private JCheckBox _terminiator;
    private JCheckBox _pretty;
    private JCheckBox _byte;
    private JCheckBox _force;
    private JCheckBox _alter;
    private JCheckBox _data;
    private JCheckBox _drop;
    private FilePanel _file;

    public MetaDataOptionsPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this._file = new FilePanel(this);
        jPanel.add((Component)this._file, "West");
        UIUtils.makeTitledBorder(jPanel, "File");
        this.add((Component)jPanel, "North");
        this.add((Component)this.createCheckBoxes(), "Center");
    }

    private JPanel createCheckBoxes() {
        JPanel jPanel = new JPanel(new SpringLayout());
        this._schema = new JCheckBox(Translate.translate("Show Schema"));
        this._schema.setMnemonic(new Integer(83));
        this._segments = new JCheckBox(Translate.translate("Storage"));
        this._segments.setMnemonic(new Integer(71));
        this._terminiator = new JCheckBox(Translate.translate("Terminator"));
        this._terminiator.setMnemonic(new Integer(84));
        this._pretty = new JCheckBox(Translate.translate("Pretty Print"));
        this._pretty.setMnemonic(new Integer(80));
        this._byte = new JCheckBox(Translate.translate("Include BYTE keyword"));
        this._byte.setMnemonic(new Integer(73));
        this._force = new JCheckBox(Translate.translate("Add Force to Views"));
        this._force.setMnemonic(new Integer(70));
        this._alter = new JCheckBox(Translate.translate("Constraints as alters "));
        this._alter.setMnemonic(new Integer(67));
        this._data = new JCheckBox(Translate.translate("Export Data "));
        this._data.setMnemonic(new Integer(69));
        this._drop = new JCheckBox(Translate.translate("Include Drop Statements "));
        this._drop.setMnemonic(new Integer(68));
        this._schema.setSelected(true);
        this._terminiator.setSelected(true);
        this._pretty.setSelected(true);
        this._alter.setSelected(true);
        jPanel.add(this._schema);
        jPanel.add(this._segments);
        jPanel.add(this._terminiator);
        jPanel.add(this._pretty);
        jPanel.add(this._byte);
        jPanel.add(this._force);
        jPanel.add(this._alter);
        jPanel.add(this._data);
        jPanel.add(this._drop);
        UIUtils.makeTitledBorder(jPanel, "Options");
        SpringUtilities.makeCompactGrid(jPanel, 9, 1, 0, 0, 0, 5);
        return jPanel;
    }

    public boolean getSchema() {
        return this._schema.isSelected();
    }

    public boolean getSegments() {
        return this._segments.isSelected();
    }

    public boolean getPretty() {
        return this._pretty.isSelected();
    }

    public boolean getTerminator() {
        return this._terminiator.isSelected();
    }

    public boolean getByte() {
        return this._byte.isSelected();
    }

    public boolean getForce() {
        return this._force.isSelected();
    }

    public boolean getAlter() {
        return this._alter.isSelected();
    }

    public boolean getData() {
        return this._data.isSelected();
    }

    public boolean getDrop() {
        return this._drop.isSelected();
    }

    public String getFileName() {
        String string = this._file.getFileName();
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            n = 0;
        }
        String string2 = string.substring(n);
        String string3 = "";
        string3 = string2.lastIndexOf(".") > -1 ? this._file.getFileName() : this._file.getFileName() + ".sql";
        if (n == 0) {
            string3 = (String)DBConfig.getInstance().getParameter("EXPORTDIR") != null && !((String)DBConfig.getInstance().getParameter("EXPORTDIR")).equals("") ? (String)DBConfig.getInstance().getParameter("EXPORTDIR") + File.separator + string3 : System.getProperty("user.home") + File.separator + string3;
        }
        return string3;
    }
}

