/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.metadata.MetaDataSql;
import oracle.dbtools.raptor.metadata.MetaObject;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData<T> {
    public static Logger logger = Logger.getLogger(MetaData.class.toString());
    private MetaDataSql metaDataSql = new MetaDataSql();
    private boolean _cancel = false;
    private static String META_SETUP = "begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', :SEGMENTS);   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR', :TERMINATOR);  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY', :PRETTY);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD', :BYTE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE', :FORCE);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', :ALTER);  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA', :SHOWSCHEMA);end;";
    private static boolean _usePrefs = false;
    private boolean _segments = true;
    private boolean _terminiator = true;
    private boolean _pretty = true;
    private boolean _byte = true;
    private boolean _force = true;
    private boolean _alter = false;
    private boolean _schema = true;
    private boolean _data = false;
    private boolean _drop = false;
    private BufferedOutputStream _out;
    private OutputStreamWriter _dataOut;
    private Connection _conn;
    private double _dbVer;
    private ArrayList<MetaObject> _metaObjects = new ArrayList();

    public void setSegments(boolean bl) {
        this._segments = bl;
    }

    public void setByte(boolean bl) {
        this._byte = bl;
    }

    public void setforce(boolean bl) {
        this._force = bl;
    }

    public void setTerminator(boolean bl) {
        this._terminiator = bl;
    }

    public void setPretty(boolean bl) {
        this._pretty = bl;
    }

    public void setAlter(boolean bl) {
        this._alter = bl;
    }

    public void setData(boolean bl) {
        this._data = bl;
    }

    public void setDrop(boolean bl) {
        this._drop = bl;
    }

    public void setShowSchema(boolean bl) {
        this._schema = bl;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._out = new BufferedOutputStream(outputStream);
        try {
            this._dataOut = new OutputStreamWriter((OutputStream)this._out, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._dataOut = new OutputStreamWriter(this._out);
        }
    }

    public void closeOutputStream() {
        try {
            this._out.flush();
            this._dataOut.flush();
            this._out.close();
            this._dataOut.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() {
        if (this._out == null) {
            this.setOutputStream(System.out);
        }
        Statement statement = null;
        try {
            this._dbVer = Double.parseDouble(this._conn.getMetaData().getDatabaseMajorVersion() + "." + this._conn.getMetaData().getDatabaseMinorVersion());
            statement = this._conn.prepareCall(META_SETUP);
            if (_usePrefs) {
                statement.setBoolean(1, DBConfig.getInstance().getBoolean("DDL_SEGMENTS"));
                statement.setBoolean(2, DBConfig.getInstance().getBoolean("DDL_TERMINATOR"));
                statement.setBoolean(3, DBConfig.getInstance().getBoolean("DDL_PRETTY"));
                statement.setBoolean(4, DBConfig.getInstance().getBoolean("DDL_BYTE"));
                statement.setBoolean(5, DBConfig.getInstance().getBoolean("DDL_FORCE"));
                statement.setBoolean(6, DBConfig.getInstance().getBoolean("DDL_ALTER"));
                statement.setBoolean(7, DBConfig.getInstance().getBoolean("DDL_SCHEMA"));
            } else {
                statement.setBoolean(1, this._segments);
                statement.setBoolean(2, this._terminiator);
                statement.setBoolean(3, this._pretty);
                statement.setBoolean(4, this._byte);
                statement.setBoolean(5, this._force);
                statement.setBoolean(6, this._alter);
                statement.setBoolean(7, this._schema);
            }
            statement.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void setConnection(Connection connection) {
        this._conn = connection;
        try {
            this._dbVer = this._conn.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void addObject(String string, String string2, String string3) {
        this._metaObjects.add(new MetaObject(string, string2, string3));
    }

    public void addObject(String string, String string2) {
        this._metaObjects.add(new MetaObject(string, string2));
    }

    private void write(String string) throws IOException {
        this._dataOut.write(string);
        this._dataOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDDL() throws IOException {
        this.setup();
        long l = System.currentTimeMillis();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                MetaObject metaObject = (MetaObject)object;
                MetaObject metaObject2 = (MetaObject)object2;
                if (metaObject.getWeight() < metaObject2.getWeight()) {
                    return -1;
                }
                if (metaObject.getWeight() > metaObject2.getWeight()) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(this._metaObjects, comparator);
        for (MetaObject metaObject : this._metaObjects) {
            if (this._cancel) break;
            logger.info("Starting:" + metaObject.getName());
            long l2 = System.currentTimeMillis();
            InsertFormatter insertFormatter = new InsertFormatter();
            hashMap.clear();
            String string = null;
            try {
                hashMap.put("OWNER", metaObject.getSchema());
                hashMap.put("TYPE", metaObject.getType());
                if (!metaObject.isAll()) {
                    hashMap.put("NAME", metaObject.getName());
                } else {
                    hashMap.put("NAME", null);
                }
                string = this.metaDataSql.getSelect(this._dbVer, metaObject.getType(), metaObject.getName(), metaObject.getSchema()).replace("\n", " ");
                statement = this._conn.prepareStatement(string);
                DBUtil.getInstance().bind((PreparedStatement)statement, hashMap);
                resultSet = statement.executeQuery();
                logger.info("--------------------------------------------------------------------------");
                logger.info(string);
                logger.info("type - " + metaObject.getType() + " name -" + metaObject.getName() + " schema -" + metaObject.getSchema());
                while (resultSet.next() && !this._cancel) {
                    if (resultSet.getBytes(2) == null || resultSet.getString(4) == null) continue;
                    String string2 = resultSet.getString(2) + ":" + resultSet.getString(3) + ":" + resultSet.getString(4);
                    string2.intern();
                    if (arrayList.contains(string2)) {
                        logger.fine("Already Exported:" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                    logger.fine("Exporting:" + string2);
                    this.write("\nREM START " + resultSet.getString(2) + " " + resultSet.getString(3) + "\n");
                    if (this._drop && resultSet.getString(4) != null) {
                        if (this._schema) {
                            this.write("  DROP " + resultSet.getString(4) + " \"" + resultSet.getString(2) + "\".\"" + resultSet.getString(3) + "\";\n");
                        } else {
                            this.write("  DROP " + resultSet.getString(4) + " \"" + resultSet.getString(3) + "\";\n");
                        }
                    }
                    this.printDDL(metaObject.getType(), resultSet.getString(1));
                    if (this._data && resultSet.getString(4) != null && (resultSet.getString(4).equals("TABLE") || resultSet.getString(4).equals("VIEW"))) {
                        insertFormatter.setTableName(resultSet.getString(3));
                        insertFormatter.setSql(Connections.getInstance().getConnectioName(this._conn), "select * from " + resultSet.getString(2) + "." + resultSet.getString(3));
                        insertFormatter.setOutWriter(this._dataOut);
                        insertFormatter.print();
                    }
                    this.write("\nREM END " + resultSet.getString(2) + " " + resultSet.getString(3) + "\n");
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            logger.info("\tFinished:" + metaObject.getName());
            logger.info("\tElapsed:" + (System.currentTimeMillis() - l2) + "ms");
        }
        this._out.flush();
        logger.info("Elapsed:" + (System.currentTimeMillis() - l) + "ms");
    }

    private void printDDL(String string, String string2) throws IOException {
        this.write(string2);
    }

    public static String getDDL(DBObject dBObject, Boolean bl) {
        _usePrefs = bl;
        return MetaData.getDDL(dBObject);
    }

    public static String getDDL(DBObject dBObject) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetaData metaData = new MetaData();
        metaData.addObject(dBObject.getSchemaName(), dBObject.getObjectType(), dBObject.getObjectName());
        metaData.setConnection(dBObject.getConnection());
        metaData.setOutputStream(byteArrayOutputStream);
        try {
            metaData.printDDL();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string = null;
        try {
            string = byteArrayOutputStream.toString("utf8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    public int getQueuedCount() {
        return this._metaObjects.size();
    }

    public void reset() {
        this._metaObjects.clear();
    }

    public void setCancel(boolean bl) {
        this._cancel = bl;
    }
}

