/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.insight.InsightableDatabase;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InsightableOracleDatabase
implements InsightableDatabase {
    private Logger logger = Logger.getLogger(InsightableOracleDatabase.class.getName());
    private Connection _conn;
    private OracleDatabase _db;
    private BaseInsightableItem _tree;
    private volatile boolean _canceled;
    private static final String PUBLIC_SCHEMA = "PUBLIC";
    private static final String SQL_LIST_SCHEMAS = "SELECT username FROM sys.all_users ORDER BY username";
    private static final String SQL_ALL_OBJECT_LIST = "SELECT owner, object_name, object_type FROM sys.all_objects WHERE owner = :OWNER and object_type IN ('PACKAGE', 'PROCEDURE', 'SEQUENCE', 'TABLE', 'TYPE', 'VIEW', 'FUNCTION' ) ORDER BY object_type,object_name";
    private static final String SQL_ALL_SYNONYM_LIST = "SELECT s.owner, s.synonym_name, 'SYNONYM' as object_type FROM sys.all_synonyms s, sys.all_objects o WHERE s.table_name = o.object_name AND s.table_owner = o.owner AND object_type IN ('PACKAGE', 'PROCEDURE', 'SEQUENCE', 'TABLE', 'TYPE', 'VIEW', 'FUNCTION' ) ORDER BY s.owner, s.synonym_name";
    private static final String SQL_COLUMNS_FOR_TABLE = "SELECT column_name FROM sys.all_tab_columns WHERE owner = :OWNER and table_name = :OBJECT_NAME";
    private static final String SQL_LIST_PACKAGE_SUBPROGRAMS = "select object_name, decode( min( position ), 0, 'FUNCTION', 1, 'PROCEDURE', 'PROCEDURE' ) from sys.all_arguments WHERE owner = :OWNER AND package_name = :OBJECT_NAME group by object_name";
    private static final String SQL_LIST_OBJECT_METHODS = "select method_name, decode( results, 0, 'PROCEDURE', 1, 'FUNCTION', 'PROCEDURE' ) from sys.all_type_methods where owner=:OWNER and type_name=:OBJECT_NAME and method_type = 'PUBLIC'";
    private static final String SQL_LIST_OBJECT_ATTRIBUTES = "select attr_name from sys.all_type_attrs where owner = :OWNER and type_name = :OBJECT_NAME";
    private static final String SQL_LIST_PROCEDURES = "select object_name,argument_name,           decode(data_type,'PL/SQL TABLE',type_name,data_type) data_type,in_out            ,overload,sequence           from sys.all_arguments a    WHERE  owner = :OWNER     and    package_name = :OBJECT_NAME     order by overload,sequence";
    private static final String[] EMPTY_ARGS = new String[0];

    public InsightableOracleDatabase(OracleDatabase oracleDatabase) {
        this._db = oracleDatabase;
        try {
            this._conn = Connections.getInstance().getUniqueConnection(this._db.getConnectionName());
        }
        catch (CMException cMException) {
            // empty catch block
        }
        if (this._conn == null) {
            this._conn = this._db.getConnection();
        }
    }

    public void close() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = InsightableOracleDatabase.this._conn;
                synchronized (connection) {
                    try {
                        InsightableOracleDatabase.this._conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this._canceled = true;
        Thread thread = new Thread(runnable, "Insight Close Thread");
        thread.start();
    }

    @Override
    public Database getDatabase() {
        return this._db;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public boolean loadChildren(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        boolean bl = false;
        Iterator iterator = baseInsightableItem.getChildrenIterator();
        BaseInsightableItem baseInsightableItem2 = null;
        while (iterator.hasNext()) {
            baseInsightableItem2 = (BaseInsightableItem)iterator.next();
            if (!baseInsightableItem2.getName().equals(map.get("OBJECT_NAME")) || !baseInsightableItem2.getSchema().equals(map.get("OWNER")) || !baseInsightableItem2.getType().equals(map.get("OBJECT_TYPE"))) continue;
            bl = true;
        }
        if (!bl) {
            BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem(map.get("OBJECT_TYPE"), map.get("OWNER"), map.get("OBJECT_NAME"), baseInsightableItem);
            baseInsightableItem.putChild(baseInsightableItem3);
            String string = map.get("OBJECT_TYPE");
            if ("TABLE".equals(string) || "VIEW".equals(string)) {
                this._loadColumns(baseInsightableItem3, map);
            } else if ("SEQUENCE".equals(string)) {
                this._loadSequence(baseInsightableItem3, map);
            } else if ("PACKAGE".equals(string)) {
                this._loadPackage(baseInsightableItem3, map);
            } else if ("TYPE".equals(string)) {
                this._loadObject(baseInsightableItem3, map);
            } else if ("SCHEMA".equals(string)) {
                this._loadObjects(baseInsightableItem3, map);
            } else {
                this.logger.info("InsightableOracleDatabase loadChildren no code for type:" + string);
            }
            this.logger.info("InsightableOracleDatabase:loadChildren on " + baseInsightableItem.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addNumericBuiltinFunctions(BaseInsightableItem baseInsightableItem) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                DatabaseMetaData databaseMetaData = this._conn.getMetaData();
                BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(PUBLIC_SCHEMA);
                String string = databaseMetaData.getNumericFunctions();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                while (stringTokenizer.hasMoreTokens() && !this._canceled) {
                    String string2 = stringTokenizer.nextToken();
                    BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, string2);
                    baseInsightableItem2.putChild(baseInsightableItem3);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new SQLException(runtimeException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addStringBuiltinFunctions(BaseInsightableItem baseInsightableItem) throws SQLException {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                DatabaseMetaData databaseMetaData = this._conn.getMetaData();
                BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(PUBLIC_SCHEMA);
                String string = databaseMetaData.getStringFunctions();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    BaseInsightableItem baseInsightableItem3 = new BaseInsightableItem("FUNCTION", PUBLIC_SCHEMA, string2);
                    baseInsightableItem2.putChild(baseInsightableItem3);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new SQLException(runtimeException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _loadColumns(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        assert ("TABLE".equals(baseInsightableItem.getType()) || "VIEW".equals(baseInsightableItem.getType()) || "SYNONYM".equals(baseInsightableItem.getType())) : "EnsureTypeOfLoadColumns";
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string;
                resultSet = DBUtil.getInstance().executeQuery(this._conn, SQL_COLUMNS_FOR_TABLE, map);
                String string2 = baseInsightableItem.getSchema();
                while (resultSet.next() && !this._canceled) {
                    string = resultSet.getString(1);
                    BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem("COLUMN", string2, DBUtil.enquote(string));
                    baseInsightableItem.putChild(baseInsightableItem2);
                }
                string = new BaseInsightableItem("COLUMN", string2, "ROWID");
                baseInsightableItem.putChild((BaseInsightableItem)string);
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "_loadColumns.SQLException", sQLException);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "_loadColumns.SQLException", exception);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean _loadObjects(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        assert ("SCHEMA".equals(map.get("OBJECT_TYPE"))) : "EnsureTypeOfLoadColumns";
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                resultSet = DBUtil.getInstance().executeQuery(this._conn, SQL_ALL_OBJECT_LIST, map);
                String string = baseInsightableItem.getSchema();
                while (resultSet.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String string2 = resultSet.getString(1);
                    BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem(resultSet.getString(3), string, DBUtil.enquote(resultSet.getString(2)));
                    baseInsightableItem.putChild(baseInsightableItem2);
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "_loadObjects.SQLException", sQLException);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "_loadObjects.SQLException", exception);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private boolean _loadSequence(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        String string = baseInsightableItem.getSchema();
        String string2 = "CURRVAL";
        BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem("COLUMN", string, string2);
        baseInsightableItem.putChild(baseInsightableItem2);
        string2 = "NEXTVAL";
        baseInsightableItem2 = new BaseInsightableItem("COLUMN", string, string2);
        baseInsightableItem.putChild(baseInsightableItem2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean _loadPackage(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                resultSet = DBUtil.getInstance().executeQuery(this._conn, SQL_LIST_PROCEDURES, map);
                String string = baseInsightableItem.getSchema();
                Object var7_11 = null;
                String string2 = null;
                int n = 1;
                String string3 = null;
                StringBuffer stringBuffer = null;
                while (resultSet.next()) {
                    if (this._canceled) {
                        break;
                    }
                    if (!resultSet.getString(1).equals(string3) || n != resultSet.getInt(5)) {
                        if (string3 != null) {
                            String string4 = resultSet.getString(2);
                            BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem(string2, string, stringBuffer.length() == stringBuffer.lastIndexOf(",") + 1 ? stringBuffer.substring(0, stringBuffer.length() - 1).toString() + ")" : stringBuffer.toString() + ")");
                            baseInsightableItem.putChild(baseInsightableItem2);
                            stringBuffer = null;
                        }
                        string3 = resultSet.getString(1);
                        string2 = resultSet.getInt(6) == 0 && resultSet.getString(3) != null ? "FUNCTION" : "PROCEDURE";
                    }
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(resultSet.getString(1) + "(");
                    }
                    if (resultSet.getString(2) != null) {
                        stringBuffer.append(resultSet.getString(2) + ",");
                    }
                    n = resultSet.getInt(5);
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "_loadPackage.SQLException", sQLException);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "_loadPackage.SQLException", exception);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private boolean _loadObject(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        boolean bl = this._loadObjectAttributes(baseInsightableItem, map);
        boolean bl2 = this._loadObjectMethods(baseInsightableItem, map);
        return bl && bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean _loadObjectMethods(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                resultSet = DBUtil.getInstance().executeQuery(this._conn, SQL_LIST_OBJECT_METHODS, map);
                String string = baseInsightableItem.getSchema();
                while (resultSet.next()) {
                    if (this._canceled) {
                        break;
                    }
                    String string2 = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem(string3, string, DBUtil.enquote(string2));
                    baseInsightableItem.putChild(baseInsightableItem2);
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "_loadObjectMethods.SQLException", sQLException);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "_loadObjectMethods.Exception", exception);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _loadObjectAttributes(BaseInsightableItem baseInsightableItem, Map<String, String> map) {
        Connection connection = this._conn;
        synchronized (connection) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string;
                resultSet = DBUtil.getInstance().executeQuery(this._conn, SQL_LIST_OBJECT_ATTRIBUTES, map);
                String string2 = baseInsightableItem.getSchema();
                while (resultSet.next() && !this._canceled) {
                    string = resultSet.getString(1);
                    BaseInsightableItem baseInsightableItem2 = new BaseInsightableItem("COLUMN", string2, DBUtil.enquote(string));
                    baseInsightableItem.putChild(baseInsightableItem2);
                }
                string = new BaseInsightableItem("COLUMN", string2, "ROWID");
                baseInsightableItem.putChild((BaseInsightableItem)string);
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "_loadObjectMethods.SQLException", sQLException);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "_loadObjectMethods.SQLException", exception);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
            return true;
        }
    }

    @Override
    public BaseInsightableItem buildInsightableObjectTree() {
        if (this._tree == null) {
            this._tree = new BaseInsightableItem(null, "", "");
        }
        return this._tree;
    }

    @Override
    public boolean loadChildren(BaseInsightableItem baseInsightableItem) {
        return false;
    }
}

