/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.insight.AbstractListInsightData;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.DatabaseDataItem;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.insight.ListDataItemListModel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseListInsightData
extends AbstractListInsightData {
    final CompletionInsight _insight;
    private static final EditDescriptor _editDescriptor;
    private String _context = null;
    private String _schema;
    private String _name;
    private String _type;
    private Map<String, String> _binds;
    public static final String DATABASE_INSIGHT_PROPERTY = "database-insight-data";

    public DatabaseListInsightData(CompletionInsight completionInsight, Map<String, String> map) {
        this._insight = completionInsight;
        this._binds = map;
        URL uRL = this._insight.getURL();
        this.updateContext(this._binds);
    }

    @Override
    protected String getUserPrefix() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n3 = n - n2;
        String string = textBuffer.getString(n2, n3);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean complete(Object object) {
        DatabaseDataItem databaseDataItem = (DatabaseDataItem)((Object)object);
        String string = databaseDataItem.getName();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n3 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        basicEditorPane.beginEdit(DatabaseListInsightData.getEditDescriptor());
        try {
            basicDocument.remove(n2, n3 - n2);
            basicDocument.insertString(n2, string, null);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Exception occurred in completion: " + badLocationException);
            badLocationException.printStackTrace();
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partialComplete() {
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        basicDocument.readLock();
        try {
            int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
            int n3 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
            int n4 = n - n2;
            String string = textBuffer.getString(n2, n4);
            ListDataItemListModel listDataItemListModel = this.buildListModel();
            String string2 = listDataItemListModel.findCommonPrefix(string);
            if (string2.length() == 0) {
                return;
            }
            BasicEditorPane basicEditorPane = this._insight.getEditorPane();
            basicEditorPane.beginEdit(DatabaseListInsightData.getEditDescriptor());
            try {
                basicDocument.remove(n2, n3 - n2);
                basicDocument.insertString(n2, string2, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in partial completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    private BaseInsightableItem findItems(BaseInsightableItem baseInsightableItem, String string, String string2, String string3) {
        BaseInsightableItem baseInsightableItem2 = null;
        BaseInsightableItem baseInsightableItem3 = null;
        Iterator iterator = baseInsightableItem.getChildrenIterator();
        while (baseInsightableItem2 == null && iterator.hasNext()) {
            baseInsightableItem3 = (BaseInsightableItem)iterator.next();
            if (!baseInsightableItem3.getName().equals(string2) || !baseInsightableItem3.getSchema().equals(string) || !baseInsightableItem3.getType().equals(string3)) continue;
            baseInsightableItem2 = baseInsightableItem3;
        }
        return baseInsightableItem2;
    }

    public void updateContext(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OBJECT_NAME", string);
        this.updateContext(hashMap);
    }

    void updateContext(Map<String, String> map) {
        if (map.get("OBJECT_NAME") != null) {
            this._context = this._cleanContext(map.get("OBJECT_NAME"));
        }
        InsightableOracleDatabase insightableOracleDatabase = (InsightableOracleDatabase)this._insight.getDatabase();
        insightableOracleDatabase.loadChildren(this._insight.getBaseInsightableItem(), map);
        BaseInsightableItem baseInsightableItem = this._insight.getBaseInsightableItem();
        if (baseInsightableItem == null) {
            return;
        }
        String[] stringArray = new String[]{this._schema, this._type, this._name};
        BaseInsightableItem baseInsightableItem2 = this.findItems(baseInsightableItem, map.get("OWNER"), map.get("OBJECT_NAME"), map.get("OBJECT_TYPE"));
        if (baseInsightableItem2 == baseInsightableItem) {
            this.clearData();
        } else {
            this.setDataAtItem(baseInsightableItem2);
        }
    }

    String _cleanContext(String string) {
        String string2 = string.trim();
        if (string2.indexOf(46) == -1) {
            return "";
        }
        return string2.substring(0, string2.lastIndexOf(46));
    }

    BaseInsightableItem findItemInSearchRoot(BaseInsightableItem baseInsightableItem, String string) {
        return baseInsightableItem.getChild(string);
    }

    BaseInsightableItem findItemTopLevel(BaseInsightableItem baseInsightableItem, String string) {
        if (string == null) {
            return baseInsightableItem;
        }
        BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(string);
        if (baseInsightableItem2 != null) {
            return baseInsightableItem2;
        }
        baseInsightableItem2 = baseInsightableItem.getChild(this._schema);
        if (baseInsightableItem2 == null) {
            return baseInsightableItem.getChild(string);
        }
        BaseInsightableItem baseInsightableItem3 = baseInsightableItem2.getChild(string);
        if (baseInsightableItem3 == null) {
            baseInsightableItem2 = baseInsightableItem.getChild("PUBLIC");
            return baseInsightableItem2.getChild(string);
        }
        return baseInsightableItem3;
    }

    private void setDefaultRootData() {
        BaseInsightableItem baseInsightableItem = this._insight.getBaseInsightableItem();
        if (baseInsightableItem != null) {
            Iterator iterator = Collections.EMPTY_LIST.iterator();
            iterator = this._schema != null ? BaseInsightableItem.getSchemaLevelIterator((BaseInsightableItem)baseInsightableItem, (String)this._schema) : BaseInsightableItem.getTopLevelIterator((BaseInsightableItem)baseInsightableItem);
            this.setData(DatabaseDataItem.createDataItems(iterator));
        }
    }

    private void setDataAtItem(BaseInsightableItem baseInsightableItem) {
        BaseInsightableItem baseInsightableItem2 = this._insight.getBaseInsightableItem();
        if (baseInsightableItem == baseInsightableItem2) {
            this.setDefaultRootData();
        } else if (baseInsightableItem == null) {
            this.clearData();
        } else {
            if (!baseInsightableItem.isChildrenLoaded()) {
                this._insight.getDatabase().loadChildren(baseInsightableItem);
            }
            Iterator iterator = baseInsightableItem.getChildrenIterator();
            this.setData(DatabaseDataItem.createDataItems(iterator));
        }
    }

    private void clearData() {
        this.setData(DatabaseDataItem.EMPTY_LIST);
    }

    int getNameStartOffset(ReadTextBuffer readTextBuffer, int n) {
        char c;
        int n2;
        for (n2 = n - 1; n2 >= 0 && !DatabaseListInsightData.isPlSqlDelimiter(c = readTextBuffer.getChar(n2)); --n2) {
        }
        return n2 + 1;
    }

    int getNameEndOffset(ReadTextBuffer readTextBuffer, int n) {
        char c;
        int n2;
        int n3 = readTextBuffer.getLength();
        for (n2 = n; n2 < n3 && !DatabaseListInsightData.isPlSqlDelimiter(c = readTextBuffer.getChar(n2)); ++n2) {
        }
        return n2;
    }

    static boolean isPlSqlDelimiter(char c) {
        return CompletionInsight.isPlSqlDelimiter(c) || c == '.';
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    static {
        String string = Translate.translate("Undo Import");
        _editDescriptor = new EditDescriptor(string);
    }
}

