/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.DBDevExtensionResource;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.insight.DatabaseDataItem;
import oracle.dbtools.raptor.insight.DatabaseListInsightData;
import oracle.dbtools.raptor.insight.InsightableDatabase;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.options.InsightOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;

public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    private Logger logger = Logger.getLogger(CompletionInsight.class.getName());
    private Context _ctx;
    private String _connName;
    private Thread _loadingThread;
    private InsightableDatabase _db;
    private ListInsightView _view;
    private InsightData _lastLookup;
    private static Map<String, InsightableOracleDatabase> s_dbs = new HashMap<String, InsightableOracleDatabase>();
    private int lastContextStart;

    public CompletionInsight(Context context, Database database) {
        this._ctx = context;
        if (context.getNode() instanceof PlSqlNode && ((PlSqlNode)context.getNode()).getConnectionName() != null) {
            this._connName = ((PlSqlNode)context.getNode()).getConnectionName();
        } else if (context.getNode() instanceof PlSqlNode) {
            this._connName = DBURLFormatHelper.getConnectionName(context.getNode().getURL());
        } else if (context.getView() instanceof IDBEditor) {
            this._connName = ((IDBEditor)context.getView()).getConnectionName();
        }
        if (System.getProperty("sdev.insight", "true").equals("true") || !InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getCompletionEnablePopup()) {
            BaseInsightableItem baseInsightableItem;
            if (database instanceof OracleDatabase) {
                try {
                    this._db = this.getInsightableOracleDatabase(Connections.getInstance().getDatabase(this._connName));
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
            }
            if ((baseInsightableItem = this.getBaseInsightableItem()) == null) {
                try {
                    this._loadingThread = new Thread((Runnable)new InsightLoader(), "DB Insight Thread");
                    this._loadingThread.start();
                }
                catch (Exception exception) {}
            }
        } else {
            this.logger.info("Code Insight has been disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightableDatabase getInsightableOracleDatabase(Database database) {
        InsightableOracleDatabase insightableOracleDatabase = s_dbs.get(this._connName);
        if (insightableOracleDatabase == null) {
            insightableOracleDatabase = new InsightableOracleDatabase((OracleDatabase)database);
            Connection connection = insightableOracleDatabase.getConnection();
            CallableStatement callableStatement = null;
            try {
                callableStatement = connection.prepareCall("begin dbms_application_info.set_module(?,'Code Insight'); end;");
                callableStatement.setString(1, DBDevExtensionResource.getBundle("oracle.dbtools.raptor.DBDevExtensionResource").getString("EXTENSION_NAME"));
                boolean bl = callableStatement.execute();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            s_dbs.put(this._connName, insightableOracleDatabase);
        }
        return insightableOracleDatabase;
    }

    public CompletionInsight(Context context) {
        this(context, null);
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public boolean isInsightTriggerChar(char c) {
        return c == '.';
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        if (!this.isValidContext()) {
            return null;
        }
        this.lastContextStart = this.getContextStartOffset();
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        DatabaseListInsightData databaseListInsightData = null;
        String string = this.getDefaultInsightContext();
        try {
            String string2;
            this.logger.info("getInsightData: " + string);
            Map<String, String> map = DBUtil.getInstance().resolveName(this._connName, string);
            this.logger.info("Found base Object");
            if (!(map != null && map.get("OBJECT_NAME") != null || (string2 = this.findAliasedName(string)) == null || "".equals(string2) || (map = DBUtil.getInstance().resolveName(this._connName, string2)) == null)) {
                this.logger.info("Resolved:" + map.get("OBJECT_NAME") + ":" + map.get("OBJECT_TYPE") + ":" + map.get("OBJECT_OWNER"));
            }
            if ((map == null || map.get("OBJECT_NAME") == null) && string.indexOf(".") > 0) {
                int n = string.indexOf(".");
                this.logger.info("Checking : " + string.substring(0, string.indexOf(".")));
                map = DBUtil.getInstance().resolveName(this._connName, string.substring(0, string.indexOf(".")));
            }
            if ((map == null || map.get("OBJECT_NAME") == null) && string.indexOf(".") < 0) {
                this.logger.info("Checking : " + string);
                string2 = null;
                try {
                    string2 = Connections.getInstance().getConnection(this._connName).getMetaData().getUserName();
                }
                catch (SQLException sQLException) {
                    this.logger.severe("Could not get connection's username:" + sQLException.getMessage());
                }
                catch (CMException cMException) {
                    this.logger.severe("Could not get connection:" + cMException.getMessage());
                }
                map = string2 != null ? DBUtil.getInstance().resolveName(this._connName, string2) : DBUtil.getInstance().resolveName(this._connName, string);
            }
            if (map != null && map.get("OBJECT_NAME") != null) {
                databaseListInsightData = new DatabaseListInsightData(this, map);
                this._lastLookup = databaseListInsightData;
            } else {
                this.logger.info("Could not resolve:" + string);
            }
        }
        finally {
            waitCursor.hide();
        }
        return databaseListInsightData;
    }

    private String findAliasedName(String string) {
        int n;
        int n2;
        if (string.equals("")) {
            return null;
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '.') {
            string = string.substring(0, string.length() - 1);
        }
        TextBuffer textBuffer = this.getTextBuffer();
        int n3 = this.getCaretPosition();
        String string2 = new String();
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            n = textBuffer.getChar(n2);
            if (Character.isWhitespace((char)n)) {
                if (string2.equalsIgnoreCase("select")) break;
                string2 = new String();
                continue;
            }
            string2 = string2 + (char)n;
            stringBuilder.append((char)n);
        }
        string2 = new String();
        stringBuilder.delete(0, stringBuilder.length());
        int n4 = n2;
        for (n2 = n = n2 + 1; n2 < textBuffer.getLength(); ++n2) {
            char c = textBuffer.getChar(n2);
            if (Character.isWhitespace(c)) {
                if (string2.equalsIgnoreCase("where")) {
                    n4 = n2 - 5;
                    break;
                }
                n4 = textBuffer.getLength();
                string2 = new String();
                continue;
            }
            string2 = string2 + c;
            stringBuilder.append(c);
        }
        String string3 = textBuffer.getString(n, n4 - n).toLowerCase();
        int n5 = 0;
        if (string3.indexOf("from") > 0) {
            n5 = string3.indexOf("from") + 5;
        }
        string3 = string3.substring(n5, n4);
        string3 = string3.replaceAll("\\s+", " ");
        this.logger.info("Checking:" + string3);
        String[] stringArray = string3.split(" |,|\\(|;|\\W|\n");
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i <= 0 || !stringArray[i].equalsIgnoreCase(string)) continue;
            string4 = stringArray[i - 1];
        }
        return string4;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = this.getCaretPosition();
        this.logger.info("updateInsightData: " + this.getDefaultInsightContext());
        if (insightData instanceof DatabaseListInsightData) {
            if (this.getContextStartOffset() != this.lastContextStart) {
                return null;
            }
            DatabaseListInsightData databaseListInsightData = (DatabaseListInsightData)insightData;
            String string = this.getDefaultInsightContext();
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            DatabaseDataItem[] databaseDataItemArray = new DatabaseDataItem[databaseListInsightData.getData().length];
            int n2 = 0;
            for (Object object : insightData.getData()) {
                if (((DatabaseDataItem)((Object)object)).getName().indexOf(string2.toUpperCase()) != 0) continue;
                databaseDataItemArray[n2++] = (DatabaseDataItem)((Object)object);
            }
            return databaseListInsightData;
        }
        return insightData;
    }

    public InsightView getInsightView() {
        this._view = new ListInsightView();
        this._view.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    mouseEvent.getSource();
                    Object object = CompletionInsight.this._view.getSelectedValue();
                    if (object instanceof DatabaseDataItem) {
                        CompletionInsight.this._lastLookup.complete(object);
                    }
                }
            }
        });
        return this._view;
    }

    public URL getURL() {
        Node node = this._ctx != null ? this._ctx.getNode() : null;
        return node != null ? node.getURL() : null;
    }

    public InsightableDatabase getDatabase() {
        if (System.getProperty("sdev.insight", "true").equals("true") || !InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences()).getCompletionEnablePopup()) {
            if (this._db == null) {
                try {
                    OracleDatabase oracleDatabase = (OracleDatabase)Connections.getInstance().getDatabase(this._connName);
                    this._db = this.getInsightableOracleDatabase((Database)oracleDatabase);
                }
                catch (DBException dBException) {
                    ExceptionHandler.handleException((Exception)((Object)dBException));
                }
            }
        } else {
            this.logger.info("Code Insight has been disabled");
        }
        return this._db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized BaseInsightableItem getBaseInsightableItem() {
        if (this._loadingThread != null) {
            try {
                this._loadingThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this._loadingThread = null;
            }
        }
        BaseInsightableItem baseInsightableItem = (BaseInsightableItem)Connections.getInstance().getConnectionInfo(this._connName).get((Object)"database-insight-data");
        return baseInsightableItem;
    }

    static boolean isPlSqlDelimiter(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    int getContextStartOffset() {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = this.getCaretPosition();
        int n2 = CompletionInsight.getContextStartOffset((ReadTextBuffer)textBuffer, n);
        return n2;
    }

    static int getContextStartOffset(ReadTextBuffer readTextBuffer, int n) {
        char c;
        int n2;
        for (n2 = n - 1; n2 >= 0 && !CompletionInsight.isPlSqlDelimiter(c = readTextBuffer.getChar(n2)); --n2) {
        }
        return n2 + 1;
    }

    String getDefaultInsightContext() {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = this.getCaretPosition();
        int n2 = CompletionInsight.getContextStartOffset((ReadTextBuffer)textBuffer, n);
        int n3 = n - n2;
        String string = textBuffer.getString(n2, n3);
        this.logger.info("context = " + string);
        return string;
    }

    private boolean isValidContext() {
        int n;
        TextBuffer textBuffer = this.getTextBuffer();
        int n2 = this.getCaretPosition();
        Lexer lexer = PlsqlParser.createSqlLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(0);
        block4: while ((n = lexer.lex(lexerToken)) != 0) {
            int n3 = lexerToken.getStartOffset();
            int n4 = lexerToken.getEndOffset();
            if (n4 < n2) continue;
            if (n2 < n3 || n2 == n3) break;
            switch (n) {
                case 33: 
                case 49: {
                    if (n2 == n4) break block4;
                    return false;
                }
                case 48: {
                    return false;
                }
            }
        }
        return true;
    }

    static {
        Connections.getInstance().addConnectionListener(new AbstractConnectionListener(){

            public void connectionClosed(ConnectionEvent connectionEvent) {
                try {
                    InsightableOracleDatabase insightableOracleDatabase = (InsightableOracleDatabase)s_dbs.get(connectionEvent.getConnectionName());
                    if (insightableOracleDatabase != null) {
                        insightableOracleDatabase.getConnection().close();
                        s_dbs.remove(connectionEvent.getConnectionName());
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        });
    }

    private final class InsightLoader
    implements Runnable {
        private InsightLoader() {
        }

        public void run() {
            InsightableDatabase insightableDatabase;
            if (System.getProperty("sdev.insight", "true").equals("true") && (insightableDatabase = CompletionInsight.this.getDatabase()) != null) {
                BaseInsightableItem baseInsightableItem = insightableDatabase.buildInsightableObjectTree();
                Connections.getInstance().getConnectionInfo(CompletionInsight.this._connName).put((Object)"database-insight-data", (Object)baseInsightableItem);
            }
        }
    }
}

