/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

public class XMLFormatter
extends ResultsFormatter {
    private boolean _result = true;

    public XMLFormatter() {
        super("XML", Translate.translate("XML File"), "xml");
    }

    public void setResult(boolean bl) {
        this._result = bl;
    }

    public void start() throws IOException {
        this.write("<?xml version='1.0'  encoding='" + this.getEncode() + "' ?>" + this.getLineTerminator());
        this.write("<results>" + this.getLineTerminator());
    }

    public void startRow() throws IOException {
        this.write("\t<row>" + this.getLineTerminator());
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        if (n == 0 && this._result) {
            return;
        }
        this.write("\t\t<" + ((String)this._colNames.get(n2)).replace(' ', '_').replace('/', '_') + ">");
        this.write("<![CDATA[");
        if (object != null) {
            this.write(this.getValue(object).toString());
        }
        this.write("]]>");
        this.write("</" + ((String)this._colNames.get(n2)).replace(' ', '_') + ">" + this.getLineTerminator());
    }

    public void endRow() throws IOException {
        this.write("\t</row>" + this.getLineTerminator());
    }

    public void end() throws IOException {
        this.write("</results>");
    }

    public void setTableName(String string) {
    }
}

