/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.jdbc.OracleResultSet;
import oracle.sql.DATE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultsFormatter
implements IResultFormatter {
    protected int _format;
    protected OutputStreamWriter _out;
    protected int[] _colSizes;
    protected ArrayList<String> _colNames;
    protected JTable _table;
    protected IProgressFeedback _feedback;
    protected String _type;
    protected String _filter;
    protected String _ext;
    protected Boolean _prompt = false;
    private String _conn;
    private String _sql;
    private ResultSet _rs;
    private ResultSetMetaData _meta;
    private int _max_rows_allowed = -1;
    protected String _nullValue = "";
    private boolean _interrupt = false;
    private OutputStream _outStream;
    private String _enc;
    private String _EOLChars;

    public ResultsFormatter(String string, String string2, String string3) {
        this._type = string;
        this._ext = string3;
        this._filter = string2;
    }

    @Override
    public String getEncode() {
        return this._enc;
    }

    @Override
    public void setEncode(String string) {
        this._enc = string;
    }

    @Override
    public Boolean getPromptForTable() {
        return this._prompt;
    }

    @Override
    public void setPromptForTable(Boolean bl) {
        this._prompt = bl;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getExt() {
        return this._ext;
    }

    @Override
    public String getFilter() {
        return this._filter;
    }

    @Override
    public void setResultSet(ResultSet resultSet) {
        this._rs = resultSet;
        this.setRSHeaders(resultSet);
    }

    @Override
    public void setJTable(JTable jTable) {
        this._table = jTable;
        this.setJTableHeaders();
    }

    @Override
    public void setSql(String string, String string2) {
        this._sql = string2;
        this._conn = string;
        this._rs = null;
        this.setSQLHeaders();
    }

    @Override
    public void setRSHeaders(ResultSet resultSet) {
        this._rs = resultSet;
        this.setSQLHeaders();
    }

    @Override
    public void setSQLHeaders() {
        this._colNames = new ArrayList();
        this._colNames.add("");
        if (this._rs == null && this._conn != null && this._sql != null) {
            this._rs = DBUtil.getInstance().executeQuery(this._conn, this._sql, (List)null);
        }
        try {
            this._meta = ((PreparedStatement)this._rs.getStatement()).getMetaData();
            this._colSizes = new int[this._meta.getColumnCount() + 1];
            for (int i = 1; i < this._meta.getColumnCount() + 1; ++i) {
                this._colNames.add(this._meta.getColumnName(i));
                this._colSizes[i] = this._meta.getColumnType(i) == 91 || this._meta.getColumnType(i) == 92 || this._meta.getColumnType(i) == 93 ? 25 : this._meta.getColumnName(i).length();
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
    }

    @Override
    public void setJTableHeaders() {
        ResultSetTableModel resultSetTableModel;
        this._colNames = new ArrayList();
        int n = this._table.getModel().getColumnCount();
        this._colSizes = new int[n];
        ResultSetTableModel resultSetTableModel2 = resultSetTableModel = this._table.getModel() instanceof ResultSetTableModel ? (ResultSetTableModel)this._table.getModel() : null;
        if (resultSetTableModel != null) {
            this._colSizes[0] = 25;
        }
        for (int i = 0; i < n; ++i) {
            if (resultSetTableModel != null) {
                if (resultSetTableModel.getTypes().length >= n) {
                    this._colSizes[i] = resultSetTableModel.getTypes()[i] == 91 || resultSetTableModel.getTypes()[i] == 92 || resultSetTableModel.getTypes()[i] == 93 ? 25 : (resultSetTableModel.getColSizes()[i] < this._table.getModel().getColumnName(i).length() ? this._table.getModel().getColumnName(i).length() : ((ResultSetTableModel)this._table.getModel()).getColSizes()[i]);
                }
            } else {
                this._colSizes[i] = this._table.getModel().getColumnName(i).length();
            }
            String string = this._table.getModel().getColumnName(i);
            this._colNames.add(string);
        }
    }

    public void print(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
        this.print();
    }

    @Override
    public void printWithDialog() {
        final ResultsFormatter resultsFormatter = this;
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            protected void doCancel() {
                super.doCancel();
                resultsFormatter.interrupt();
            }

            protected Object doWork() throws Exception {
                resultsFormatter.print();
                ResultsFormatter.this._out.close();
                return null;
            }
        };
        IProgressFeedback iProgressFeedback = new IProgressFeedback(){

            public void feedback(String string) {
                Log.status(string);
            }
        };
        resultsFormatter.setFeedback(iProgressFeedback);
        progressRunnable.setTitle(Translate.translate("Exporting..."));
        progressRunnable.setCancelable(true);
        try {
            progressRunnable.start(true);
        }
        catch (ProgressException progressException) {
            progressException.printStackTrace();
        }
    }

    @Override
    public int print() {
        int n = 0;
        try {
            if (this._table != null && this._table.getModel() instanceof ResultSetTableModel) {
                ((ResultSetTableModel)this._table.getModel()).fetchAll();
                n = this.printTable();
            } else {
                n = this._rs != null ? this.printSQL() : this.printTable();
            }
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
        }
        return n;
    }

    public int printSQL() throws IOException {
        int n = 0;
        this.start();
        try {
            while (this._rs.next() && !this._interrupt) {
                this.log(Translate.translate("Row:" + this._rs.getRow()));
                this.startRow();
                for (int i = 0; i < this._meta.getColumnCount(); ++i) {
                    this.printColumn(this._rs.getObject(i + 1), i + 1, i + 1);
                }
                this.endRow();
                n = this._rs.getRow();
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException);
        }
        this.end();
        return n;
    }

    public int printResultSetTableModel() throws Exception {
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this._table.getModel();
        this._rs = resultSetTableModel.getResultSet();
        if (resultSetTableModel.allFetched()) {
            return this.printTable();
        }
        this._rs = resultSetTableModel.getResultSet();
        return this.printResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int printResultSet() throws IOException {
        int n = 0;
        try {
            this.start();
            int n2 = 0;
            this._rs.setFetchSize(100);
            while (this._rs.next() && !this._interrupt && (this._max_rows_allowed == -1 || this._max_rows_allowed <= this._rs.getRow())) {
                this.log(Translate.translate("Row:" + this._rs.getRow()));
                this.startRow();
                this.printColumn(this._rs.getRow(), 0, 0);
                for (n2 = 1; n2 <= this._colNames.size() - 1; ++n2) {
                    this.printColumn(this.getValue(((OracleResultSet)this._rs).getOracleObject(n2)), n2, n2);
                }
                this.endRow();
            }
            n = this._rs.getRow();
            this.end();
            if (this._max_rows_allowed != -1 && this._max_rows_allowed <= this._rs.getRow()) {
                this.write("Only " + this._max_rows_allowed + " rows currently supported in a script results".getBytes());
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        finally {
            try {
                this._rs.getStatement().close();
            }
            catch (SQLException sQLException) {}
            try {
                this._rs.close();
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    public int printTable() throws IOException {
        TableModel tableModel = this._table.getModel();
        this.fetchAllRows(tableModel);
        int n = tableModel.getRowCount();
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        this.start();
        for (int i = 0; i < n && !this._interrupt; ++i) {
            this.log(Translate.translate("Row:" + i));
            this.startRow();
            for (int j = 0; j < tableColumnModel.getColumnCount(); ++j) {
                this.printColumn(this.getValue(tableModel.getValueAt(i, tableColumnModel.getColumn(j).getModelIndex())), j + 1, tableColumnModel.getColumn(j).getModelIndex());
            }
            this.endRow();
        }
        this.end();
        return tableModel.getRowCount();
    }

    private void fetchAllRows(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        if (tableModel instanceof ResultSetTableModel) {
            ((ResultSetTableModel)tableModel).fetchAll();
        }
    }

    protected void write(String string) throws IOException {
        if (string != null) {
            this._out.write(string);
        }
    }

    protected void log(String string) {
        if (this._feedback != null) {
            this._feedback.feedback(string);
        }
    }

    @Override
    public OutputStreamWriter getOutWriter() {
        return this._out;
    }

    @Override
    public void setOutWriter(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._outStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this._outStream = outputStream;
        if (this._enc != null) {
            try {
                this._out = new OutputStreamWriter(outputStream, this._enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._out = new OutputStreamWriter(outputStream);
            }
        }
    }

    public JTable getTable() {
        return this._table;
    }

    public IProgressFeedback getFeedback() {
        return this._feedback;
    }

    public void setFeedback(IProgressFeedback iProgressFeedback) {
        this._feedback = iProgressFeedback;
    }

    public void interrupt() {
        this._interrupt = true;
    }

    protected Object getValue(Object object) {
        try {
            if (this._rs != null) {
                return DataTypesUtil.stringValue(object, this._rs.getStatement().getConnection());
            }
            if (this._conn != null) {
                return DataTypesUtil.stringValue(object, this.getConnection());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public int getDataType(int n) {
        int n2 = -1;
        try {
            if (this._table != null && this._table.getModel() instanceof ResultSetTableModel) {
                n2 = ((ResultSetTableModel)this._table.getModel()).getType(n - 1);
            } else if (this._rs != null) {
                n2 = this._rs.getMetaData().getColumnType(n);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n2;
    }

    public String getTimeStampFormat() {
        if (this._table == null) {
            try {
                return NLSUtils.getTimeStampFormat(this._rs.getStatement().getConnection());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return null;
            }
        }
        return NLSUtils.getTimeStampFormat(((ResultSetTableModel)this._table.getModel()).getConnection());
    }

    public String getTimeStampTZFormat() {
        if (this._table == null) {
            try {
                return NLSUtils.getTimeStampTZFormat(this._rs.getStatement().getConnection());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return null;
            }
        }
        return NLSUtils.getTimeStampTZFormat(((ResultSetTableModel)this._table.getModel()).getConnection());
    }

    public String getDateFormat() {
        if (this._table == null) {
            try {
                return NLSUtils.getDateFormat(this._rs.getStatement().getConnection());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return null;
            }
        }
        return NLSUtils.getDateFormat(((ResultSetTableModel)this._table.getModel()).getConnection());
    }

    public String getFormattedDATE(Object object) {
        try {
            return NLSUtils.formatDate(((ResultSetTableModel)this._table.getModel()).getConnName(), (DATE)object);
        }
        catch (SQLException sQLException) {
            return object.toString();
        }
    }

    public ArrayList<String> getColumns() {
        return this._colNames;
    }

    public void setConn(String string) {
        this._conn = string;
    }

    public Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this._conn);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getLineTerminator() {
        if (this._EOLChars == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOLChars = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOLChars;
    }
}

